/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public enum Direction {
    NORTH,
    NORTHEAST,
    EAST,
    SOUTHEAST,
    SOUTH,
    SOUTHWEST,
    WEST,
    NORTHWEST;

    private static int[] dLat;
    private static int[] dLon;
    private static Direction[] values;

    public String toString() {
        return WordUtils.capitalizeFully((String)this.name());
    }

    public double bearing() {
        return this.ordinal() * 45;
    }

    public Direction opposite() {
        return this.valueOf((this.ordinal() + 4) % 8);
    }

    public Direction next() {
        return this.valueOf((this.ordinal() + 1) % 8);
    }

    public Direction prev() {
        return this.valueOf((this.ordinal() + 7) % 8);
    }

    public int signLatMove() {
        return dLat[this.ordinal()];
    }

    public int signLonMove() {
        return dLon[this.ordinal()];
    }

    private Direction valueOf(int ordinal) {
        return values[ordinal];
    }

    public static void main(String[] args) {
        for (Direction d : Direction.values()) {
            Object[] dat = new Object[]{d.name(), d, d.ordinal(), d.opposite(), d.prev(), d.next()};
            System.out.println(StringUtils.join((Object[])dat, (String)" "));
        }
    }

    static {
        dLat = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
        dLon = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
        values = Direction.values();
    }
}

