/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import org.dom4j.Element;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.metadata.XMLSaveable;

@JsonAdapter(value=Adapter.class)
public class Location
implements Serializable,
XMLSaveable,
Cloneable,
Comparable<Location> {
    private static final long serialVersionUID = 2L;
    public static final String XML_METADATA_NAME = "Location";
    public static final String XML_METADATA_LONGITUDE = "Longitude";
    public static final String XML_METADATA_LATITUDE = "Latitude";
    public static final String XML_METADATA_DEPTH = "Depth";
    private static final boolean FORCE_BACKWARDS_COMPATIBLE = false;
    public final double lat;
    public final double lon;
    final double latRad;
    final double lonRad;
    public final double depth;

    public Location(double lat, double lon) {
        this(lat, lon, 0.0);
    }

    public Location(double lat, double lon, double depth) {
        GeoTools.validateLat(lat);
        GeoTools.validateLon(lon);
        GeoTools.validateDepth(depth);
        this.lat = lat;
        this.lon = lon;
        this.latRad = Math.toRadians(lat);
        this.lonRad = Math.toRadians(lon);
        this.depth = depth;
    }

    public static Location backwardsCompatible(double lat, double lon) {
        return Location.backwardsCompatible(lat, lon, 0.0);
    }

    public static Location backwardsCompatible(Location loc) {
        return Location.backwardsCompatible(loc.lat, loc.lon, loc.depth);
    }

    public static Location backwardsCompatible(double lat, double lon, double depth) {
        double latRad = lat * GeoTools.TO_RAD;
        double lonRad = lon * GeoTools.TO_RAD;
        double latDeg = latRad * GeoTools.TO_DEG;
        double lonDeg = lonRad * GeoTools.TO_DEG;
        return new Location(latDeg, lonDeg, latRad, lonRad, depth);
    }

    private Location(double latDeg, double lonDeg, double latRad, double lonRad, double depth) {
        this.lat = latDeg;
        this.lon = lonDeg;
        this.latRad = latRad;
        this.lonRad = lonRad;
        this.depth = depth;
    }

    public final double getDepth() {
        return this.depth;
    }

    public final double getLatitude() {
        return this.lat;
    }

    public final double getLongitude() {
        return this.lon;
    }

    public double getLatRad() {
        return this.latRad;
    }

    public double getLonRad() {
        return this.lonRad;
    }

    public String toKML() {
        StringBuffer b = new StringBuffer();
        b.append(this.getLongitude());
        b.append(",");
        b.append(this.getLatitude());
        b.append(",");
        b.append(this.getDepth());
        return b.toString();
    }

    public String toString() {
        return String.format("%.5f, %.5f, %.5f", this.getLatitude(), this.getLongitude(), this.getDepth());
    }

    public Location clone() {
        Location clone = new Location(this.lat, this.lon, this.latRad, this.lonRad, this.depth);
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location loc = (Location)obj;
        if (this.lat != loc.lat) {
            return false;
        }
        if (this.lon != loc.lon) {
            return false;
        }
        return this.depth == loc.depth;
    }

    public int hashCode() {
        long latHash = Double.doubleToLongBits(this.lat);
        long lonHash = Double.doubleToLongBits(this.lon + 1000.0);
        long depHash = Double.doubleToLongBits(this.depth + 2000.0);
        long v = latHash + lonHash + depHash;
        return (int)(v ^ v >>> 32);
    }

    @Override
    public int compareTo(Location loc) {
        double d;
        double d2 = d = this.lat == loc.lat ? this.lon - loc.lon : this.lat - loc.lat;
        return d != 0.0 ? (d < 0.0 ? -1 : 1) : 0;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        xml.addAttribute(XML_METADATA_LATITUDE, "" + this.getLatitude());
        xml.addAttribute(XML_METADATA_LONGITUDE, "" + this.getLongitude());
        xml.addAttribute(XML_METADATA_DEPTH, "" + this.getDepth());
        return root;
    }

    public static Location fromXMLMetadata(Element root) {
        double lat = Double.parseDouble(root.attribute(XML_METADATA_LATITUDE).getValue());
        double lon = Double.parseDouble(root.attribute(XML_METADATA_LONGITUDE).getValue());
        double depth = Double.parseDouble(root.attribute(XML_METADATA_DEPTH).getValue());
        return new Location(lat, lon, depth);
    }

    public static class Adapter
    extends TypeAdapter<Location> {
        public void write(JsonWriter out, Location value) throws IOException {
            out.beginArray();
            out.value(value.lat).value(value.lon);
            if (value.depth != 0.0) {
                out.value(value.depth);
            }
            out.endArray();
        }

        public Location read(JsonReader in) throws IOException {
            int ind = 0;
            double lat = Double.NaN;
            double lon = Double.NaN;
            double depth = 0.0;
            in.beginArray();
            while (in.hasNext()) {
                double val = in.nextDouble();
                if (ind == 0) {
                    lat = val;
                } else if (ind == 1) {
                    lon = val;
                } else if (ind == 2) {
                    depth = val;
                } else {
                    throw new IllegalStateException("Location JSON must have 2 or 3 values");
                }
                ++ind;
            }
            in.endArray();
            return new Location(lat, lon, depth);
        }
    }
}

