/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;

public final class PlaneUtils {
    public static final double[] VX_UNIT_NORMAL = new double[]{1.0, 0.0, 0.0};
    public static final double[] VY_UNIT_NORMAL = new double[]{0.0, 1.0, 0.0};
    public static final double[] VZ_UNIT_NORMAL = new double[]{0.0, 0.0, 1.0};

    private PlaneUtils() {
    }

    public static double[] getCentroid(double[][] verticesIn) {
        double[] centroid = new double[3];
        int i = 0;
        while (i < 3) {
            centroid[i] = 0.0;
            for (int j = 0; j < 3; ++j) {
                int n = i;
                centroid[n] = centroid[n] + verticesIn[j][i];
            }
            int n = i++;
            centroid[n] = centroid[n] / 3.0;
        }
        return centroid;
    }

    public static long[] getCentroidLong(double[][] verticesIn) {
        double[] input = PlaneUtils.getCentroid(verticesIn);
        long[] centroid = new long[3];
        for (int i = 0; i < 3; ++i) {
            centroid[i] = (long)input[i];
        }
        return centroid;
    }

    public static double[] getStrikeAndDip(double[][] verticesIn) {
        double[] strikeDip = new double[2];
        double[] vNormal = PlaneUtils.getNormalVector(verticesIn);
        double[] vStrike = new double[3];
        vStrike = PlaneUtils.getCrossProduct(VZ_UNIT_NORMAL, vNormal, false);
        strikeDip[0] = PlaneUtils.calculateStrike(vStrike);
        strikeDip[1] = Math.toDegrees(Math.asin(PlaneUtils.getMagnitude(vStrike) / PlaneUtils.getMagnitude(vNormal)));
        return strikeDip;
    }

    public static double[] getStrikeAndDip(Location loc1, Location loc2, Location loc3) {
        double dLat12 = loc2.getLatitude() - loc1.getLatitude();
        double dLat13 = loc3.getLatitude() - loc1.getLatitude();
        double dLat23 = loc3.getLatitude() - loc2.getLatitude();
        double dLon12 = loc2.getLongitude() - loc1.getLongitude();
        double dLon13 = loc3.getLongitude() - loc1.getLongitude();
        double dLon23 = loc3.getLongitude() - loc2.getLongitude();
        if (dLat12 > 1.0 || dLat13 > 1.0 || dLat23 > 1.0 || dLon12 > 1.0 || dLon13 > 1.0 || dLon23 > 1.0) {
            throw new IllegalArgumentException("Supplied Locations are more than 1 degree apart.");
        }
        double[][] vertices = new double[][]{{0.0, 0.0, -loc1.getDepth()}, {PlaneUtils.deltaLonKM(loc1, loc2), PlaneUtils.deltaLatKM(loc1, loc2), -loc2.getDepth()}, {PlaneUtils.deltaLonKM(loc1, loc3), PlaneUtils.deltaLatKM(loc1, loc3), -loc3.getDepth()}};
        return PlaneUtils.getStrikeAndDip(vertices);
    }

    private static double deltaLonKM(Location loc1, Location loc2) {
        double dLon = loc2.getLongitude() - loc1.getLongitude();
        double avgLat = (loc2.getLatitude() + loc1.getLatitude()) / 2.0;
        Location loc = new Location(avgLat, 0.0);
        return dLon / GeoTools.degreesLonPerKm(loc);
    }

    private static double deltaLatKM(Location loc1, Location loc2) {
        double dLat = loc2.getLatitude() - loc1.getLatitude();
        double avgLat = (loc2.getLatitude() + loc1.getLatitude()) / 2.0;
        Location loc = new Location(avgLat, 0.0);
        return dLat / GeoTools.degreesLatPerKm(loc);
    }

    public static void main(String[] args) {
        Location l1 = new Location(0.0, 0.0, 0.0);
        Location l2 = new Location(1.0, 1.0, 0.0);
        Location l3 = new Location(0.0, 1.0, 110.0);
        double[] sd = PlaneUtils.getStrikeAndDip(l1, l2, l3);
        System.out.println("Strike: " + sd[0] + " Dip: " + sd[1]);
        l1 = new Location(45.0, 0.0, 0.0);
        l2 = new Location(46.0, 1.0, 0.0);
        l3 = new Location(45.0, 1.0, 110.0);
        sd = PlaneUtils.getStrikeAndDip(l1, l2, l3);
        System.out.println("Strike: " + sd[0] + " Dip: " + sd[1]);
        l1 = new Location(89.0, 0.0, 0.0);
        l2 = new Location(90.0, 1.0, 0.0);
        l3 = new Location(89.0, 1.0, 110.0);
        sd = PlaneUtils.getStrikeAndDip(l1, l2, l3);
        System.out.println("Strike: " + sd[0] + " Dip: " + sd[1]);
        l1 = new Location(-1.0, -1.0, 0.0);
        l2 = new Location(0.0, 0.0, 0.0);
        l3 = new Location(-1.0, 0.0, 110.0);
        sd = PlaneUtils.getStrikeAndDip(l1, l2, l3);
        System.out.println("Strike: " + sd[0] + " Dip: " + sd[1]);
        l1 = new Location(0.0, 0.0, 0.0);
        l2 = new Location(-1.0, -1.0, 0.0);
        l3 = new Location(-1.0, 0.0, 110.0);
        sd = PlaneUtils.getStrikeAndDip(l1, l2, l3);
        System.out.println("Strike: " + sd[0] + " Dip: " + sd[1]);
        l1 = new Location(-46.0, -1.0, 0.0);
        l2 = new Location(-45.0, 0.0, 0.0);
        l3 = new Location(-46.0, 0.0, 110.0);
        sd = PlaneUtils.getStrikeAndDip(l1, l2, l3);
        System.out.println("Strike: " + sd[0] + " Dip: " + sd[1]);
        l1 = new Location(-45.0, 0.0, 0.0);
        l2 = new Location(-46.0, -1.0, 0.0);
        l3 = new Location(-46.0, 0.0, 110.0);
        sd = PlaneUtils.getStrikeAndDip(l1, l2, l3);
        System.out.println("Strike: " + sd[0] + " Dip: " + sd[1]);
        l1 = new Location(-89.0, 0.0, 0.0);
        l2 = new Location(-90.0, -1.0, 0.0);
        l3 = new Location(-89.0, 0.0, 110.0);
        sd = PlaneUtils.getStrikeAndDip(l1, l2, l3);
        System.out.println("Strike: " + sd[0] + " Dip: " + sd[1]);
    }

    public static double[] getStrikeAndDip(double[] cosinesIn) {
        double[] strikeDip = new double[2];
        double[] vStrike = new double[3];
        vStrike = PlaneUtils.getCrossProduct(VZ_UNIT_NORMAL, cosinesIn, false);
        strikeDip[0] = PlaneUtils.calculateStrike(vStrike);
        strikeDip[1] = Math.toDegrees(Math.asin(PlaneUtils.getMagnitude(vStrike) / PlaneUtils.getMagnitude(cosinesIn)));
        return strikeDip;
    }

    public static double[] getSlipVector(double[] strikeDipRake) {
        double[] startVector = VY_UNIT_NORMAL;
        double[] rakeRotVector = PlaneUtils.vectorMatrixMultiply(PlaneUtils.zAxisRotMatrix(-strikeDipRake[2]), startVector);
        double[] dipRotVector = PlaneUtils.vectorMatrixMultiply(PlaneUtils.yAxisRotMatrix(-strikeDipRake[1]), rakeRotVector);
        double[] strikeRotVector = PlaneUtils.vectorMatrixMultiply(PlaneUtils.zAxisRotMatrix(strikeDipRake[0]), dipRotVector);
        return strikeRotVector;
    }

    public static double calculateStrike(double[] xyVector) {
        double strike = Math.toDegrees(Math.atan2(xyVector[0], xyVector[1]));
        if (strike < 0.0) {
            strike += 360.0;
        }
        return strike;
    }

    public static double[] getDirectionCosines(double[][] verticesIn) {
        double[] cosines = PlaneUtils.getNormalVector(verticesIn);
        PlaneUtils.normalizeVector(cosines);
        return cosines;
    }

    public static double[] getDirectionCosines(double[] strikeAndDip) {
        double strike = Math.toRadians(strikeAndDip[0]);
        double dip = Math.toRadians(strikeAndDip[1]);
        double dipDir = Math.toRadians(strikeAndDip[0] - 90.0);
        double[] v1 = new double[]{Math.sin(strike), Math.cos(strike), 0.0};
        double[] v2 = new double[]{Math.cos(dip) * Math.sin(dipDir), Math.cos(dip) * Math.cos(dipDir), Math.sin(dip)};
        double[] cosines = PlaneUtils.getCrossProduct(v1, v2, true);
        PlaneUtils.normalizeVector(cosines);
        return cosines;
    }

    public static void normalizeVector(double[] v) {
        double vectorMagnitude = PlaneUtils.getMagnitude(v);
        for (int i = 0; i < 3; ++i) {
            v[i] = v[i] / vectorMagnitude;
        }
    }

    public static double[] getNormalVector(double[][] verticesIn) {
        double[] vs = new double[3];
        double[] vt = new double[3];
        double[] vN = new double[3];
        for (int i = 0; i < 3; ++i) {
            vs[i] = verticesIn[1][i] - verticesIn[0][i];
            vt[i] = verticesIn[2][i] - verticesIn[0][i];
        }
        vN = PlaneUtils.getCrossProduct(vs, vt, true);
        return vN;
    }

    public static double[] getCrossProduct(double[] v1, double[] v2, boolean up) {
        double[] xProduct = new double[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
        if (up && xProduct[2] < 0.0) {
            xProduct[0] = xProduct[0] * -1.0;
            xProduct[1] = xProduct[1] * -1.0;
            xProduct[2] = xProduct[2] * -1.0;
        }
        return xProduct;
    }

    public static double getVectorInterangle(double[] v1, double[] v2) {
        double angle = Math.acos(PlaneUtils.getDotProduct(v1, v2) / (PlaneUtils.getMagnitude(v1) * PlaneUtils.getMagnitude(v2)));
        return angle;
    }

    public static double getMinVectorInterangle(double[] v1, double[] v2) {
        double angle = PlaneUtils.getVectorInterangle(v1, v2);
        if (angle > 1.5707963267948966) {
            angle -= 1.5707963267948966;
        }
        return angle;
    }

    public static double getDotProduct(double[] v1, double[] v2) {
        double dp = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
        return dp;
    }

    public static double getMagnitude(double[] v) {
        double mag = Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        return mag;
    }

    public static int[] getNearestNeighbor(int[] xyzDimensions, long[] xyzOrigins, int[] xyzInterval, double[] xyzPoint) {
        int[] nn = new int[3];
        double[] xyzPointInv = new double[]{xyzPoint[0], xyzPoint[1], xyzPoint[2] * -1.0};
        for (int i = 0; i < 3; ++i) {
            long min = xyzOrigins[i];
            long max = xyzOrigins[i] + (long)((xyzDimensions[i] - 1) * xyzInterval[i]);
            if (xyzPointInv[i] < (double)min || xyzPointInv[i] > (double)max) {
                nn[0] = -1;
                nn[1] = -1;
                nn[2] = -1;
                return nn;
            }
            long inboundsLength = (long)xyzPointInv[i] - min;
            int dataLocation = (int)(inboundsLength / (long)xyzInterval[i] + 1L);
            if (inboundsLength % (long)xyzInterval[i] >= (long)(xyzInterval[i] / 2)) {
                // empty if block
            }
            nn[i] = ++dataLocation;
        }
        return nn;
    }

    public static double[][] getPrincipalStresses(double[][] stressTensor) {
        double[][] out = new double[4][3];
        Matrix stress = new Matrix(stressTensor);
        EigenvalueDecomposition stressEig = stress.eig();
        double[][] stresses = stressEig.getD().getArray();
        double[][] rotations = stressEig.getV().getArray();
        for (int i = 0; i < 3; ++i) {
            out[0][i] = stresses[i][i];
        }
        for (int j = 1; j < 4; ++j) {
            for (int k = 0; k < 3; ++k) {
                out[j][k] = rotations[j - 1][k];
            }
        }
        return out;
    }

    public static double[] getTraction(double[][] stressTensor, double[] cosines) {
        double[] traction = new double[3];
        for (int i = 0; i < 3; ++i) {
            traction[i] = stressTensor[i][0] * cosines[0] + stressTensor[i][1] * cosines[1] + stressTensor[i][2] * cosines[2];
        }
        return traction;
    }

    public static double[] getStresses(double[][] stressTensor, double[] cosines) {
        double[] traction = PlaneUtils.getTraction(stressTensor, cosines);
        double theta = PlaneUtils.getVectorInterangle(cosines, traction);
        double tractionMagnitude = PlaneUtils.getMagnitude(traction);
        double normalStress = tractionMagnitude * Math.cos(theta);
        double shearStress = tractionMagnitude * Math.sin(theta);
        double[] stresses = new double[]{normalStress, shearStress};
        return stresses;
    }

    public static double[] getNormalAndShearStress(double[][] stressTensor, double[] cosines, double[] slipVector) {
        double[] traction = PlaneUtils.getTraction(stressTensor, cosines);
        double tractionMagnitude = PlaneUtils.getMagnitude(traction);
        double theta = PlaneUtils.getVectorInterangle(cosines, traction);
        double normalStressMag = tractionMagnitude * Math.cos(theta);
        double shearStressMag = tractionMagnitude * Math.sin(theta);
        double[] shearVector = PlaneUtils.getCrossProduct(PlaneUtils.getCrossProduct(cosines, traction, false), cosines, false);
        double phi = PlaneUtils.getVectorInterangle(slipVector, shearVector);
        double[] stresses = new double[]{normalStressMag, shearStressMag *= Math.cos(phi)};
        return stresses;
    }

    public static double calculateCoulomb(double normalStress, double shearStress, double friction) {
        double coulomb = shearStress - -normalStress * friction;
        return coulomb;
    }

    public static double[] rotateCoordinates(double[] coords, double theta) {
        double[] xyz = new double[]{coords[0], coords[1], 0.0};
        double[] rotCoord = PlaneUtils.vectorMatrixMultiply(PlaneUtils.zAxisRotMatrix(theta), xyz);
        double[] out = new double[]{rotCoord[0], rotCoord[1]};
        return out;
    }

    public static double[][] xAxisRotMatrix(double theta) {
        double thetaRad = Math.toRadians(theta);
        double[][] rotMatrix = new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(thetaRad), Math.sin(thetaRad)}, {0.0, -Math.sin(thetaRad), Math.cos(thetaRad)}};
        return rotMatrix;
    }

    public static double[][] yAxisRotMatrix(double theta) {
        double thetaRad = Math.toRadians(theta);
        double[][] rotMatrix = new double[][]{{Math.cos(thetaRad), 0.0, -Math.sin(thetaRad)}, {0.0, 1.0, 0.0}, {Math.sin(thetaRad), 0.0, Math.cos(thetaRad)}};
        return rotMatrix;
    }

    public static double[][] zAxisRotMatrix(double theta) {
        double thetaRad = Math.toRadians(theta);
        double[][] rotMatrix = new double[][]{{Math.cos(thetaRad), Math.sin(thetaRad), 0.0}, {-Math.sin(thetaRad), Math.cos(thetaRad), 0.0}, {0.0, 0.0, 1.0}};
        return rotMatrix;
    }

    public static double[][] rotateTensor(double[][] tensorData, double theta) {
        double thetaRad = Math.toRadians(theta);
        Matrix rotationMatrix = new Matrix(PlaneUtils.zAxisRotMatrix(theta));
        Matrix rotatedTensor = rotationMatrix.times(new Matrix(tensorData)).times(rotationMatrix.transpose());
        return rotatedTensor.getArray();
    }

    public static double[] vectorMatrixMultiply(double[][] matrix, double[] vector) {
        double[] rotatedVector = new double[3];
        for (int i = 0; i < 3; ++i) {
            rotatedVector[i] = vector[0] * matrix[i][0] + vector[1] * matrix[i][1] + vector[2] * matrix[i][2];
        }
        return rotatedVector;
    }

    public static double faultAreaFromMagnitude(double magnitude) {
        double faultArea = Math.pow(10.0, (magnitude - 4.07) / 0.98);
        double faultDimension = Math.sqrt(faultArea);
        return faultDimension;
    }

    public static double faultSlipFromMagnitude(double magnitude) {
        double faultSlip = Math.pow(10.0, (magnitude - 6.93) / 0.82);
        return faultSlip;
    }

    public static double[] okadaSlipComponents(double slip, double rake) {
        double[] slipComponents = new double[]{slip * Math.cos(Math.toRadians(rake)), slip * Math.sin(Math.toRadians(rake))};
        return slipComponents;
    }
}

