/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.opensha.commons.data.CSVFile;

public class CSVTable
extends JTable
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private boolean editMode;
    private DefaultTableModel model = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int column) {
            return CSVTable.this.editMode && super.isCellEditable(row, column);
        }
    };
    private JPopupMenu menu;
    private JMenuItem deleteColItem;
    private JMenuItem deleteRowItem;
    private JPopupMenu tablePopup;
    private int lastClickedCol = -1;
    private int lastClickedRow = -1;

    public CSVTable() {
        this(null, true);
    }

    public CSVTable(CSVFile<?> csv, boolean firstLineIsHeader) {
        super.setModel(this.model);
        this.addMouseListener(this);
        this.setCSV(csv, firstLineIsHeader);
    }

    public void setEditingEnabled(boolean editMode) {
        this.editMode = editMode;
        this.getTableHeader().setReorderingAllowed(editMode);
    }

    public void setCSV(CSVFile<?> csv, boolean firstLineIsHeader) {
        if (csv == null) {
            this.model.setDataVector(new Object[0][0], null);
            return;
        }
        int numRows = csv.getNumRows();
        int startRow = 0;
        Object[] header = null;
        if (firstLineIsHeader) {
            --numRows;
            ++startRow;
            header = csv.getLine(0).toArray();
        }
        Object[][] data = new Object[numRows][];
        for (int i = 0; i < numRows; ++i) {
            int csvI = i;
            if (firstLineIsHeader) {
                ++csvI;
            }
            data[i] = csv.getLine(csvI).toArray();
        }
        this.model.setDataVector(data, header);
    }

    public CSVFile<String> buildCSVFromTable(boolean includeHeader) {
        CSVFile<String> csv = new CSVFile<String>(true);
        if (includeHeader) {
            ArrayList<String> header = new ArrayList<String>();
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                header.add(this.model.getColumnName(i));
            }
            csv.addLine((List<String>)header);
        }
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            ArrayList<String> vals = new ArrayList<String>();
            for (int j = 0; j < this.model.getColumnCount(); ++j) {
                Object val = this.model.getValueAt(i, j);
                if (val == null) {
                    vals.add(null);
                    continue;
                }
                vals.add(val.toString());
            }
            csv.addLine((List<String>)vals);
        }
        return csv;
    }

    private JPopupMenu getTablePopup() {
        if (this.tablePopup == null) {
            this.tablePopup = new JPopupMenu();
            this.deleteColItem = new JMenuItem("Delete Column");
            this.deleteColItem.addActionListener(this);
            this.deleteRowItem = new JMenuItem("Delete Row");
            this.deleteRowItem.addActionListener(this);
            this.tablePopup.add(this.deleteRowItem);
            this.tablePopup.add(this.deleteColItem);
        }
        return this.tablePopup;
    }

    private void checkPop(MouseEvent e) {
        if (!this.editMode) {
            return;
        }
        int r = this.rowAtPoint(e.getPoint());
        if (r >= 0 && r < this.getRowCount()) {
            this.setRowSelectionInterval(r, r);
        } else {
            this.clearSelection();
        }
        int rowindex = this.getSelectedRow();
        if (rowindex < 0) {
            return;
        }
        if (e.isPopupTrigger()) {
            JPopupMenu popup = this.getTablePopup();
            this.lastClickedCol = this.columnAtPoint(e.getPoint());
            this.lastClickedRow = rowindex;
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkPop(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkPop(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteColItem) {
            if (this.lastClickedCol >= 0) {
                CSVFile<String> newCSV = this.buildCSVFromTable(true);
                newCSV.removeColumn(this.lastClickedCol);
                this.setCSV(newCSV, true);
                this.lastClickedCol = -1;
            }
        } else if (e.getSource() == this.deleteRowItem && this.lastClickedCol >= 0) {
            CSVFile<String> newCSV = this.buildCSVFromTable(true);
            newCSV.removeLine(this.lastClickedRow);
            this.setCSV(newCSV, true);
            this.lastClickedCol = -1;
        }
    }
}

