/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.BrowserUtils;
import org.opensha.ui.components.Resources;

public class DisclaimerDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static boolean D = false;
    private static final int margin = 16;
    private static final String prefPrefix = "disc_accpted_";
    private static Preferences prefs = Preferences.userNodeForPackage(DisclaimerDialog.class);
    private String appName;
    private String shortName;
    private ApplicationVersion version;
    private JButton acceptButton;
    private JButton exitButton;
    private JCheckBox hideCheck;
    private boolean accepted = false;

    public DisclaimerDialog(String appName, String shortName, ApplicationVersion version) {
        this.appName = appName;
        this.shortName = shortName;
        this.version = version;
        if (this.skipDisclaimer()) {
            if (D) {
                System.out.println("can skip disclaimer!");
            }
            return;
        }
        if (D) {
            System.out.println("displaying disclaimer!");
        }
        this.init();
        if (!this.accepted) {
            System.exit(0);
        }
        if (this.hideCheck.isSelected()) {
            DisclaimerDialog.storeAcceptedVersion(shortName, version);
            DisclaimerDialog.flushPrefs();
        }
    }

    private void init() {
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("License Agreement");
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(600, 480));
        JLabel appLabel = new JLabel(this.appName + " (" + String.valueOf(this.version) + ")");
        appLabel.setFont(appLabel.getFont().deriveFont(1));
        appLabel.setBorder(new EmptyBorder(20, 0, 10, 0));
        this.hideCheck = new JCheckBox("Don't show again", false);
        this.exitButton = new JButton("Disagree");
        this.exitButton.addActionListener(this);
        this.acceptButton = new JButton("Agree");
        this.acceptButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.hideCheck);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.exitButton);
        buttonPanel.add(this.acceptButton);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new EmptyBorder(0, 16, 0, 16));
        p.add((Component)appLabel, "First");
        p.add((Component)DisclaimerDialog.getLicensePanel(), "Center");
        p.add((Component)buttonPanel, "South");
        this.getContentPane().add(p);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        if (D) {
            System.out.println("Set visible done (accepted = " + this.accepted + ")");
        }
    }

    private static String getLicenseLink() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body style='font: sans-serif;'>");
        sb.append("<div style='text-align: center'>");
        sb.append("<br/><br/><br/><br/>Please see:<br/><br/>");
        sb.append("<a href='http://www.opensha.org/license'>");
        sb.append("http://www.opensha.org/license");
        sb.append("</a><br/><br/>for license and disclaimer information.");
        sb.append("</div></body></html>");
        return sb.toString();
    }

    public static JComponent getLicensePanel() {
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setBorder(new EmptyBorder(10, 6, 10, 2));
        try {
            textPane.setPage(Resources.getLicense());
        }
        catch (IOException ioe) {
            textPane.setContentType("text/html");
            textPane.setText(DisclaimerDialog.getLicenseLink());
        }
        textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                try {
                    if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserUtils.launch(he.getURL());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JScrollPane scroller = new JScrollPane(textPane);
        scroller.setVerticalScrollBarPolicy(22);
        scroller.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        scroller.setOpaque(false);
        return scroller;
    }

    private static String getPrefKey(String shortName) {
        return prefPrefix + shortName;
    }

    private ApplicationVersion getAcceptedVersion() {
        String version = prefs.get(DisclaimerDialog.getPrefKey(this.shortName), null);
        if (D) {
            System.out.println("getAcceptedVersion(): prefVal=" + version);
        }
        if (version != null && !version.isEmpty() && version.contains(".")) {
            return ApplicationVersion.fromString(version);
        }
        return null;
    }

    private boolean skipDisclaimer() {
        ApplicationVersion accepted = this.getAcceptedVersion();
        if (D) {
            System.out.println("Comparing my version (" + String.valueOf(this.version) + ") to pref version (" + String.valueOf(accepted) + ")");
        }
        return accepted != null && !accepted.isLessThan(this.version);
    }

    private static void storeAcceptedVersion(String shortName, ApplicationVersion version) {
        if (version == null) {
            DisclaimerDialog.clearAcceptedVersion(shortName);
            return;
        }
        String key = DisclaimerDialog.getPrefKey(shortName);
        if (D) {
            System.out.println("setting accepted version for '" + key + "' to: " + String.valueOf(version));
        }
        prefs.put(key, version.toString());
    }

    private static void clearAcceptedVersion(String shortName) {
        block3: {
            String key = DisclaimerDialog.getPrefKey(shortName);
            if (D) {
                System.out.println("clearing accepted version for '" + key + "'");
            }
            try {
                prefs.remove(key);
            }
            catch (NullPointerException e) {
                if (!D) break block3;
                System.out.println("key '" + key + "' cannot be cleared as it doesn't exist!");
            }
        }
    }

    private static void flushPrefs() {
        try {
            prefs.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("WARNING: Couldn't write to preferences!");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.acceptButton)) {
            this.accepted = true;
            this.setVisible(false);
        } else if (e.getSource().equals(this.exitButton)) {
            this.accepted = false;
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        String name = "Test Application";
        String shortName = "TestApp";
        ApplicationVersion version = ApplicationVersion.fromString("0.2.3");
        ApplicationVersion accepted = ApplicationVersion.fromString("0.2.1");
        try {
            new DisclaimerDialog(name, shortName, version);
        }
        catch (Throwable t) {
            System.out.println("Caught an exception!");
            t.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

