/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.util.ShapeUtils;
import org.jfree.data.xy.XYDataset;
import org.opensha.commons.gui.AdjustableScaleXYItemRenderer;

public class GriddedSubsetXYItemRenderer
extends AdjustableScaleXYItemRenderer {
    private Line2D line;
    private Color fillColor;

    public GriddedSubsetXYItemRenderer() {
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.scale = 6.0;
    }

    public GriddedSubsetXYItemRenderer(int type, XYToolTipGenerator toolTipGenerator) {
        super(type, toolTipGenerator);
        this.scale = 7.0;
    }

    @Override
    protected boolean isShapeFilled(Plot plot, int series, int item, double x, double y) {
        return true;
    }

    public void drawItem(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, XYPlot plot, ValueAxis horizontalAxis, ValueAxis verticalAxis, XYDataset data, int datasetIndex, int series, int item, CrosshairState crosshairInfo) {
        Shape entityArea = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getEntityCollection();
        }
        Color seriesPaint = this.fillColor;
        Stroke seriesStroke = this.getItemStroke(datasetIndex, series);
        g2.setPaint(seriesPaint);
        g2.setStroke(seriesStroke);
        Double x1 = data.getXValue(series, item);
        Double y1 = data.getYValue(series, item);
        if (y1 != null) {
            double transX1 = horizontalAxis.valueToJava2D(((Number)x1).doubleValue(), dataArea, RectangleEdge.TOP);
            double transY1 = verticalAxis.valueToJava2D(((Number)y1).doubleValue(), dataArea, RectangleEdge.LEFT);
            Paint paint = this.getItemPaint(series, item);
            if (paint != null) {
                g2.setPaint(paint);
            }
            if (this.getPlotLines() && item > 0) {
                Double x0 = data.getXValue(series, item - 1);
                Double y0 = data.getYValue(series, item - 1);
                if (y0 != null) {
                    double transX0 = horizontalAxis.valueToJava2D(((Number)x0).doubleValue(), dataArea, RectangleEdge.TOP);
                    double transY0 = verticalAxis.valueToJava2D(((Number)y0).doubleValue(), dataArea, RectangleEdge.LEFT);
                    this.line.setLine(transX0, transY0, transX1, transY1);
                    if (this.line.intersects(dataArea)) {
                        g2.draw(this.line);
                    }
                }
            }
            if (this.getPlotImages()) {
                Shape shape = this.getItemShape(series, item);
                shape = ShapeUtils.createTranslatedShape((Shape)shape, (double)transY1, (double)transX1);
                if (this.isShapeFilled((Plot)plot, series, item, transX1, transY1)) {
                    if (shape.intersects(dataArea)) {
                        g2.fill(shape);
                    }
                } else if (shape.intersects(dataArea)) {
                    g2.draw(shape);
                }
                entityArea = shape;
            }
            if (this.getPlotImages()) {
                double shapeScale = this.getShapeScale((Plot)plot, series, item, transX1, transY1);
                Image image = this.getImage((Plot)plot, series, item, transX1, transY1);
                if (image != null) {
                    Point hotspot = this.getImageHotspot((Plot)plot, series, item, transX1, transY1, image);
                    g2.drawImage(image, (int)(transX1 - hotspot.getX()), (int)(transY1 - hotspot.getY()), null);
                }
            }
            if (entities != null) {
                if (entityArea == null) {
                    entityArea = new Rectangle2D.Double(transX1 - 2.0, transY1 - 2.0, 4.0, 4.0);
                }
                String tip = "";
                if (this.getToolTipGenerator(series, item) != null) {
                    tip = this.getToolTipGenerator(series, item).generateToolTip(data, series, item);
                }
                XYItemEntity entity = new XYItemEntity(entityArea, data, item, series, tip, null);
                entities.add((ChartEntity)entity);
            }
            double distance = 0.0;
            if (plot.isDomainCrosshairLockedOnData()) {
                if (plot.isRangeCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(((Number)x1).doubleValue(), ((Number)y1).doubleValue(), datasetIndex, transX1, transY1, PlotOrientation.HORIZONTAL);
                } else {
                    crosshairInfo.updateCrosshairX(((Number)x1).doubleValue(), transX1, datasetIndex);
                }
            } else if (plot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(((Number)y1).doubleValue(), transY1, datasetIndex);
            }
        }
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }
}

