/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.data.Range;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.commons.gui.plot.GraphWidget;

public class AxisLimitsControlPanel
extends ControlPanel {
    public static final String NAME = "Set Axis";
    private JLabel minXLabel = new JLabel();
    private JTextField minXField = new JTextField();
    private JLabel maxXLabel = new JLabel();
    private JTextField maxXField = new JTextField();
    private JLabel minYLabel = new JLabel();
    private JTextField minYField = new JTextField();
    private JLabel maxYLabel = new JLabel();
    private JTextField maxYField = new JTextField();
    private JCheckBox customXBox = new JCheckBox("Custom X Range");
    private JCheckBox customYBox = new JCheckBox("Custom Y Range");
    private JButton ok = new JButton();
    private JButton cancel = new JButton();
    private JDialog dialog = new JDialog();
    private Component parent;
    private GraphWidget gw;

    public AxisLimitsControlPanel(GraphWidget gw, Component parent) {
        super(NAME);
        this.gw = gw;
        this.parent = parent;
    }

    @Override
    public void doinit() {
        this.dialog.setModal(true);
        this.dialog.setLocation(this.parent.getX() + this.parent.getWidth() / 2, this.parent.getY() + this.parent.getHeight() / 2);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            System.out.println("Error Occured while running range combo box: " + String.valueOf(e));
        }
    }

    public void updateParams() {
        Range curXRange = this.gw.getX_AxisRange();
        Range curYRange = this.gw.getY_AxisRange();
        boolean customXRange = this.gw.getUserX_AxisRange() != null;
        boolean customYRange = this.gw.getUserY_AxisRange() != null;
        this.customXBox.setSelected(customXRange);
        this.customYBox.setSelected(customYRange);
        this.minXField.setText("" + curXRange.getLowerBound());
        this.maxXField.setText("" + curXRange.getUpperBound());
        this.minYField.setText("" + curYRange.getLowerBound());
        this.maxYField.setText("" + curYRange.getUpperBound());
        this.updateEnables();
    }

    void jbInit() throws Exception {
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(new GridLayout(4, 2, 10, 10));
        this.dialog.setTitle("Axis Control Panel");
        this.minXLabel.setForeground(Color.black);
        this.minXLabel.setText("Min X:");
        this.maxXLabel.setForeground(Color.black);
        this.maxXLabel.setText("Max X:");
        this.minYLabel.setForeground(Color.black);
        this.minYLabel.setText("Min Y:");
        this.maxYLabel.setForeground(Color.black);
        this.maxYLabel.setText("Max Y:");
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisLimitsControlPanel.this.ok_actionPerformed(e);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisLimitsControlPanel.this.cancel_actionPerformed(e);
            }
        });
        this.updateParams();
        this.customXBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisLimitsControlPanel.this.checkbox_actionPerformed(e);
            }
        });
        this.customYBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisLimitsControlPanel.this.checkbox_actionPerformed(e);
            }
        });
        gridPanel.add(this.customXBox);
        gridPanel.add(this.customYBox);
        gridPanel.add(AxisLimitsControlPanel.buildGridded(this.minXLabel, this.minXField));
        gridPanel.add(AxisLimitsControlPanel.buildGridded(this.minYLabel, this.minYField));
        gridPanel.add(AxisLimitsControlPanel.buildGridded(this.maxXLabel, this.maxXField));
        gridPanel.add(AxisLimitsControlPanel.buildGridded(this.maxYLabel, this.maxYField));
        gridPanel.add(AxisLimitsControlPanel.buildGridded(new JLabel(), this.ok));
        gridPanel.add(AxisLimitsControlPanel.buildGridded(this.cancel, new JLabel()));
        gridPanel.setMaximumSize(new Dimension(348, 143));
        this.dialog.setContentPane(gridPanel);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setResizable(false);
    }

    private static JPanel buildGridded(JComponent comp1, JComponent comp2) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(comp1);
        panel.add(comp2);
        return panel;
    }

    void ok_actionPerformed(ActionEvent e) {
        Range xRange = null;
        Range yRange = null;
        try {
            if (this.customXBox.isSelected()) {
                xRange = new Range(Double.parseDouble(this.minXField.getText()), Double.parseDouble(this.maxXField.getText()));
            }
            if (this.customYBox.isSelected()) {
                yRange = new Range(Double.parseDouble(this.minYField.getText()), Double.parseDouble(this.maxYField.getText()));
            }
        }
        catch (NumberFormatException e1) {
            System.out.println("Exception:" + String.valueOf(e1));
            JOptionPane.showMessageDialog(this.dialog, new String("Text Entered must be a valid numerical value"), new String("Check Axis Range"), 0);
        }
        this.gw.setAxisRange(xRange, yRange);
        this.dialog.dispose();
    }

    void cancel_actionPerformed(ActionEvent e) {
        this.dialog.dispose();
    }

    void checkbox_actionPerformed(ActionEvent e) {
        this.updateEnables();
    }

    private void updateEnables() {
        boolean enableX = this.customXBox.isSelected();
        boolean enableY = this.customYBox.isSelected();
        this.minXField.setEnabled(enableX);
        this.maxXField.setEnabled(enableX);
        this.minYField.setEnabled(enableY);
        this.maxYField.setEnabled(enableY);
    }

    @Override
    public Window getComponent() {
        return this.dialog;
    }
}

