/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.data.Range;
import org.opensha.commons.gui.plot.ButtonControlPanel;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;

public class GraphWidget
extends JPanel {
    protected static final int W = 670;
    protected static final int H = 700;
    protected JPanel chartPane = new JPanel();
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected JPanel buttonPanel = new JPanel();
    protected FlowLayout flowLayout1 = new FlowLayout();
    protected boolean xLog = false;
    protected boolean yLog = false;
    private List<Range> xRanges;
    private List<Range> yRanges;
    private PlotPreferences plotPrefs;
    protected ButtonControlPanel buttonControlPanel;
    protected GraphPanel graphPanel;
    private JPanel emptyPlotPanel = new JPanel();
    protected List<? extends PlotSpec> plotSpecs;
    protected double Y_MIN_VAL = 1.0E-16;

    public GraphWidget() {
        this(new PlotSpec(new ArrayList(), new ArrayList<PlotCurveCharacterstics>(), null, null, null));
    }

    public GraphWidget(PlotSpec plotSpec) {
        this(plotSpec, PlotPreferences.getDefault(), false, false, null, null);
    }

    public GraphWidget(PlotSpec plotSpec, PlotPreferences plotPrefs, boolean xLog, boolean yLog, Range xRange, Range yRange) {
        this(List.of(plotSpec), plotPrefs, xLog, yLog, xRange == null ? null : List.of(xRange), yRange == null ? null : List.of(yRange));
    }

    public GraphWidget(List<? extends PlotSpec> plotSpecs, PlotPreferences plotPrefs, boolean xLog, boolean yLog, List<Range> xRanges, List<Range> yRanges) {
        if (plotPrefs == null) {
            plotPrefs = PlotPreferences.getDefault();
        }
        this.plotPrefs = plotPrefs;
        this.plotSpecs = plotSpecs;
        this.graphPanel = new GraphPanel(plotPrefs);
        this.xLog = xLog;
        this.yLog = yLog;
        if (xRanges != null) {
            this.xRanges = xRanges;
        }
        if (yRanges != null) {
            this.yRanges = yRanges;
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (xLog) {
            this.buttonControlPanel.setXLog(xLog);
        }
        if (yLog) {
            this.buttonControlPanel.setYLog(yLog);
        }
        if (!xLog && !yLog) {
            this.drawGraph();
        }
    }

    protected void jbInit() throws Exception {
        this.setSize(670, 700);
        this.setLayout(this.borderLayout1);
        this.chartPane.setLayout(this.gridBagLayout1);
        this.buttonPanel.setLayout(this.flowLayout1);
        this.add((Component)this.chartPane, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.buttonControlPanel = new ButtonControlPanel(this, this.plotPrefs);
        this.buttonPanel.add((Component)this.buttonControlPanel, null);
        this.emptyPlotPanel.setBorder(new LineBorder(Color.gray));
        this.emptyPlotPanel.setBackground(Color.white);
        this.togglePlot();
    }

    public GraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    public void save() throws IOException {
        this.graphPanel.save();
    }

    public void saveAsPDF(String fileName) throws IOException {
        this.graphPanel.saveAsPDF(fileName);
    }

    public void saveAsPNG(String fileName) throws IOException {
        this.graphPanel.saveAsPNG(fileName);
    }

    public void saveAsTXT(String fileName) throws IOException {
        this.graphPanel.saveAsTXT(fileName);
    }

    public void print() {
        this.graphPanel.print();
    }

    public Range getUserX_AxisRange() {
        return this.xRanges == null ? null : this.xRanges.get(0);
    }

    public Range getUserY_AxisRange() {
        return this.yRanges == null ? null : this.yRanges.get(0);
    }

    public Range getX_AxisRange() {
        return this.graphPanel.getX_AxisRange();
    }

    public void setX_AxisRange(double minX, double maxX) {
        this.setX_AxisRange(new Range(minX, maxX));
    }

    public void setX_AxisRange(Range xRange) {
        this.xRanges = xRange == null ? null : Lists.newArrayList((Object[])new Range[]{xRange});
        this.drawGraph();
    }

    public Range getY_AxisRange() {
        return this.graphPanel.getY_AxisRange();
    }

    public void setY_AxisRange(double minY, double maxY) {
        this.setY_AxisRange(new Range(minY, maxY));
    }

    public void setY_AxisRange(Range yRange) {
        this.yRanges = yRange == null ? null : Lists.newArrayList((Object[])new Range[]{yRange});
        this.drawGraph();
    }

    public void setX_Log(boolean xLog) {
        this.xLog = xLog;
        this.drawGraph();
    }

    public void setY_Log(boolean yLog) {
        this.yLog = yLog;
        this.drawGraph();
    }

    public void setAxisRange(double xMin, double xMax, double yMin, double yMax) {
        this.setAxisRange(new Range(xMin, xMax), new Range(yMin, yMax));
    }

    public void setAxisRange(Range xRange, Range yRange) {
        this.xRanges = xRange == null ? null : Lists.newArrayList((Object[])new Range[]{xRange});
        this.yRanges = yRange == null ? null : Lists.newArrayList((Object[])new Range[]{yRange});
        this.drawGraph();
    }

    public void setAutoRange() {
        this.xRanges = null;
        this.yRanges = null;
        this.drawGraph();
    }

    public PlotSpec getPlotSpec() {
        return this.plotSpecs.get(0);
    }

    public void setPlotSpec(PlotSpec plotSpec) {
        this.plotSpecs = Lists.newArrayList((Object[])new PlotSpec[]{plotSpec});
        this.drawGraph();
    }

    public void setMultiplePlotSpecs(List<PlotSpec> plotSpecs, List<Range> xRanges, List<Range> yRanges) {
        this.plotSpecs = plotSpecs;
        this.xRanges = xRanges;
        this.yRanges = yRanges;
        this.drawGraph();
    }

    public void drawGraph() {
        if (!this.isPlotEmpty()) {
            this.graphPanel.drawGraphPanel(this.plotSpecs, this.xLog, this.yLog, this.xRanges, this.yRanges);
        }
        this.togglePlot();
    }

    private boolean isPlotEmpty() {
        if (this.plotSpecs == null || this.plotSpecs.isEmpty()) {
            return true;
        }
        PlotSpec spec = this.plotSpecs.get(0);
        if (spec instanceof XYZPlotSpec && ((XYZPlotSpec)spec).getXYZ_Data() != null) {
            return false;
        }
        return spec.getPlotElems().isEmpty();
    }

    public void setPlotChars(List<PlotCurveCharacterstics> curveCharacteristics) {
        this.plotSpecs.get(0).setChars(curveCharacteristics);
        this.drawGraph();
    }

    public void togglePlot() {
        this.chartPane.removeAll();
        if (this.isPlotEmpty()) {
            this.removeChartAndMetadata();
            this.buttonControlPanel.setEnabled(false);
        } else {
            this.buttonControlPanel.setEnabled(true);
            this.graphPanel.togglePlot();
            this.buttonControlPanel.updateToggleButtonText(this.graphPanel.isGraphOn());
            this.updateChart(this.graphPanel);
        }
    }

    private void updateChart(Component c) {
        this.chartPane.removeAll();
        this.chartPane.add(c, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        try {
            this.chartPane.validate();
            this.chartPane.repaint();
        }
        catch (RuntimeException e) {
            System.err.println("Exception in painting chart, often non-critical so ignoring:");
            e.printStackTrace();
        }
    }

    public List<PlotCurveCharacterstics> getPlottingFeatures() {
        return this.plotSpecs.get(0).getChars();
    }

    public String getXAxisLabel() {
        return this.plotSpecs.get(0).getXAxisLabel();
    }

    public String getYAxisLabel() {
        return this.plotSpecs.get(0).getYAxisLabel();
    }

    public String getPlotLabel() {
        return this.plotSpecs.get(0).getTitle();
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.plotSpecs.get(0).setXAxisLabel(xAxisLabel);
        this.drawGraph();
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.plotSpecs.get(0).setYAxisLabel(yAxisLabel);
        this.drawGraph();
    }

    public void setPlotLabel(String plotTitle) {
        this.plotSpecs.get(0).setTitle(plotTitle);
        this.drawGraph();
    }

    public void setPlotLabelFontSize(int fontSize) {
        this.plotPrefs.setPlotLabelFontSize(fontSize);
        this.drawGraph();
    }

    public void setTickLabelFontSize(int fontSize) {
        this.plotPrefs.setTickLabelFontSize(fontSize);
        this.drawGraph();
    }

    public void setAxisLabelFontSize(int fontSize) {
        this.plotPrefs.setAxisLabelFontSize(fontSize);
        this.drawGraph();
    }

    public int getTickLabelFontSize() {
        return this.plotPrefs.getTickLabelFontSize();
    }

    public int getPlotLabelFontSize() {
        return this.plotPrefs.getPlotLabelFontSize();
    }

    public PlotPreferences getPlotPrefs() {
        return this.plotPrefs;
    }

    public void setPlottingOrder(DatasetRenderingOrder order) {
        this.graphPanel.setRenderingOrder(order);
    }

    public DatasetRenderingOrder getPlottingOrder() {
        return this.graphPanel.getRenderingOrder();
    }

    public ButtonControlPanel getButtonControlPanel() {
        return this.buttonControlPanel;
    }

    public void removeChartAndMetadata() {
        this.updateChart(this.emptyPlotPanel);
        this.graphPanel.removeChartAndMetadata();
        this.validate();
    }

    public void setBackgroundColor(Color background) {
        this.graphPanel.setBackgroundColor(background);
        this.drawGraph();
    }

    public void setGriddedFuncAxesTicks(boolean histogramAxesTicks) {
        this.graphPanel.setGriddedFuncAxesTicks(histogramAxesTicks);
        this.drawGraph();
    }
}

