/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.base.Preconditions;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;
import org.jfree.chart.util.ShapeUtils;

public enum PlotSymbol {
    X("X symbols", false),
    CROSS("+ symbols", false),
    BOLD_X("Bold X symbols", true),
    BOLD_CROSS("Bold + symbols", true),
    FILLED_CIRCLE("Filled Circles", true),
    CIRCLE("Circles", false),
    FILLED_SQUARE("Filled Squares", true),
    SQUARE("Squares", false),
    FILLED_TRIANGLE("Filled Triangles", true),
    TRIANGLE("Triangles", false),
    FILLED_INV_TRIANGLE("Filled Inv. Triangles", true),
    INV_TRIANGLE("Inv. Triangles", false),
    FILLED_DIAMOND("Filled Diamonds", true),
    DIAMOND("Diamonds", false),
    DASH("Dash", false),
    BOLD_DASH("Bold Dash", false);

    private String desc;
    private boolean filled;
    private static final double SIZE = 2.0;
    private static final double DELTA = 1.0;

    private PlotSymbol(String desc, boolean filled) {
        this.desc = desc;
        this.filled = filled;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public String toString() {
        return this.desc;
    }

    public static PlotSymbol forString(String desc) {
        for (PlotSymbol sym : PlotSymbol.values()) {
            if (!sym.desc.equalsIgnoreCase(desc)) continue;
            return sym;
        }
        throw new NoSuchElementException("No symbol exists for '" + desc + "'");
    }

    public Shape buildShape(float width) {
        Preconditions.checkArgument((width > 0.0f ? 1 : 0) != 0, (Object)"width must be >0");
        if (this == CIRCLE || this == FILLED_CIRCLE) {
            return new Ellipse2D.Double(-1.0 - (double)(width / 2.0f), -1.0 - (double)(width / 2.0f), 2.0 + (double)width, 2.0 + (double)width);
        }
        if (this == SQUARE || this == FILLED_SQUARE) {
            return new Rectangle2D.Double(-1.0 - (double)(width / 2.0f), -1.0 - (double)(width / 2.0f), 2.0 + (double)width, 2.0 + (double)width);
        }
        if (this == TRIANGLE || this == FILLED_TRIANGLE) {
            return ShapeUtils.createUpTriangle((float)width);
        }
        if (this == INV_TRIANGLE || this == FILLED_INV_TRIANGLE) {
            return ShapeUtils.createDownTriangle((float)width);
        }
        if (this == DIAMOND || this == FILLED_DIAMOND) {
            return ShapeUtils.createDiamond((float)width);
        }
        if (this == X) {
            return ShapeUtils.createDiagonalCross((float)width, (float)0.1f);
        }
        if (this == DASH) {
            return ShapeUtils.createLineRegion((Line2D)new Line2D.Float(-width / 2.0f, 0.0f, width / 2.0f, 0.0f), (float)0.1f);
        }
        if (this == BOLD_DASH) {
            return ShapeUtils.createLineRegion((Line2D)new Line2D.Float(-width / 2.0f, 0.0f, width / 2.0f, 0.0f), (float)0.5f);
        }
        if (this == BOLD_X) {
            return ShapeUtils.createDiagonalCross((float)width, (float)(width * 0.25f));
        }
        if (this == CROSS) {
            return ShapeUtils.createRegularCross((float)width, (float)0.1f);
        }
        if (this == BOLD_CROSS) {
            return ShapeUtils.createRegularCross((float)width, (float)(width * 0.25f));
        }
        throw new UnsupportedOperationException("Can't build shape for symbol: " + this.toString());
    }
}

