/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart;

import com.google.common.base.Preconditions;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.Precision;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.text.TextUtils;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;

public class JFreeLogarithmicAxis
extends LogAxis {
    private static final long serialVersionUID = 1L;
    public static final double LOG10_VALUE = Math.log(10.0);
    public static final double SMALL_LOG_VALUE = 1.0E-100;
    protected boolean strictValuesFlag = true;
    protected final NumberFormat numberFormatterObj = NumberFormat.getInstance();
    protected boolean expTickLabelsFlag = false;
    protected boolean log10TickLabelsInPowerFlag = true;
    protected boolean minorAxisTickLabelFlag = true;
    private float verticalAnchorShift = 0.0f;
    private static double TICK_OVERLAP_BUFFER = 6.0;
    private static final double MIN_PIXELS_PER_DECADE_FOR_MINOR = 100.0;
    private static double MIN_NUM_MINOR = 3.0;
    private static final boolean DEBUG_PRINT_BOUNDS = false;

    public JFreeLogarithmicAxis(String label) {
        super(label);
    }

    public void setStrictValuesFlag(boolean flgVal) {
        this.strictValuesFlag = flgVal;
    }

    public boolean getStrictValuesFlag() {
        return this.strictValuesFlag;
    }

    public void setExpTickLabelsFlag() {
        this.expTickLabelsFlag = true;
        this.log10TickLabelsInPowerFlag = false;
        this.setupNumberFmtObj();
    }

    protected void setupNumberFmtObj() {
        if (this.numberFormatterObj instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormatterObj).applyPattern(this.expTickLabelsFlag ? "0E0" : "0.###");
        }
    }

    public boolean getExpTickLabelsFlag() {
        return this.expTickLabelsFlag;
    }

    public void setLog10TickLabelsInPowerFlag() {
        this.log10TickLabelsInPowerFlag = true;
        this.expTickLabelsFlag = false;
    }

    public boolean getLog10TickLabelsInPowerFlag() {
        return this.log10TickLabelsInPowerFlag;
    }

    public void setMinorAxisTickLabelFlag(boolean flag) {
        this.minorAxisTickLabelFlag = flag;
    }

    public boolean getMinorAxisTickLabelFlag() {
        return this.minorAxisTickLabelFlag;
    }

    private Rectangle2D[] getTickLabelBounds(Graphics2D g2, String label, boolean majorAxis, boolean verticalAxis, Font majorTickFont, Font minorTickFont, TextAnchor anchor) {
        return this.getTickLabelBounds(g2, label, majorAxis, verticalAxis, majorTickFont, minorTickFont, anchor, 0.0, 0.0);
    }

    private Rectangle2D[] getTickLabelBounds(Graphics2D g2, String label, boolean majorAxis, boolean verticalAxis, Font majorTickFont, Font minorTickFont, TextAnchor anchor, double xOffset, double yOffset) {
        Rectangle2D[] ret;
        if (label.isEmpty()) {
            ret = new Rectangle2D[]{JFreeLogarithmicAxis.getStringBounds(label, minorTickFont, g2)};
            ret[0] = new Rectangle2D.Double(0.0, 0.0, ret[0].getWidth(), ret[0].getHeight());
        } else if (!majorAxis) {
            ret = new Rectangle2D[]{JFreeLogarithmicAxis.getStringBounds(label, minorTickFont, g2)};
            double x = verticalAxis ? -ret[0].getWidth() : 0.0;
            ret[0] = new Rectangle2D.Double(x, 0.0, ret[0].getWidth(), ret[0].getHeight());
        } else if (!this.log10TickLabelsInPowerFlag) {
            ret = new Rectangle2D[]{JFreeLogarithmicAxis.getStringBounds(label, majorTickFont, g2)};
            ret[0] = new Rectangle2D.Double(0.0, 0.0, ret[0].getWidth(), ret[0].getHeight());
        } else {
            int eIndex = label.toLowerCase().indexOf("e");
            Preconditions.checkState((eIndex > 0 ? 1 : 0) != 0, (String)"Passed in tick label ('%s') doesn't use E notation?", (Object)label);
            Rectangle2D largeBounds = JFreeLogarithmicAxis.getStringBounds(label.substring(0, eIndex), majorTickFont, g2);
            Rectangle2D smallBounds = JFreeLogarithmicAxis.getStringBounds(label.substring(eIndex + 1), minorTickFont, g2);
            Range range = this.getRange();
            int maxExp = (int)Math.max(Math.abs(Math.floor(this.switchedLog10(range.getLowerBound()))), Math.abs(Math.ceil(this.switchedLog10(range.getUpperBound()))));
            Rectangle2D refSmallBounds = JFreeLogarithmicAxis.getStringBounds("" + maxExp, minorTickFont, g2);
            double smallMaxX = largeBounds.getWidth() + refSmallBounds.getWidth();
            double smallX = smallMaxX - smallBounds.getWidth();
            double smallY = -((int)(0.4 * (double)majorTickFont.getSize()));
            double largeX = 0.0;
            double largeY = 0.0;
            largeBounds = new Rectangle2D.Double(largeX, largeY, largeBounds.getWidth(), largeBounds.getHeight());
            smallBounds = new Rectangle2D.Double(smallX, smallY, smallBounds.getWidth(), smallBounds.getHeight());
            Rectangle2D.Double combBounds = new Rectangle2D.Double(0.0, 0.0, Math.max(largeBounds.getWidth(), smallX + smallBounds.getWidth()), largeY + largeBounds.getHeight());
            ret = new Rectangle2D[]{combBounds, largeBounds, smallBounds};
        }
        double totalWidth = ret[0].getWidth();
        double totalHeight = ret[0].getHeight();
        if (anchor.isHorizontalCenter()) {
            xOffset -= totalWidth * 0.5;
        } else if (anchor.isRight()) {
            xOffset -= totalWidth;
        }
        if (anchor.isVerticalCenter()) {
            yOffset -= totalHeight * 0.5;
        } else if (anchor.isBottom()) {
            yOffset -= totalHeight;
        }
        if (verticalAxis && ret.length == 1) {
            double offset = JFreeLogarithmicAxis.calcVerticalStringOffset(label, majorAxis ? majorTickFont : minorTickFont, g2);
            yOffset -= offset;
        }
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new Rectangle2D.Double(ret[i].getX() + xOffset, ret[i].getY() + yOffset, ret[i].getWidth(), ret[i].getHeight());
        }
        return ret;
    }

    private static Rectangle2D getStringBounds(String text, Font font, Graphics2D g2) {
        return font.getStringBounds(text, g2.getFontRenderContext());
    }

    private static double calcVerticalStringOffset(String text, Font font, Graphics2D g2) {
        if (text == null || text.isEmpty()) {
            return 0.0;
        }
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D logical = font.getStringBounds(text, frc);
        double logicalCenter = logical.getY() + logical.getHeight() / 2.0;
        GlyphVector gv = font.createGlyphVector(frc, text);
        Rectangle2D visual = gv.getVisualBounds();
        double visualCenter = visual.getY() + visual.getHeight() / 2.0;
        return visualCenter - logicalCenter;
    }

    public List refreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        ArrayList<MajorMinorNumberTick> ticks = new ArrayList<MajorMinorNumberTick>();
        ArrayList<Double> tickEndVals = new ArrayList<Double>();
        double lowerBoundVal = this.getRange().getLowerBound();
        if (lowerBoundVal < 1.0E-100) {
            lowerBoundVal = 1.0E-100;
        }
        double upperBoundVal = this.getRange().getUpperBound();
        int iBegCount = (int)StrictMath.floor(this.switchedLog10(lowerBoundVal));
        int iEndCount = (int)StrictMath.ceil(this.switchedLog10(upperBoundVal));
        boolean showMinor = this.shouldShowMinor(dataArea, edge);
        Object tickLabel = "";
        if (iBegCount == iEndCount) {
            --iBegCount;
        }
        if (iEndCount - iBegCount == 1 && upperBoundVal != Double.parseDouble("1e" + iEndCount)) {
            this.setRange(Double.parseDouble("1e" + iBegCount), upperBoundVal);
        }
        Font majorTickFont = this.getMajorTickFont();
        Font minorTickFont = this.getMinorTickFont();
        for (int i = iBegCount; i <= iEndCount; ++i) {
            int jEndCount = 9;
            if (i == iEndCount) {
                jEndCount = 1;
            }
            for (int j = 0; j < jEndCount; ++j) {
                double tickLabelEnd;
                double tickLabelStart;
                TextAnchor rotationAnchor;
                TextAnchor anchor;
                boolean majorAxis;
                double tickVal = Double.parseDouble("1e" + i) * (double)(1 + j);
                boolean bl = majorAxis = j == 0;
                if (j == 0) {
                    if (this.log10TickLabelsInPowerFlag) {
                        tickLabel = "10E" + i;
                    } else if (this.expTickLabelsFlag) {
                        tickLabel = "1e" + i;
                    }
                } else {
                    tickLabel = this.log10TickLabelsInPowerFlag && this.minorAxisTickLabelFlag ? "" + (j + 1) : "";
                }
                if (tickVal > upperBoundVal && !Precision.equals((double)tickVal, (double)upperBoundVal, (double)(upperBoundVal * 1.0E-6))) {
                    return this.checkMinNumMinor(ticks);
                }
                if (!(tickVal >= lowerBoundVal - 1.0E-100)) continue;
                if (this.isVerticalTickLabels()) {
                    anchor = TextAnchor.CENTER_RIGHT;
                    rotationAnchor = TextAnchor.CENTER_RIGHT;
                } else if (edge == RectangleEdge.TOP) {
                    anchor = TextAnchor.BOTTOM_CENTER;
                    rotationAnchor = TextAnchor.BOTTOM_CENTER;
                } else {
                    anchor = TextAnchor.TOP_CENTER;
                    rotationAnchor = TextAnchor.TOP_CENTER;
                }
                double angle = 0.0;
                Rectangle2D tickLabelBounds = this.getTickLabelBounds(g2, (String)tickLabel, majorAxis, false, majorTickFont, minorTickFont, TextAnchor.TOP_LEFT)[0];
                Preconditions.checkState((tickLabelBounds.getX() == 0.0 ? 1 : 0) != 0);
                Preconditions.checkState((tickLabelBounds.getY() == 0.0 ? 1 : 0) != 0);
                double tickCenter = this.valueToJava2D(tickVal, dataArea, edge);
                if (this.isVerticalTickLabels()) {
                    tickLabelStart = tickCenter - 0.5 * tickLabelBounds.getHeight();
                    tickLabelEnd = tickCenter + 0.5 * tickLabelBounds.getHeight();
                    angle = edge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else {
                    tickLabelStart = tickCenter - 0.5 * tickLabelBounds.getWidth();
                    tickLabelEnd = tickCenter + 0.5 * tickLabelBounds.getWidth();
                }
                if (this.log10TickLabelsInPowerFlag) {
                    double prevBufferedEnd = 0.0;
                    int k = ticks.size();
                    while (--k >= 0) {
                        if (((MajorMinorNumberTick)((Object)ticks.get(k))).getText().isEmpty()) continue;
                        prevBufferedEnd = (Double)tickEndVals.get(k) + TICK_OVERLAP_BUFFER;
                        break;
                    }
                    if (this.minorAxisTickLabelFlag) {
                        if (j == 0) {
                            if (!ticks.isEmpty()) {
                                double testBufferedEnd;
                                k = tickEndVals.size();
                                while (--k >= 0 && tickLabelStart < (testBufferedEnd = (Double)tickEndVals.get(k) + TICK_OVERLAP_BUFFER)) {
                                    MajorMinorNumberTick tempTick = (MajorMinorNumberTick)((Object)ticks.get(k));
                                    if (tempTick.getText().equals("") || tempTick.getText().contains("E")) continue;
                                    double value = tempTick.getValue();
                                    ticks.set(k, new MajorMinorNumberTick(tempTick, ""));
                                    tickEndVals.set(k, value);
                                }
                            }
                        } else if (tickLabelStart < prevBufferedEnd || !showMinor) {
                            tickLabel = "";
                            tickLabelStart = tickCenter;
                            tickLabelEnd = tickCenter;
                        }
                    }
                }
                MajorMinorNumberTick tick = new MajorMinorNumberTick(tickVal, (String)tickLabel, anchor, rotationAnchor, angle, j == 0);
                ticks.add(tick);
                tickEndVals.add(tickLabelEnd);
            }
        }
        return this.checkMinNumMinor(ticks);
    }

    protected double switchedLog10(double val) {
        return StrictMath.log(val) / LOG10_VALUE;
    }

    private boolean shouldShowMinor(Rectangle2D dataArea, RectangleEdge edge) {
        Range range = this.getRange();
        double lowerPixel = this.valueToJava2D(range.getLowerBound(), dataArea, edge);
        double upperPixel = this.valueToJava2D(range.getUpperBound(), dataArea, edge);
        double totPixels = Math.abs(upperPixel - lowerPixel);
        if (totPixels < 100.0) {
            return false;
        }
        double decades = this.switchedLog10(range.getUpperBound()) - this.switchedLog10(range.getLowerBound());
        double pixelsPerDecade = totPixels / decades;
        return pixelsPerDecade >= 100.0;
    }

    public List refreshTicksVertical(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        ArrayList<MajorMinorNumberTick> ticks = new ArrayList<MajorMinorNumberTick>();
        ArrayList<Double> tickEndVals = new ArrayList<Double>();
        double lowerBoundVal = this.getRange().getLowerBound();
        if (lowerBoundVal < 1.0E-100) {
            lowerBoundVal = 1.0E-100;
        }
        double upperBoundVal = this.getRange().getUpperBound();
        int iBegCount = (int)StrictMath.floor(this.switchedLog10(lowerBoundVal));
        int iEndCount = (int)StrictMath.ceil(this.switchedLog10(upperBoundVal));
        boolean showMinor = this.shouldShowMinor(dataArea, edge);
        if (iBegCount == iEndCount) {
            --iBegCount;
        }
        if (iEndCount - iBegCount == 1 && upperBoundVal != Double.parseDouble("1e" + iEndCount)) {
            this.setRange(Double.parseDouble("1e" + iBegCount), upperBoundVal);
        }
        Font majorTickFont = this.getMajorTickFont();
        Font minorTickFont = this.getMinorTickFont();
        Object tickLabel = "";
        for (int i = iBegCount; i <= iEndCount; ++i) {
            int jEndCount = 9;
            if (i == iEndCount) {
                jEndCount = 1;
            }
            for (int j = 0; j < jEndCount; ++j) {
                double tickLabelEnd;
                double tickLabelStart;
                TextAnchor rotationAnchor;
                TextAnchor anchor;
                boolean majorAxis;
                double tickVal = Double.parseDouble("1e" + i) * (double)(1 + j);
                boolean bl = majorAxis = j == 0;
                if (j == 0) {
                    if (this.log10TickLabelsInPowerFlag) {
                        tickLabel = "10E" + i;
                    } else if (this.expTickLabelsFlag) {
                        tickLabel = "1e" + i;
                    }
                } else {
                    tickLabel = this.log10TickLabelsInPowerFlag && this.minorAxisTickLabelFlag ? "" + (j + 1) : "";
                }
                if (tickVal > upperBoundVal) {
                    return this.checkMinNumMinor(ticks);
                }
                if (!(tickVal >= lowerBoundVal - 1.0E-100)) continue;
                if (this.isVerticalTickLabels()) {
                    if (edge == RectangleEdge.LEFT) {
                        anchor = TextAnchor.BOTTOM_CENTER;
                        rotationAnchor = TextAnchor.BOTTOM_CENTER;
                    } else {
                        anchor = TextAnchor.BOTTOM_CENTER;
                        rotationAnchor = TextAnchor.BOTTOM_CENTER;
                    }
                } else if (edge == RectangleEdge.LEFT) {
                    anchor = TextAnchor.CENTER_RIGHT;
                    rotationAnchor = TextAnchor.CENTER_RIGHT;
                } else {
                    anchor = TextAnchor.CENTER_LEFT;
                    rotationAnchor = TextAnchor.CENTER_LEFT;
                }
                double angle = 0.0;
                Rectangle2D tickLabelBounds = this.getTickLabelBounds(g2, (String)tickLabel, majorAxis, true, majorTickFont, minorTickFont, TextAnchor.TOP_LEFT)[0];
                double tickCenter = this.valueToJava2D(tickVal, dataArea, edge);
                if (this.isVerticalTickLabels()) {
                    tickLabelStart = tickCenter + 0.5 * tickLabelBounds.getWidth();
                    tickLabelEnd = tickCenter - 0.5 * tickLabelBounds.getWidth();
                    angle = edge == RectangleEdge.LEFT ? -1.5707963267948966 : 1.5707963267948966;
                } else {
                    double yOffset = tickLabelBounds.getY();
                    tickLabelStart = tickCenter + 0.5 * tickLabelBounds.getHeight() - yOffset;
                    tickLabelEnd = tickCenter - 0.5 * tickLabelBounds.getHeight();
                }
                Preconditions.checkState((tickLabelEnd <= tickLabelStart ? 1 : 0) != 0);
                double prevBufferedEnd = Double.MAX_VALUE;
                int k = ticks.size();
                while (--k >= 0) {
                    if (((MajorMinorNumberTick)((Object)ticks.get(k))).getText().isEmpty()) continue;
                    prevBufferedEnd = (Double)tickEndVals.get(k) - TICK_OVERLAP_BUFFER;
                    break;
                }
                if (this.minorAxisTickLabelFlag) {
                    if (j == 0) {
                        if (!ticks.isEmpty()) {
                            double testBufferedEnd;
                            k = tickEndVals.size();
                            while (--k >= 0 && tickLabelStart > (testBufferedEnd = (Double)tickEndVals.get(k) - TICK_OVERLAP_BUFFER)) {
                                MajorMinorNumberTick tempTick = (MajorMinorNumberTick)((Object)ticks.get(k));
                                if (tempTick.getText().equals("") || tempTick.getText().contains("E")) continue;
                                double value = tempTick.getValue();
                                ticks.set(k, new MajorMinorNumberTick(tempTick, ""));
                                tickEndVals.set(k, value);
                            }
                        }
                    } else if (tickLabelStart > prevBufferedEnd || !showMinor) {
                        tickLabel = "";
                        tickLabelStart = tickCenter;
                        tickLabelEnd = tickCenter;
                    }
                }
                ticks.add(new MajorMinorNumberTick(tickVal, (String)tickLabel, anchor, rotationAnchor, angle, j == 0));
                tickEndVals.add(tickLabelEnd);
            }
        }
        return this.checkMinNumMinor(ticks);
    }

    private List<MajorMinorNumberTick> checkMinNumMinor(List<MajorMinorNumberTick> ticks) {
        if (MIN_NUM_MINOR == 0.0) {
            return ticks;
        }
        Range range = this.getRange();
        double decades = this.switchedLog10(range.getUpperBound()) - this.switchedLog10(range.getLowerBound());
        if (decades < 1.001) {
            return ticks;
        }
        int numMajor = 0;
        int curNumMinor = 0;
        int maxNumMinor = 0;
        for (MajorMinorNumberTick tick : ticks) {
            if (tick.major) {
                curNumMinor = 0;
                ++numMajor;
                continue;
            }
            if (tick.getText().equals("") || tick.getText().contains("E")) continue;
            maxNumMinor = Integer.max(maxNumMinor, ++curNumMinor);
        }
        if (numMajor > 1 && maxNumMinor > 0 && (double)maxNumMinor < MIN_NUM_MINOR) {
            for (int i = 0; i < ticks.size(); ++i) {
                MajorMinorNumberTick tick;
                tick = ticks.get(i);
                if (tick.major || tick.getText().equals("") || tick.getText().contains("E")) continue;
                ticks.set(i, new MajorMinorNumberTick(tick, ""));
            }
        }
        return ticks;
    }

    private void removePreviousTick(List ticks) {
        int size = ticks.size();
        for (int i = size - 1; i > 0; --i) {
            Tick tick = (Tick)ticks.get(i);
            if (tick.getText().trim().equalsIgnoreCase("")) continue;
            TextAnchor anchor = tick.getTextAnchor();
            TextAnchor rotationAnchor = tick.getRotationAnchor();
            double angle = tick.getAngle();
            ticks.remove(i);
            ticks.add(new NumberTick((Number)((ValueTick)tick).getValue(), "", anchor, rotationAnchor, angle));
            return;
        }
    }

    public void setVerticalAnchorShift(float verticalAnchorShift) {
        this.verticalAnchorShift = verticalAnchorShift;
    }

    private Font getMajorTickFont() {
        Font tickFont = this.getTickLabelFont();
        return new Font(tickFont.getName(), tickFont.getStyle(), tickFont.getSize() + (int)((double)tickFont.getSize() * 0.2));
    }

    private Font getMinorTickFont() {
        Font tickFont = this.getTickLabelFont();
        return new Font(tickFont.getName(), tickFont.getStyle(), tickFont.getSize() - (int)((double)tickFont.getSize() * 0.2));
    }

    private Font getPowerTickFont() {
        Font tickFont = this.getTickLabelFont();
        return new Font(tickFont.getName(), tickFont.getStyle(), tickFont.getSize() - (int)((double)tickFont.getSize() * 0.2));
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
        AxisState state = new AxisState(cursor);
        if (!this.log10TickLabelsInPowerFlag) {
            return super.drawTickMarksAndLabels(g2, cursor, plotArea, dataArea, edge);
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(g2, cursor, dataArea, edge);
        }
        float minorOutside = this.getTickMarkOutsideLength();
        float minorInside = this.getTickMarkInsideLength();
        float majorOutside = minorOutside * 2.5f;
        float majorInside = minorInside * 2.5f;
        boolean verticalAxis = edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT;
        List ticks = this.refreshTicks(g2, state, dataArea, edge);
        state.setTicks(ticks);
        Font majorTickFont = this.getMajorTickFont();
        Font minorTickFont = this.getMinorTickFont();
        Font powerTickFont = this.getPowerTickFont();
        g2.setFont(this.getTickLabelFont());
        for (ValueTick tick : ticks) {
            float il;
            int eIndex = -1;
            if (this.log10TickLabelsInPowerFlag) {
                eIndex = tick.getText().indexOf("E");
            }
            boolean majorAxis = eIndex >= 0;
            g2.setFont(majorAxis ? majorTickFont : minorTickFont);
            float ol = majorAxis ? majorOutside : minorOutside;
            float f = il = majorAxis ? majorInside : minorInside;
            if (this.isTickLabelsVisible()) {
                g2.setPaint(this.getTickLabelPaint());
                float[] anchorPoint = this.calculateAnchorPoint(tick, cursor, dataArea, edge);
                anchorPoint[1] = anchorPoint[1] + this.verticalAnchorShift;
                if (this.isVerticalTickLabels()) {
                    TextUtils.drawRotatedString((String)tick.getText(), (Graphics2D)g2, (float)anchorPoint[0], (float)anchorPoint[1], (TextAnchor)tick.getTextAnchor(), (double)tick.getAngle(), (TextAnchor)tick.getRotationAnchor());
                } else {
                    Rectangle2D[] bounds = this.getTickLabelBounds(g2, tick.getText(), majorAxis, verticalAxis, majorTickFont, minorTickFont, tick.getTextAnchor(), anchorPoint[0], anchorPoint[1]);
                    TextAnchor boundsAnchor = TextAnchor.TOP_LEFT;
                    if (!majorAxis) {
                        TextUtils.drawRotatedString((String)tick.getText(), (Graphics2D)g2, (float)((float)bounds[0].getX()), (float)((float)bounds[0].getY()), (TextAnchor)boundsAnchor, (double)tick.getAngle(), (TextAnchor)tick.getRotationAnchor());
                    } else {
                        TextUtils.drawRotatedString((String)"10", (Graphics2D)g2, (float)((float)bounds[1].getX()), (float)((float)bounds[1].getY()), (TextAnchor)boundsAnchor, (double)tick.getAngle(), (TextAnchor)tick.getRotationAnchor());
                        g2.setFont(powerTickFont);
                        TextUtils.drawRotatedString((String)tick.getText().substring(eIndex + 1), (Graphics2D)g2, (float)((float)bounds[2].getX()), (float)((float)bounds[2].getY()), (TextAnchor)boundsAnchor, (double)tick.getAngle(), (TextAnchor)tick.getRotationAnchor());
                    }
                }
            }
            if (!this.isTickMarksVisible()) continue;
            float xx = (float)this.valueToJava2D(tick.getValue(), dataArea, edge);
            Line2D.Double mark = null;
            g2.setStroke(this.getTickMarkStroke());
            g2.setPaint(this.getTickMarkPaint());
            if (edge == RectangleEdge.LEFT) {
                mark = new Line2D.Double(cursor - (double)ol, xx, cursor + (double)il, xx);
            } else if (edge == RectangleEdge.RIGHT) {
                mark = new Line2D.Double(cursor + (double)ol, xx, cursor - (double)il, xx);
            } else if (edge == RectangleEdge.TOP) {
                mark = new Line2D.Double(xx, cursor - (double)ol, xx, cursor + (double)il);
            } else if (edge == RectangleEdge.BOTTOM) {
                mark = new Line2D.Double(xx, cursor + (double)ol, xx, cursor - (double)il);
            }
            g2.draw(mark);
        }
        double used = 0.0;
        if (this.isTickLabelsVisible()) {
            if (edge == RectangleEdge.LEFT) {
                state.cursorLeft(used += this.findMaximumTickLabelWidth(ticks, g2, plotArea, this.isVerticalTickLabels()));
            } else if (edge == RectangleEdge.RIGHT) {
                used = this.findMaximumTickLabelWidth(ticks, g2, plotArea, this.isVerticalTickLabels());
                state.cursorRight(used);
            } else if (edge == RectangleEdge.TOP) {
                used = this.findMaximumTickLabelHeight(ticks, g2, plotArea, this.isVerticalTickLabels());
                state.cursorUp(used);
            } else if (edge == RectangleEdge.BOTTOM) {
                used = this.findMaximumTickLabelHeight(ticks, g2, plotArea, this.isVerticalTickLabels());
                state.cursorDown(used);
            }
        }
        return state;
    }

    protected String makeTickLabel(double val, boolean forceFmtFlag) {
        if (this.expTickLabelsFlag || forceFmtFlag) {
            return this.numberFormatterObj.format(val).toLowerCase();
        }
        return this.getTickUnit().valueToString(val);
    }

    protected String makeTickLabel(double val) {
        return this.makeTickLabel(val, false);
    }

    protected double computeLogFloor(double lower) {
        double logFloor = Math.log(lower) / LOG10_VALUE;
        logFloor = Math.floor(logFloor);
        logFloor = Math.pow(10.0, logFloor);
        return logFloor;
    }

    protected double computeLogCeil(double upper) {
        double logCeil = Math.log(upper) / LOG10_VALUE;
        logCeil = Math.ceil(logCeil);
        logCeil = Math.pow(10.0, logCeil);
        return logCeil;
    }

    public void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            double minRange;
            double lower;
            ValueAxisPlot vap = (ValueAxisPlot)plot;
            Range r = vap.getDataRange((ValueAxis)this);
            if (r == null) {
                r = new Range(0.01, 1.0);
                lower = r.getLowerBound();
            } else {
                lower = r.getLowerBound();
                if (this.strictValuesFlag && lower <= 0.0) {
                    throw new RuntimeException("Values less than or equal to zero not allowed with logarithmic axis");
                }
            }
            lower = this.computeLogFloor(lower);
            if (lower > 0.0 && lower < 1.0E-100) {
                lower = r.getLowerBound();
            }
            double upper = r.getUpperBound();
            if ((upper = this.computeLogCeil(upper)) - lower < (minRange = this.getAutoRangeMinimumSize())) {
                if (upper + lower <= minRange / 2.0) {
                    minRange = upper / 2.0;
                }
                if ((upper = (upper + lower + minRange) / 2.0) - (lower = (upper + lower - minRange) / 2.0) < minRange) {
                    double absUpper = Math.abs(upper);
                    double adjVal = absUpper > 1.0E-100 ? absUpper / 100.0 : 0.01;
                    upper = (upper + lower + adjVal) / 2.0;
                    lower = (upper + lower - adjVal) / 2.0;
                }
            }
            this.setRange(new Range(lower, upper), false, false);
        }
    }

    private static class MajorMinorNumberTick
    extends NumberTick {
        private boolean major;

        public MajorMinorNumberTick(MajorMinorNumberTick prev, String label) {
            this(prev.getNumber(), label, prev.getTextAnchor(), prev.getRotationAnchor(), prev.getAngle(), prev.major);
        }

        public MajorMinorNumberTick(Number number, String label, TextAnchor textAnchor, TextAnchor rotationAnchor, double angle, boolean major) {
            super(number, label, textAnchor, rotationAnchor, angle);
            this.major = major;
        }
    }
}

