/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart.logTest;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class XYDataWindow
extends JFrame {
    private JPanel jPanel1 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JScrollPane dataScroll = new JScrollPane();
    private JTextArea xyText = new JTextArea();
    private XYSeries series = null;
    private JButton doneButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private Component component;

    public XYDataWindow(Component parent, XYSeriesCollection functions) {
        this.component = parent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.series = functions.getSeries(0);
        this.setXYDefaultValues();
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jLabel1.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel1.setForeground(new Color(80, 80, 133));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setText("Enter XY DataSet");
        this.jPanel1.setPreferredSize(new Dimension(250, 650));
        this.dataScroll.setPreferredSize(new Dimension(250, 650));
        this.doneButton.setForeground(new Color(80, 80, 133));
        this.doneButton.setText("Done");
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYDataWindow.this.doneButton_actionPerformed(e);
            }
        });
        this.jPanel1.add((Component)this.dataScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 8, 0), -56, -62));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(36, 20, 0, 10), 0, 0));
        this.jPanel1.add((Component)this.doneButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(544, 6, 19, 8), 30, 7));
        this.dataScroll.getViewport().add((Component)this.xyText, null);
        this.xyText.setBackground(new Color(200, 200, 230));
        this.xyText.setForeground(new Color(80, 80, 133));
        this.xyText.setLineWrap(false);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.setSize(new Dimension(349, 650));
        this.setTitle("XY Data Entry Window");
        this.validate();
        this.repaint();
        this.setLocation(this.component.getX() + this.component.getWidth() / 2, this.component.getY() / 2);
    }

    private void setXYDefaultValues() {
        Object text = "";
        ListIterator it = this.series.getItems().listIterator();
        while (it.hasNext()) {
            XYDataItem xyData = (XYDataItem)it.next();
            text = (String)text + xyData.getX().doubleValue() + "  " + xyData.getY().doubleValue() + "\n";
        }
        this.xyText.setText((String)text);
    }

    public XYSeries getDataSet() throws NumberFormatException, NullPointerException {
        this.series = new XYSeries((Comparable)((Object)"Random Data"));
        try {
            String data = this.xyText.getText();
            StringTokenizer st = new StringTokenizer(data, "\n");
            while (st.hasMoreTokens()) {
                StringTokenizer st1 = new StringTokenizer(st.nextToken());
                this.series.add(Double.valueOf(st1.nextToken()).doubleValue(), Double.valueOf(st1.nextToken()).doubleValue());
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Must enter valid number");
        }
        catch (NullPointerException ee) {
            throw new RuntimeException("Must enter data in X Y format");
        }
        return this.series;
    }

    public XYSeries getXYDataSet() {
        return this.series;
    }

    private void closeWindow() {
        boolean flag = false;
        try {
            if (this.xyText.getText().trim().equalsIgnoreCase("")) {
                JOptionPane.showMessageDialog(this, "Must enter X values", "Invalid Entry", 0);
                flag = true;
            }
            this.getDataSet();
        }
        catch (NumberFormatException ee) {
            JOptionPane.showMessageDialog(this, ee.getMessage(), "Invalid Entry", 0);
            flag = true;
        }
        catch (RuntimeException eee) {
            JOptionPane.showMessageDialog(this, eee.getMessage(), "Invalid Entry", 0);
            flag = true;
        }
        if (flag) {
            return;
        }
        this.dispose();
    }

    void doneButton_actionPerformed(ActionEvent e) {
        this.closeWindow();
    }
}

