/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart.xyzPlot;

import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ui.RectangleEdge;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.cpt.CPT;

public class XYZPlotSpec
extends PlotSpec {
    private XYZ_DataSet xyzData;
    private CPT cpt;
    private String zAxisLabel;
    private boolean includeZlabelInLegend = true;
    private boolean cptVisible = true;
    private double cptTickUnit = -1.0;
    private RectangleEdge cptPosition = RectangleEdge.TOP;
    private Double thicknessX;
    private Double thicknessY;

    public XYZPlotSpec(XYZ_DataSet xyzData, CPT cpt, String title, String xAxisLabel, String yAxisLabel, String zAxisLabel) {
        this(xyzData, new ArrayList(), new ArrayList<PlotCurveCharacterstics>(), cpt, title, xAxisLabel, yAxisLabel, zAxisLabel);
    }

    public XYZPlotSpec(XYZ_DataSet xyzData, List<? extends PlotElement> elems, List<PlotCurveCharacterstics> chars, CPT cpt, String title, String xAxisLabel, String yAxisLabel, String zAxisLabel) {
        super(elems, chars, title, xAxisLabel, yAxisLabel);
        this.xyzData = xyzData;
        this.zAxisLabel = zAxisLabel;
        this.setCPT(cpt);
    }

    public XYZ_DataSet getXYZ_Data() {
        return this.xyzData;
    }

    public void setXYZ_Data(XYZ_DataSet xyzData) {
        this.xyzData = xyzData;
    }

    public CPT getCPT() {
        return this.cpt;
    }

    public void setCPT(CPT cpt) {
        this.cpt = cpt;
        double cptTick = cpt.getPreferredTickInterval();
        if (Double.isFinite(cptTick) && cptTick > 0.0) {
            this.cptTickUnit = cptTick;
        }
    }

    public String getZAxisLabel() {
        return this.zAxisLabel;
    }

    public void setZAxisLabel(String zAxisLabel) {
        this.zAxisLabel = zAxisLabel;
    }

    public boolean isIncludeZlabelInLegend() {
        return this.includeZlabelInLegend;
    }

    public void setIncludeZlabelInLegend(boolean includeZlabelInLegend) {
        this.includeZlabelInLegend = includeZlabelInLegend;
    }

    public RectangleEdge getCPTPosition() {
        return this.cptPosition;
    }

    public void setCPTPosition(RectangleEdge legendPosition) {
        this.cptPosition = legendPosition;
    }

    public void setCPTVisible(boolean cptVisible) {
        this.cptVisible = cptVisible;
    }

    public void setThickness(Double thickness) {
        this.thicknessX = thickness;
        this.thicknessY = thickness;
    }

    public Double getThicknessX() {
        return this.thicknessX;
    }

    public void setThicknessX(Double thicknessX) {
        this.thicknessX = thicknessX;
    }

    public Double getThicknessY() {
        return this.thicknessY;
    }

    public void setThicknessY(Double thicknessY) {
        this.thicknessY = thicknessY;
    }

    public boolean isCPTVisible() {
        return this.cptVisible;
    }

    public void setXYElems(List<? extends XY_DataSet> xyElems) {
        this.elems = xyElems;
    }

    public void setXYChars(List<PlotCurveCharacterstics> xyChars) {
        this.chars = xyChars;
    }

    public void setCPTTickUnit(double cptTickUnit) {
        this.cptTickUnit = cptTickUnit;
    }

    public double getCPTTickUnit() {
        return this.cptTickUnit;
    }
}

