/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.hpc.condor;

import org.opensha.commons.hpc.condor.DAG;
import org.opensha.commons.hpc.condor.SubmitScriptForDAG;

public class ParentChildRelationship {
    private SubmitScriptForDAG parent;
    private SubmitScriptForDAG child;
    private String comment = null;

    public ParentChildRelationship(SubmitScriptForDAG parent, SubmitScriptForDAG child) {
        if (parent.getJobName().equals(child.getJobName())) {
            throw new IllegalArgumentException("Parent and child cannot be the same!");
        }
        this.parent = parent;
        this.child = child;
    }

    public SubmitScriptForDAG getParent() {
        return this.parent;
    }

    public void setParent(SubmitScriptForDAG parent) {
        if (parent.getJobName().equals(this.child.getJobName())) {
            throw new IllegalArgumentException("Parent and child cannot be the same!");
        }
        this.parent = parent;
    }

    public SubmitScriptForDAG getChild() {
        return this.child;
    }

    public void setChild(SubmitScriptForDAG child) {
        if (this.parent.getJobName().equals(child.getJobName())) {
            throw new IllegalArgumentException("Parent and child cannot be the same!");
        }
        this.child = child;
    }

    public boolean hasComment() {
        return this.comment != null && this.comment.length() > 0;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (comment != null && ((String)comment).length() > 0 && !((String)comment).startsWith("#")) {
            comment = "#" + (String)comment;
        }
        this.comment = comment;
    }

    public String toString() {
        Object line = "";
        if (this.hasComment()) {
            String comment = this.getComment();
            line = (String)line + DAG.checkAddNewline(comment);
        }
        line = (String)line + "PARENT " + this.getParent().getJobName() + " CHILD " + this.getChild().getJobName();
        return line;
    }
}

