/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.hpc.grid;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.opensha.commons.hpc.grid.GlobusRSL;
import org.opensha.commons.hpc.grid.ResourceProvider;

public class ResourceProviderEditor
extends JDialog {
    JTextField name = new JTextField();
    JTextField hostName = new JTextField();
    JTextField batchScheduler = new JTextField();
    JTextField forkScheduler = new JTextField();
    JTextField javaPath = new JTextField();
    JTextField storagePath = new JTextField();
    JTextField requirements = new JTextField();
    JTextField gridFTPHost = new JTextField();
    JTextField universe = new JTextField();
    JTextField queue = new JTextField();
    ResourceProvider rp;

    public ResourceProviderEditor(ResourceProvider rp) {
        this.rp = rp;
        ArrayList<JComponent> leftCol = new ArrayList<JComponent>();
        ArrayList<JComponent> rightCol = new ArrayList<JComponent>();
        leftCol.add(new JLabel("Name"));
        this.name.setText(rp.getName());
        rightCol.add(this.name);
        leftCol.add(new JLabel("Host Name"));
        this.hostName.setText(rp.getHostName());
        rightCol.add(this.hostName);
        leftCol.add(new JLabel("Batch Scheduler"));
        this.batchScheduler.setText(rp.getBatchScheduler());
        rightCol.add(this.batchScheduler);
        leftCol.add(new JLabel("Fork Scheduler"));
        this.forkScheduler.setText(rp.getForkScheduler());
        rightCol.add(this.forkScheduler);
        leftCol.add(new JLabel("Java Path"));
        this.javaPath.setText(rp.getJavaPath());
        rightCol.add(this.javaPath);
        leftCol.add(new JLabel("Storage Path"));
        this.storagePath.setText(rp.getStoragePath());
        rightCol.add(this.storagePath);
        leftCol.add(new JLabel("Requirements"));
        this.requirements.setText(rp.getRequirements());
        rightCol.add(this.requirements);
        leftCol.add(new JLabel("GridFTP Host Name"));
        this.gridFTPHost.setText(rp.getGridFTPHost());
        rightCol.add(this.gridFTPHost);
        leftCol.add(new JLabel("Condor Universe"));
        this.universe.setText(rp.getUniverse());
        rightCol.add(this.universe);
        this.createGUI(leftCol, rightCol);
        this.setDefaultCloseOperation(2);
        this.setTitle("Resource Provider");
    }

    public void createGUI(ArrayList<JComponent> leftCol, ArrayList<JComponent> rightCol) {
        int num = leftCol.size();
        this.setLayout(new GridLayout(num, 2));
        for (int i = 0; i < leftCol.size(); ++i) {
            JComponent left = leftCol.get(i);
            JComponent right = rightCol.get(i);
            this.add(left);
            this.add(right);
        }
        this.setPreferredSize(new Dimension(200, 500));
        this.setSize(new Dimension(500, 300));
    }

    public ResourceProvider getResourceProvider() {
        int wallTime = this.rp.getGlobusRSL().getMaxWallTime();
        String queue = this.queue.getText();
        GlobusRSL rsl = new GlobusRSL("single", wallTime);
        if (queue.length() > 0) {
            rsl.setQueue(queue);
        }
        String name = this.name.getText();
        String hostName = this.hostName.getText();
        String batchScheduler = this.batchScheduler.getText();
        String forkScheduler = this.forkScheduler.getText();
        String javaPath = this.javaPath.getText();
        String storagePath = this.storagePath.getText();
        String requirements = this.requirements.getText();
        String gridFTPHost = this.gridFTPHost.getText();
        String universe = this.universe.getText();
        return new ResourceProvider(name, hostName, batchScheduler, forkScheduler, javaPath, storagePath, requirements, gridFTPHost, universe, rsl);
    }

    public static void main(String[] args) {
        ResourceProvider rp = ResourceProvider.ABE_GLIDE_INS();
        ResourceProviderEditor editor = new ResourceProviderEditor(rp);
        editor.setVisible(true);
    }
}

