/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.logicTree;

import com.google.common.base.Preconditions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class JsonAdapterHelper {
    protected static Class getTypeAdapterClass(Object o) {
        Class c;
        JsonAdapter annotation = o.getClass().getAnnotation(JsonAdapter.class);
        if (annotation != null && TypeAdapter.class.isAssignableFrom(c = annotation.value())) {
            return c;
        }
        return null;
    }

    protected static TypeAdapter getTypeAdapter(Object o) {
        Class c = JsonAdapterHelper.getTypeAdapterClass(o);
        if (c != null) {
            try {
                return (TypeAdapter)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean hasTypeAdapter(Object o) {
        return JsonAdapterHelper.getTypeAdapter(o) != null;
    }

    public static void writeAdapterValue(JsonWriter out, Object value) throws IOException {
        TypeAdapter adapter = JsonAdapterHelper.getTypeAdapter(value);
        JsonAdapterHelper.writeAdapterValue(out, adapter, value);
    }

    public static void writeAdapterValue(JsonWriter writer, TypeAdapter adapter, Object value) throws IOException {
        writer.beginObject();
        writer.name("adapterClass");
        writer.value(adapter.getClass().getName());
        writer.name("adapterData");
        adapter.write(writer, value);
        writer.endObject();
    }

    public static Object readAdapterValue(JsonReader in) throws IOException {
        in.beginObject();
        Preconditions.checkArgument((boolean)"adapterClass".equals(in.nextName()));
        String adapterName = in.nextString();
        TypeAdapter adapter = null;
        try {
            Class<?> rawClass = Class.forName(adapterName);
            adapter = (TypeAdapter)rawClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            System.err.println("WARNING: couldn't locate logic tree branch node adapter class '" + adapterName + "', returning null instead");
        }
        catch (ClassCastException e) {
            System.err.println("WARNING: logic tree branch node adapter class '" + adapterName + "' is of the wrong type, returning null instead");
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        Preconditions.checkArgument((boolean)"adapterData".equals(in.nextName()));
        Object result = null;
        if (adapter != null) {
            result = adapter.read(in);
        } else {
            in.skipValue();
        }
        in.endObject();
        return result;
    }
}

