/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.logicTree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.opensha.commons.logicTree.JsonAdapterHelper;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.modules.helpers.JSON_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;

@JsonAdapter(value=Adapter.class)
public class LogicTreeBranch<E extends LogicTreeNode>
implements Iterable<E>,
Cloneable,
Serializable,
Comparable<LogicTreeBranch<E>>,
JSON_BackedModule,
SplittableRuptureModule<LogicTreeBranch<E>> {
    private ImmutableList<LogicTreeLevel<? extends E>> levels;
    private List<E> values;
    private Double originalWeight;
    private static final int NAME_LENGTH_LIMIT = 255;

    protected LogicTreeBranch() {
    }

    public LogicTreeBranch(LogicTreeBranch<E> branch) {
        this((List<LogicTreeLevel<? extends E>>)branch.levels, (List<? extends E>)branch.values);
    }

    public LogicTreeBranch(List<LogicTreeLevel<? extends E>> levels) {
        this(levels, null);
    }

    public LogicTreeBranch(List<LogicTreeLevel<? extends E>> levels, List<E> values) {
        this.init(levels, values);
    }

    void init(List<LogicTreeLevel<? extends E>> levels, List<E> values) {
        int i;
        Preconditions.checkNotNull(levels);
        Preconditions.checkState((!levels.isEmpty() ? 1 : 0) != 0, (Object)"Must supply at least 1 branch level");
        for (i = 0; i < levels.size(); ++i) {
            Preconditions.checkNotNull(levels.get(i), (String)"Branch level at index %s is null", (int)i);
        }
        this.levels = ImmutableList.copyOf(levels);
        if (values == null) {
            values = new ArrayList(levels.size());
            for (i = 0; i < levels.size(); ++i) {
                values.add(null);
            }
            this.values = values;
        } else {
            Preconditions.checkState((levels.size() == values.size() ? 1 : 0) != 0, (String)"Have %s levels but %s values", (int)levels.size(), (int)values.size());
            for (i = 0; i < values.size(); ++i) {
                LogicTreeNode value = (LogicTreeNode)values.get(i);
                if (value == null) continue;
                LogicTreeLevel<E> level = levels.get(i);
                Class<E> type = level.getType();
                Preconditions.checkState((boolean)type.isAssignableFrom(value.getClass()), (String)"Value '%s' is not the correct type for '%s'", (Object)value.getName(), (Object)level.getName());
                Preconditions.checkState((boolean)level.isMember(value), (String)"Value '%s' is not a member of '%s'", (Object)value.getName(), (Object)level.getName());
            }
            this.values = new ArrayList<E>(values);
        }
    }

    public <T extends LogicTreeNode> T requireValue(Class<? extends T> clazz) {
        for (LogicTreeNode node : this.values) {
            if (node == null || !clazz.isAssignableFrom(node.getClass())) continue;
            return (T)node;
        }
        throw new IllegalStateException("Missing required type: " + clazz.getName());
    }

    public <T extends LogicTreeNode> T getValue(Class<? extends T> clazz) {
        for (LogicTreeNode node : this.values) {
            if (node == null || !clazz.isAssignableFrom(node.getClass())) continue;
            return (T)node;
        }
        return null;
    }

    public <T extends LogicTreeNode> List<T> getValues(Class<? extends T> clazz) {
        ArrayList<LogicTreeNode> matches = null;
        for (LogicTreeNode node : this.values) {
            if (node == null || !clazz.isAssignableFrom(node.getClass())) continue;
            if (matches == null) {
                matches = new ArrayList<LogicTreeNode>();
            }
            matches.add(node);
        }
        return matches;
    }

    public boolean hasValue(Class<? extends LogicTreeNode> clazz) {
        return this.getValue(clazz) != null;
    }

    public boolean hasValue(LogicTreeNode value) {
        for (LogicTreeNode node : this.values) {
            if (node == null || !node.equals(value)) continue;
            return true;
        }
        return false;
    }

    public E getValueUnchecked(Class<? extends LogicTreeNode> clazz) {
        for (LogicTreeNode node : this.values) {
            if (node == null || !clazz.isAssignableFrom(node.getClass())) continue;
            return (E)node;
        }
        return null;
    }

    public int size() {
        return this.levels.size();
    }

    public E getValue(int index) {
        return (E)((LogicTreeNode)this.values.get(index));
    }

    public ImmutableList<LogicTreeLevel<? extends E>> getLevels() {
        return this.levels;
    }

    public LogicTreeLevel<? extends E> getLevel(int index) {
        return (LogicTreeLevel)this.levels.get(index);
    }

    public boolean clearValue(Class<? extends LogicTreeNode> clazz) {
        boolean classFound = false;
        boolean cleared = false;
        for (int i = 0; i < this.size(); ++i) {
            LogicTreeNode value = (LogicTreeNode)this.values.get(i);
            if (!clazz.isAssignableFrom(((LogicTreeLevel)this.levels.get(i)).getType())) continue;
            if (this.values.get(i) != null) {
                this.originalWeight = null;
            }
            this.values.set(i, null);
            classFound = true;
            cleared = cleared || value != null;
        }
        if (!classFound) {
            throw new NoSuchElementException("Class not in logic tree: " + String.valueOf(clazz));
        }
        return cleared;
    }

    public void clearValue(int index) {
        if (this.values.get(index) != null) {
            this.originalWeight = null;
        }
        this.values.set(index, null);
    }

    public void setValue(E value) {
        for (int i = 0; i < this.levels.size(); ++i) {
            LogicTreeLevel level = (LogicTreeLevel)this.levels.get(i);
            if (!level.getType().isAssignableFrom(value.getClass()) || !level.isMember((LogicTreeNode)value)) continue;
            if (Objects.equals(value, this.values.get(i))) {
                this.originalWeight = null;
            }
            this.values.set(i, value);
            return;
        }
        throw new IllegalArgumentException("Value '" + value.getName() + "' with type '" + String.valueOf(value.getClass()) + "' is not a valid member of any level of this logic tree branch");
    }

    public void setValue(int index, E value) {
        if (value == null) {
            this.clearValue(index);
            return;
        }
        LogicTreeLevel level = (LogicTreeLevel)this.levels.get(index);
        Preconditions.checkState((level.getType().isAssignableFrom(value.getClass()) && level.isMember((LogicTreeNode)value) ? 1 : 0) != 0);
        if (Objects.equals(value, this.values.get(index))) {
            this.originalWeight = null;
        }
        this.values.set(index, value);
    }

    public void setValueUnchecked(LogicTreeNode value) {
        for (int i = 0; i < this.levels.size(); ++i) {
            LogicTreeLevel level = (LogicTreeLevel)this.levels.get(i);
            if (!level.getType().isAssignableFrom(value.getClass()) || !level.isMember(value)) continue;
            if (Objects.equals(value, this.values.get(i))) {
                this.originalWeight = null;
            }
            this.values.set(i, value);
            return;
        }
        throw new IllegalArgumentException("Value '" + value.getName() + "' with type '" + String.valueOf(value.getClass()) + "' is not a valid member of any level of this logic tree branch");
    }

    public boolean isFullySpecified() {
        for (LogicTreeNode val : this.values) {
            if (val != null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.levels == null ? 0 : this.levels.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogicTreeBranch other = (LogicTreeBranch)obj;
        if (this.levels == null ? other.levels != null : !this.levels.equals(other.levels)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public boolean areLevelsEqual(LogicTreeBranch<?> o) {
        return this.levels.equals(o.levels);
    }

    public int getNumAwayFrom(LogicTreeBranch<?> o) {
        Preconditions.checkArgument((boolean)this.areLevelsEqual(o), (Object)"Supplied branch has different levels");
        int away = 0;
        for (int i = 0; i < this.levels.size(); ++i) {
            LogicTreeNode mine = (LogicTreeNode)this.values.get(i);
            LogicTreeNode theirs = (LogicTreeNode)o.values.get(i);
            if (mine == null || mine.equals(theirs)) continue;
            ++away;
        }
        return away;
    }

    public boolean matchesNonNulls(LogicTreeBranch<?> branch) {
        return this.getNumAwayFrom(branch) == 0;
    }

    public String buildFileName() {
        StringBuilder fileName = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            LogicTreeNode value = (LogicTreeNode)this.values.get(i);
            if (value == null) {
                throw new IllegalStateException("Must be fully specified to build file name! (missing=" + ((LogicTreeLevel)this.levels.get(i)).getName() + ")");
            }
            if (i > 0) {
                fileName.append('_');
            }
            fileName.append(value.getFilePrefix());
        }
        return fileName.toString();
    }

    public File getBranchDirectory(File parentDir, boolean mkdir) {
        return this.getBranchDirectory(parentDir, mkdir, "");
    }

    public File getBranchDirectory(File parentDir, boolean mkdir, String suffix) {
        if (suffix == null) {
            suffix = "";
        }
        StringBuilder fileName = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            LogicTreeNode value = (LogicTreeNode)this.values.get(i);
            if (value == null) {
                throw new IllegalStateException("Must be fully specified to build file name! (missing=" + ((LogicTreeLevel)this.levels.get(i)).getName() + ")");
            }
            String prefix = value.getFilePrefix();
            int newLen = fileName.length() + prefix.length() + 1 + suffix.length();
            if (newLen >= 255) {
                File subDir = new File(parentDir, fileName.toString());
                Preconditions.checkState((!mkdir || subDir.exists() || subDir.mkdir() ? 1 : 0) != 0, (String)"Directory doesn't exist and couldn't be created: %s", (Object)subDir.getAbsolutePath());
                parentDir = subDir;
                fileName.setLength(0);
            }
            if (fileName.length() > 0) {
                fileName.append('_');
            }
            fileName.append(prefix);
        }
        Preconditions.checkState((fileName.length() > 0 ? 1 : 0) != 0);
        fileName.append(suffix);
        File dir = new File(parentDir, fileName.toString());
        Preconditions.checkState((!mkdir || dir.exists() || dir.mkdir() ? 1 : 0) != 0, (String)"Directory doesn't exist and couldn't be created: %s", (Object)dir.getAbsolutePath());
        return dir;
    }

    public String getBranchZipPath() {
        StringBuilder fileName = new StringBuilder();
        int length = 0;
        for (int i = 0; i < this.size(); ++i) {
            LogicTreeNode value = (LogicTreeNode)this.values.get(i);
            if (value == null) {
                throw new IllegalStateException("Must be fully specified to build file name! (missing=" + ((LogicTreeLevel)this.levels.get(i)).getName() + ")");
            }
            String prefix = value.getFilePrefix();
            int newLen = fileName.length() + prefix.length() + 1;
            if (newLen >= 255) {
                fileName.append('/');
                length = 0;
            }
            if (length > 0) {
                fileName.append('_');
                ++length;
            }
            length += prefix.length();
            fileName.append(prefix);
        }
        return fileName.toString();
    }

    public String toString() {
        String str = null;
        for (LogicTreeNode val : this.values) {
            str = str == null ? ClassUtils.getClassNameWithoutPackage(this.getClass()) + "[" : str + ", ";
            if (val == null) {
                str = str + "(null)";
                continue;
            }
            str = str + val.getFilePrefix();
        }
        return str + "]";
    }

    public LogicTreeBranch<E> copy() {
        return new LogicTreeBranch<E>(this.levels, this.values);
    }

    public Object clone() {
        return this.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getOrigBranchWeight() {
        if (this.originalWeight == null) {
            LogicTreeBranch logicTreeBranch = this;
            synchronized (logicTreeBranch) {
                if (this.originalWeight == null) {
                    this.originalWeight = this.getBranchWeight();
                }
            }
        }
        return this.originalWeight;
    }

    public void setOrigBranchWeight(double originalWeight) {
        this.originalWeight = originalWeight;
    }

    public double getBranchWeight() {
        double wt = 1.0;
        for (LogicTreeNode value : this.values) {
            if (value == null) continue;
            wt *= value.getNodeWeight(this);
        }
        return wt;
    }

    @Override
    public int compareTo(LogicTreeBranch<E> o) {
        int size = Integer.min(this.size(), o.size());
        for (int i = 0; i < size; ++i) {
            E val = this.getValue(i);
            E oval = o.getValue(i);
            int cmp = val == null || oval == null ? (val == null ? (oval == null ? 0 : -1) : 1) : val.getShortName().compareTo(oval.getShortName());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.values.iterator();
    }

    @Override
    public String getFileName() {
        return "logic_tree_branch.json";
    }

    @Override
    public String getName() {
        return "Logic Tree Branch";
    }

    @Override
    public Gson buildGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeHierarchyAdapter(LogicTreeNode.class, (Object)new NodeTypeAdapter(this));
        builder.registerTypeHierarchyAdapter(LogicTreeLevel.class, new LogicTreeLevel.Adapter());
        return builder.create();
    }

    @Override
    public void writeToJSON(JsonWriter out, Gson gson) throws IOException {
        new Adapter().write(out, this);
    }

    @Override
    public void initFromJSON(JsonReader in, Gson gson) throws IOException {
        Object unchecked = new Adapter().read(in);
        ArrayList<LogicTreeLevel<E>> levels = new ArrayList<LogicTreeLevel<E>>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < ((LogicTreeBranch)unchecked).size(); ++i) {
            Object value;
            LogicTreeLevel<E> level;
            try {
                level = ((LogicTreeBranch)unchecked).getLevel(i);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Could not cast level '" + ((LogicTreeBranch)unchecked).getLevel(i).getName() + " to type", e);
            }
            try {
                value = ((LogicTreeBranch)unchecked).getValue(i) == null ? null : (Object)((LogicTreeBranch)unchecked).getValue(i);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Could not cast value '" + ((LogicTreeBranch)unchecked).getValue(i).getName() + " to type", e);
            }
            levels.add(level);
            values.add(value);
        }
        this.init((List<LogicTreeLevel<? extends E>>)ImmutableList.copyOf(levels), values);
    }

    public static void main(String[] args) throws IOException {
        ArrayList<LogicTreeLevel<LogicTreeLevel>> levels = new ArrayList<LogicTreeLevel<LogicTreeLevel>>();
        ArrayList<LogicTreeNode> values = new ArrayList<LogicTreeNode>();
        LogicTreeNode.FileBackedNode node = new LogicTreeNode.FileBackedNode("Node 1", "Node1", 1.0, "n1");
        levels.add(new LogicTreeLevel.FileBackedLevel("Level 1", "Level1", node));
        values.add(node);
        node = new LogicTreeNode.FileBackedNode("Node 2", "Node2", 1.0, "n2");
        levels.add(new LogicTreeLevel.FileBackedLevel("Level 2", "Level2", node));
        values.add(node);
        node = null;
        levels.add(new LogicTreeLevel.FileBackedLevel("Level 3", "Level3", node));
        values.add(node);
        LogicTreeBranch branch = new LogicTreeBranch(levels, values);
        String json = branch.getJSON();
        System.out.println(json);
        LogicTreeBranch branch2 = new LogicTreeBranch();
        branch2.initFromJSON(json);
        String json2 = branch2.getJSON();
        System.out.println("Branch equal? " + branch2.equals(branch));
        System.out.println("Num away? " + branch.getNumAwayFrom(branch2));
        System.out.println("JSON equal? " + json.equals(json2));
        System.out.println("***** ENUM test *****");
        levels.clear();
        values.clear();
        levels.add(LogicTreeLevel.forEnum(FaultModels.class, "Fault Model", "FM"));
        values.add(FaultModels.FM3_1);
        levels.add(LogicTreeLevel.forEnum(DeformationModels.class, "Deformation Model", "DM"));
        values.add(DeformationModels.GEOLOGIC);
        levels.add(LogicTreeLevel.forEnum(InversionModels.class, "Inversion Model", "IM"));
        values.add(null);
        branch = new LogicTreeBranch(levels, values);
        json = branch.getJSON();
        System.out.println(json);
        branch2 = new LogicTreeBranch();
        branch2.initFromJSON(json);
        json2 = branch2.getJSON();
        System.out.println("Branch equal? " + branch2.equals(branch));
        System.out.println("Num away? " + branch.getNumAwayFrom(branch2));
        System.out.println("JSON equal? " + json.equals(json2));
    }

    @Override
    public LogicTreeBranch<E> getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
        return this;
    }

    @Override
    public LogicTreeBranch<E> getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
        return this;
    }

    static class NodeTypeAdapter
    extends TypeAdapter<LogicTreeNode> {
        private LogicTreeBranch<?> branch;
        private boolean forceFileBacked;

        public NodeTypeAdapter(LogicTreeBranch<?> branch) {
            this(branch, false);
        }

        public NodeTypeAdapter(LogicTreeBranch<?> branch, boolean forceFileBacked) {
            this.branch = branch;
            this.forceFileBacked = forceFileBacked;
        }

        public void write(JsonWriter out, LogicTreeNode value) throws IOException {
            out.beginObject();
            out.name("name").value(value.getName());
            out.name("shortName").value(value.getShortName());
            out.name("prefix").value(value.getFilePrefix());
            out.name("weight").value(value.getNodeWeight(this.branch));
            if (value instanceof Enum) {
                Class<?> enumClass = value.getClass();
                if (!enumClass.isEnum()) {
                    enumClass = enumClass.getEnclosingClass();
                }
                Preconditions.checkNotNull(enumClass, (Object)"Enum class null?");
                Preconditions.checkState((boolean)enumClass.isEnum(), (Object)"Enum enclosing class not an enum?");
                out.name("enumClass").value(enumClass.getName());
                out.name("enumName").value(((Enum)((Object)value)).name());
            } else if (value instanceof LogicTreeNode.RandomlySampledNode) {
                out.name("class").value(value.getClass().getName());
                out.name("randomSeed").value(((LogicTreeNode.RandomlySampledNode)value).getSeed());
            } else if (JsonAdapterHelper.hasTypeAdapter(value)) {
                out.name("adapterValue");
                JsonAdapterHelper.writeAdapterValue(out, value);
            } else if (!(value instanceof LogicTreeNode.FileBackedNode)) {
                out.name("class").value(value.getClass().getName());
            }
            out.endObject();
        }

        public LogicTreeNode read(JsonReader in) throws IOException {
            String name = null;
            String shortName = null;
            String prefix = null;
            double weight = 0.0;
            Class<?> clazz = null;
            Class<?> enumClass = null;
            String enumName = null;
            Long randomSeed = null;
            LogicTreeNode adapterNode = null;
            in.beginObject();
            block30: while (in.hasNext()) {
                Enum[] jsonName;
                switch (jsonName = in.nextName()) {
                    case "name": {
                        name = in.nextString();
                        continue block30;
                    }
                    case "shortName": {
                        shortName = in.nextString();
                        continue block30;
                    }
                    case "prefix": {
                        prefix = in.nextString();
                        continue block30;
                    }
                    case "weight": {
                        weight = in.nextDouble();
                        continue block30;
                    }
                    case "class": {
                        String className = in.nextString();
                        try {
                            Class<?> rawClass;
                            clazz = rawClass = Class.forName(className);
                        }
                        catch (ClassNotFoundException e) {
                            System.err.println("WARNING: couldn't locate logic tree branch node class '" + className + "', loading plain/hardcoded version instead");
                        }
                        catch (ClassCastException e) {
                            System.err.println("WARNING: logic tree branch node class '" + className + "' is of the wrong type, loading plain/hardcoded version instead");
                        }
                        continue block30;
                    }
                    case "enumClass": {
                        String enumClassName = in.nextString();
                        try {
                            Class<?> rawClass;
                            enumClass = rawClass = Class.forName(enumClassName);
                        }
                        catch (ClassNotFoundException e) {
                            System.err.println("WARNING: couldn't locate logic tree branch node enum class '" + enumClassName + "', loading plain/hardcoded version instead");
                        }
                        catch (ClassCastException e) {
                            System.err.println("WARNING: logic tree branch node class '" + enumClassName + "' is of the wrong type, loading plain/hardcoded version instead");
                        }
                        continue block30;
                    }
                    case "enumName": {
                        enumName = in.nextString();
                        continue block30;
                    }
                    case "randomSeed": {
                        randomSeed = in.nextLong();
                        continue block30;
                    }
                    case "adapterValue": {
                        adapterNode = (LogicTreeNode)JsonAdapterHelper.readAdapterValue(in);
                        continue block30;
                    }
                }
                System.err.println("WARNING: unexpected JSON field named '" + (String)jsonName + "' in LogicTreeNode, skipping");
                in.skipValue();
            }
            in.endObject();
            if (!this.forceFileBacked && adapterNode != null) {
                if (adapterNode instanceof LogicTreeNode.AdapterBackedNode) {
                    ((LogicTreeNode.AdapterBackedNode)adapterNode).init(name, shortName, prefix, weight);
                }
                return adapterNode;
            }
            if (!this.forceFileBacked && enumClass != null && enumName != null) {
                for (Enum option : (Enum[])enumClass.getEnumConstants()) {
                    if (!option.name().equals(enumName)) continue;
                    return (LogicTreeNode)((Object)option);
                }
            }
            if (!this.forceFileBacked && clazz != null) {
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    LogicTreeNode instance = (LogicTreeNode)constructor.newInstance(new Object[0]);
                    if (instance instanceof LogicTreeNode.RandomlySampledNode) {
                        Preconditions.checkState((randomSeed != null ? 1 : 0) != 0, (Object)"Have a randomly sampled node instance but no seed?");
                        LogicTreeNode.RandomlySampledNode sample = (LogicTreeNode.RandomlySampledNode)instance;
                        Preconditions.checkState((shortName != null || name != null ? 1 : 0) != 0, (Object)"Must supply either name or short name");
                        if (name == null) {
                            name = shortName;
                        } else if (shortName == null) {
                            shortName = name;
                        }
                        if (prefix == null) {
                            prefix = shortName;
                        }
                        sample.init(name, shortName, prefix, weight, randomSeed);
                    } else {
                        Preconditions.checkState((randomSeed == null ? 1 : 0) != 0, (String)"Found a random seed but instance is not a RandomlySampledNode. Instance class: %s", clazz);
                    }
                    return instance;
                }
                catch (Exception e) {
                    System.err.println("Couldn't instantiate default no-arg constructor of declared logic tree node class, loading plain/hardcoded version instead");
                }
            }
            Preconditions.checkState((shortName != null || name != null ? 1 : 0) != 0, (Object)"Must supply either name or short name");
            if (name == null) {
                name = shortName;
            } else if (shortName == null) {
                shortName = name;
            }
            if (prefix == null) {
                prefix = shortName;
            }
            return new LogicTreeNode.FileBackedNode(name, shortName, weight, prefix);
        }
    }

    public static class Adapter
    extends TypeAdapter<LogicTreeBranch<?>> {
        public void write(JsonWriter out, LogicTreeBranch<?> branch) throws IOException {
            NodeTypeAdapter nodeAdapter = new NodeTypeAdapter(branch);
            LogicTreeLevel.Adapter levelAdapter = new LogicTreeLevel.Adapter(false);
            out.beginObject();
            double origWeight = branch.getOrigBranchWeight();
            if (Double.isFinite(origWeight)) {
                out.name("origWeight").value(origWeight);
            }
            out.name("values").beginArray();
            for (int i = 0; i < branch.size(); ++i) {
                out.beginObject();
                out.name("level");
                levelAdapter.write(out, (LogicTreeLevel)branch.levels.get(i));
                LogicTreeNode node = (LogicTreeNode)branch.values.get(i);
                if (node != null) {
                    out.name("value");
                    nodeAdapter.write(out, node);
                }
                out.endObject();
            }
            out.endArray();
            out.endObject();
        }

        public LogicTreeBranch<?> read(JsonReader in) throws IOException {
            ArrayList<LogicTreeLevel<? extends LogicTreeNode>> levels = new ArrayList<LogicTreeLevel<? extends LogicTreeNode>>();
            ArrayList<LogicTreeNode> values = new ArrayList<LogicTreeNode>();
            if (in.peek() == JsonToken.BEGIN_OBJECT) {
                in.beginObject();
                Double origWeight = null;
                block8: while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "origWeight": {
                            origWeight = in.nextDouble();
                            continue block8;
                        }
                        case "values": {
                            this.loadValueArray(in, levels, values);
                            continue block8;
                        }
                    }
                    in.skipValue();
                }
                in.endObject();
                LogicTreeBranch<LogicTreeNode> branch = new LogicTreeBranch<LogicTreeNode>(levels, values);
                branch.originalWeight = origWeight;
                return branch;
            }
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                this.loadValueArray(in, levels, values);
                return new LogicTreeBranch<LogicTreeNode>(levels, values);
            }
            Preconditions.checkState((in.peek() == JsonToken.NULL ? 1 : 0) != 0);
            return null;
        }

        public void loadValueArray(JsonReader in, List<LogicTreeLevel<? extends LogicTreeNode>> levels, List<LogicTreeNode> values) throws IOException {
            NodeTypeAdapter nodeAdapter = new NodeTypeAdapter(null);
            LogicTreeLevel.Adapter levelAdapter = new LogicTreeLevel.Adapter();
            in.beginArray();
            while (in.hasNext()) {
                in.beginObject();
                Object level = null;
                LogicTreeNode value = null;
                while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "level": {
                            level = levelAdapter.read(in);
                            break;
                        }
                        case "value": {
                            value = nodeAdapter.read(in);
                            break;
                        }
                    }
                }
                Preconditions.checkNotNull(level, (String)"Branch level not supplied at index %s", (int)levels.size());
                if (value != null) {
                    if (value instanceof LogicTreeNode.FileBackedNode) {
                        if (level instanceof LogicTreeLevel.FileBackedLevel) {
                            ((LogicTreeLevel.FileBackedLevel)level).addChoice((LogicTreeNode.FileBackedNode)value);
                        } else {
                            level = new LogicTreeLevel.FileBackedLevel(level.getName(), level.getShortName(), (LogicTreeNode.FileBackedNode)value);
                        }
                    } else if (value instanceof LogicTreeNode.RandomlySampledNode && level instanceof LogicTreeLevel.RandomlySampledLevel) {
                        LogicTreeLevel.RandomlySampledLevel randLevel = (LogicTreeLevel.RandomlySampledLevel)level;
                        if (randLevel.getNodes().isEmpty()) {
                            randLevel.setNodes(List.of(value));
                        } else {
                            Preconditions.checkState((boolean)randLevel.isMember(value), (String)"Random level '%s' has node list, but our node ('%s' with seed %s) isn't a member", (Object)level.getName(), (Object)value.getName(), (Object)((LogicTreeNode.RandomlySampledNode)value).getSeed());
                        }
                    }
                }
                levels.add((LogicTreeLevel<? extends LogicTreeNode>)level);
                values.add(value);
                in.endObject();
            }
            in.endArray();
        }
    }
}

