/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.logicTree;

import java.io.Serializable;
import org.opensha.commons.data.ShortNamed;
import org.opensha.commons.logicTree.LogicTreeBranch;

public interface LogicTreeNode
extends ShortNamed,
Serializable {
    public double getNodeWeight(LogicTreeBranch<?> var1);

    public String getFilePrefix();

    public static interface RandomlySampledNode
    extends LogicTreeNode {
        public long getSeed();

        public void init(String var1, String var2, String var3, double var4, long var6);
    }

    public static interface AdapterBackedNode
    extends LogicTreeNode {
        public void init(String var1, String var2, String var3, double var4);
    }

    public static class FileBackedNode
    implements LogicTreeNode {
        private String name;
        private String shortName;
        private double weight;
        private String choiceStr;

        public FileBackedNode(String name, String shortName, double weight, String choiceStr) {
            this.name = name;
            this.shortName = shortName;
            this.weight = weight;
            this.choiceStr = choiceStr;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return this.weight;
        }

        @Override
        public String getFilePrefix() {
            return this.choiceStr;
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.choiceStr == null ? 0 : this.choiceStr.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.shortName == null ? 0 : this.shortName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileBackedNode other = (FileBackedNode)obj;
            if (this.choiceStr == null ? other.choiceStr != null : !this.choiceStr.equals(other.choiceStr)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName));
        }
    }
}

