/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.logicTree.treeCombiner;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.logicTree.BranchWeightProvider;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.logicTree.treeCombiner.LogicTreeCombinationProcessor;
import org.opensha.commons.util.ExecutorUtils;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;

public abstract class AbstractLogicTreeCombiner {
    private LogicTree<?> outerTree;
    private LogicTree<?> innerTree;
    private Map<LogicTreeLevel<?>, LogicTreeLevel<?>> outerLevelRemaps;
    private Map<LogicTreeNode, LogicTreeNode> outerNodeRemaps;
    private Map<LogicTreeLevel<?>, LogicTreeLevel<?>> innerLevelRemaps;
    private Map<LogicTreeNode, LogicTreeNode> innerNodeRemaps;
    private List<LogicTreeLevel<? extends LogicTreeNode>> combLevels;
    private int expectedNum;
    private List<LogicTreeLevel<? extends LogicTreeNode>> commonLevels;
    private List<LogicTreeLevel<? extends LogicTreeNode>> averageAcrossLevels;
    private Map<LogicTreeBranch<LogicTreeNode>, LogicTree<?>> commonSubtrees;
    private List<LogicTreeBranch<LogicTreeNode>> combBranches;
    private List<Integer> combBranchesOuterIndexes;
    private List<LogicTreeBranch<?>> combBranchesOuterPortion;
    private List<Integer> combBranchesInnerIndexes;
    private List<LogicTreeBranch<?>> combBranchesInnerPortion;
    private int numSamples = -1;
    private int numPairwiseSamples = -1;
    private Random pairwiseSampleRand;
    private LogicTree<LogicTreeNode> combTree;
    private LogicTree<?> origOuterTree = null;
    private LogicTree<?> origInnerTree = null;
    private List<LogicTreeCombinationProcessor> processors = new ArrayList<LogicTreeCombinationProcessor>();
    private static final DecimalFormat twoDigits = new DecimalFormat("0.00");
    private static final DecimalFormat pDF = new DecimalFormat("0.00%");
    private static final DecimalFormat countDF = new DecimalFormat("0.#");

    public AbstractLogicTreeCombiner(LogicTree<?> outerLT, LogicTree<?> innerLT) {
        this(outerLT, innerLT, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractLogicTreeCombiner(LogicTree<?> outerLT, LogicTree<?> innerLT, List<LogicTreeLevel<? extends LogicTreeNode>> commonLevels, List<LogicTreeLevel<?>> averageAcrossLevels) {
        System.out.println("Remapping outer logic tree levels");
        this.outerLevelRemaps = new HashMap();
        this.outerNodeRemaps = new HashMap<LogicTreeNode, LogicTreeNode>();
        this.remapOuterTree(outerLT, this.outerLevelRemaps, this.outerNodeRemaps);
        System.out.println("Remapping inner logic tree levels");
        this.innerLevelRemaps = new HashMap();
        this.innerNodeRemaps = new HashMap<LogicTreeNode, LogicTreeNode>();
        this.remapInnerTree(innerLT, this.innerLevelRemaps, this.innerNodeRemaps);
        this.outerTree = outerLT;
        this.innerTree = innerLT;
        int innerTreeSize = this.innerTree.size();
        if (commonLevels == null) {
            commonLevels = List.of();
        } else if (!commonLevels.isEmpty()) {
            Preconditions.checkState((commonLevels.size() < this.outerTree.getLevels().size() ? 1 : 0) != 0, (Object)"At least one level of the outer tree must be unique.");
            Preconditions.checkState((commonLevels.size() < this.innerTree.getLevels().size() ? 1 : 0) != 0, (Object)"At least one level of the inner tree must be unique.");
            for (LogicTreeLevel logicTreeLevel : commonLevels) {
                Preconditions.checkState((!this.outerLevelRemaps.containsKey(logicTreeLevel) || this.outerLevelRemaps.get(logicTreeLevel).equals(logicTreeLevel) ? 1 : 0) != 0, (String)"Outer remaps include a common level: %s", (Object)logicTreeLevel.getName());
                Preconditions.checkState((!this.innerLevelRemaps.containsKey(logicTreeLevel) || this.innerLevelRemaps.get(logicTreeLevel).equals(logicTreeLevel) ? 1 : 0) != 0, (String)"Inner remaps include a common level: %s", (Object)logicTreeLevel.getName());
                Preconditions.checkState((boolean)this.outerTree.getLevels().contains((Object)logicTreeLevel), (String)"Outer tree doesn't contain level %s, but it's a common level?", (Object)logicTreeLevel.getName());
                Preconditions.checkState((boolean)this.innerTree.getLevels().contains((Object)logicTreeLevel), (String)"Inner tree doesn't contain level %s, but it's a common level?", (Object)logicTreeLevel.getName());
            }
            this.commonSubtrees = new HashMap();
            for (LogicTreeBranch logicTreeBranch : this.outerTree) {
                ArrayList<LogicTreeNode> commonNodes = new ArrayList<LogicTreeNode>(commonLevels.size());
                for (LogicTreeLevel<LogicTreeNode> logicTreeLevel : commonLevels) {
                    LogicTreeNode node = logicTreeBranch.requireValue(logicTreeLevel.getType());
                    Preconditions.checkNotNull((Object)node);
                    commonNodes.add(node);
                }
                LogicTreeBranch commonBranch = new LogicTreeBranch(commonLevels, commonNodes);
                if (this.commonSubtrees.containsKey(commonBranch)) continue;
                LogicTreeNode[] logicTreeNodeArray = commonNodes.toArray(new LogicTreeNode[commonNodes.size()]);
                LogicTree<?> subtree = this.innerTree.matchingAll(logicTreeNodeArray);
                Preconditions.checkState((subtree.size() > 0 ? 1 : 0) != 0, (String)"Inner tree doesn't have any branches with these common values from the outer tree: %s", commonNodes);
                innerTreeSize = subtree.size();
                this.commonSubtrees.put(commonBranch, subtree);
            }
        }
        if (averageAcrossLevels == null) {
            averageAcrossLevels = List.of();
        } else if (!averageAcrossLevels.isEmpty()) {
            System.out.println("Averaging across " + averageAcrossLevels.size() + " levels");
            this.origOuterTree = this.outerTree;
            this.origInnerTree = this.innerTree;
            this.outerTree = AbstractLogicTreeCombiner.removeAveragedOutLevels(this.outerTree, averageAcrossLevels);
            this.innerTree = AbstractLogicTreeCombiner.removeAveragedOutLevels(this.innerTree, averageAcrossLevels);
            System.out.println("Reduced outerTree from " + this.origOuterTree.size() + " to " + this.outerTree.size() + " branches");
            System.out.println("Reduced innerTree from " + this.origInnerTree.size() + " to " + this.innerTree.size() + " branches");
            Preconditions.checkState((this.origOuterTree != this.outerTree || this.origInnerTree != this.innerTree ? 1 : 0) != 0);
        }
        this.combLevels = new ArrayList<LogicTreeLevel<? extends LogicTreeNode>>();
        for (LogicTreeLevel logicTreeLevel : this.outerTree.getLevels()) {
            void var7_13;
            if (averageAcrossLevels.contains(logicTreeLevel)) continue;
            if (this.outerLevelRemaps.containsKey(logicTreeLevel)) {
                LogicTreeLevel<?> logicTreeLevel2 = this.outerLevelRemaps.get(logicTreeLevel);
            }
            this.combLevels.add((LogicTreeLevel<? extends LogicTreeNode>)var7_13);
        }
        for (LogicTreeLevel logicTreeLevel : this.innerTree.getLevels()) {
            void var7_17;
            if (averageAcrossLevels.contains(logicTreeLevel)) continue;
            if (this.innerLevelRemaps.containsKey(logicTreeLevel)) {
                LogicTreeLevel<?> logicTreeLevel3 = this.innerLevelRemaps.get(logicTreeLevel);
            }
            if (commonLevels.contains(var7_17)) continue;
            this.combLevels.add((LogicTreeLevel<? extends LogicTreeNode>)var7_17);
        }
        System.out.println("Combined levels:");
        for (LogicTreeLevel logicTreeLevel : this.combLevels) {
            System.out.println(logicTreeLevel.getName() + " (" + logicTreeLevel.getShortName() + ")");
        }
        this.expectedNum = this.outerTree.size() * innerTreeSize;
        System.out.println("Total number of combinations: " + countDF.format(this.expectedNum));
        this.commonLevels = commonLevels;
        this.averageAcrossLevels = averageAcrossLevels;
    }

    private static LogicTree<?> removeAveragedOutLevels(LogicTree<?> tree, List<LogicTreeLevel<? extends LogicTreeNode>> averageAcrossLevels) {
        ArrayList<LogicTreeLevel<LogicTreeLevel>> retainedLevels = new ArrayList<LogicTreeLevel<LogicTreeLevel>>();
        for (LogicTreeLevel level : tree.getLevels()) {
            if (averageAcrossLevels.contains(level)) continue;
            retainedLevels.add(level);
        }
        Preconditions.checkState((!retainedLevels.isEmpty() ? 1 : 0) != 0);
        if (retainedLevels.size() == tree.getLevels().size()) {
            return tree;
        }
        HashMap retainedBranchesMap = new HashMap();
        ArrayList retainedBranches = new ArrayList();
        ArrayList<Double> retainedWeights = new ArrayList<Double>();
        for (LogicTreeBranch<?> branch : tree) {
            LogicTreeBranch retainedBranch = new LogicTreeBranch(retainedLevels);
            for (LogicTreeLevel level : retainedLevels) {
                retainedBranch.setValue(branch.getValue(level.getType()));
            }
            for (int l = 0; l < branch.size(); ++l) {
                Preconditions.checkNotNull(branch.getValue(l));
            }
            Integer prevIndex = (Integer)retainedBranchesMap.get(retainedBranch);
            if (prevIndex == null) {
                retainedBranchesMap.put(retainedBranch, retainedBranches.size());
                retainedBranches.add(retainedBranch);
                retainedWeights.add(tree.getBranchWeight(branch));
                continue;
            }
            retainedWeights.set(prevIndex, (Double)retainedWeights.get(prevIndex) + tree.getBranchWeight(branch));
        }
        for (int i = 0; i < retainedBranches.size(); ++i) {
            ((LogicTreeBranch)retainedBranches.get(i)).setOrigBranchWeight((Double)retainedWeights.get(i));
        }
        LogicTree ret = LogicTree.fromExisting(retainedLevels, retainedBranches);
        ret.setWeightProvider(new BranchWeightProvider.OriginalWeights());
        return ret;
    }

    protected abstract void remapOuterTree(LogicTree<?> var1, Map<LogicTreeLevel<?>, LogicTreeLevel<?>> var2, Map<LogicTreeNode, LogicTreeNode> var3);

    protected abstract void remapInnerTree(LogicTree<?> var1, Map<LogicTreeLevel<?>, LogicTreeLevel<?>> var2, Map<LogicTreeNode, LogicTreeNode> var3);

    public LogicTree<?> getOuterTree() {
        return this.outerTree;
    }

    public LogicTree<?> getInnerTree() {
        return this.innerTree;
    }

    public LogicTree<LogicTreeNode> getCombTree() {
        if (this.combTree == null) {
            this.buildCominedTree();
        }
        return this.combTree;
    }

    public static LogicTree<?> pairwiseSampleLogicTrees(LogicTree<?> outerTree, LogicTree<?> innerTree, int numPairwiseSamples) {
        return AbstractLogicTreeCombiner.pairwiseSampleLogicTrees(outerTree, innerTree, numPairwiseSamples, 1);
    }

    public static LogicTree<?> pairwiseSampleLogicTrees(LogicTree<?> outerTree, LogicTree<?> innerTree, int numOuterSamples, int numInnerPerOuter) {
        AbstractLogicTreeCombiner comb = new AbstractLogicTreeCombiner((LogicTree)outerTree, (LogicTree)innerTree){

            @Override
            protected void remapOuterTree(LogicTree<?> tree, Map<LogicTreeLevel<?>, LogicTreeLevel<?>> levelRemaps, Map<LogicTreeNode, LogicTreeNode> nodeRemaps) {
            }

            @Override
            protected void remapInnerTree(LogicTree<?> tree, Map<LogicTreeLevel<?>, LogicTreeLevel<?>> levelRemaps, Map<LogicTreeNode, LogicTreeNode> nodeRemaps) {
            }
        };
        long rand = (long)comb.expectedNum * (long)numOuterSamples * (long)numInnerPerOuter;
        comb.pairwiseSampleTree(numOuterSamples, numInnerPerOuter, rand);
        comb.buildCominedTree();
        return comb.combTree;
    }

    private void buildCominedTree() {
        System.out.println("Building combined tree");
        if (this.commonLevels.isEmpty()) {
            this.combBranches = new ArrayList<LogicTreeBranch<LogicTreeNode>>(this.expectedNum);
            this.combBranchesOuterPortion = new ArrayList(this.expectedNum);
            this.combBranchesInnerPortion = new ArrayList(this.expectedNum);
            this.combBranchesOuterIndexes = new ArrayList<Integer>(this.expectedNum);
            this.combBranchesInnerIndexes = new ArrayList<Integer>(this.expectedNum);
        } else {
            this.combBranches = new ArrayList<LogicTreeBranch<LogicTreeNode>>();
            this.combBranchesOuterPortion = new ArrayList();
            this.combBranchesInnerPortion = new ArrayList();
            this.combBranchesOuterIndexes = new ArrayList<Integer>();
            this.combBranchesInnerIndexes = new ArrayList<Integer>();
        }
        boolean pairwise = this.numPairwiseSamples > 0;
        HashBasedTable prevPairs = null;
        HashMap outerSampleCounts = null;
        HashMap outerTotalWeights = null;
        ArrayList<Integer> branchSampleCounts = null;
        int numPairDuplicates = 0;
        if (pairwise) {
            prevPairs = HashBasedTable.create();
            outerSampleCounts = new HashMap();
            outerTotalWeights = new HashMap();
            branchSampleCounts = this.commonLevels.isEmpty() ? new ArrayList(this.expectedNum) : new ArrayList<Integer>();
        }
        int printMod = 100;
        HashMap innerBranchIndexes = new HashMap();
        for (int i = 0; i < this.innerTree.size(); ++i) {
            innerBranchIndexes.put(this.innerTree.getBranch(i), i);
        }
        int debugMax = 100;
        for (int o = 0; o < this.outerTree.size(); ++o) {
            LogicTree<?> matchingInnerTree;
            LogicTreeBranch<?> outerBranch = this.outerTree.getBranch(o);
            if (this.commonSubtrees == null) {
                matchingInnerTree = this.innerTree;
            } else {
                ArrayList<LogicTreeNode> commonNodes = new ArrayList<LogicTreeNode>();
                for (LogicTreeLevel<? extends LogicTreeNode> level : this.commonLevels) {
                    commonNodes.add(outerBranch.requireValue(level.getType()));
                }
                LogicTreeBranch commonBranch = new LogicTreeBranch(this.commonLevels, commonNodes);
                matchingInnerTree = this.commonSubtrees.get(commonBranch);
                Preconditions.checkNotNull(matchingInnerTree);
            }
            int numInner = this.numPairwiseSamples > 0 ? this.numPairwiseSamples : matchingInnerTree.size();
            for (int i = 0; i < numInner; ++i) {
                Object getNode;
                Object node;
                int l;
                double weight;
                LogicTreeBranch<?> innerBranch;
                if (pairwise) {
                    int prevOuterSampleCount;
                    IntegerPDF_FunctionSampler sampler = matchingInnerTree.getSampler();
                    innerBranch = matchingInnerTree.getBranch(matchingInnerTree.getSampler().getRandomInt(this.pairwiseSampleRand));
                    int n = prevOuterSampleCount = outerSampleCounts.containsKey(outerBranch) ? (Integer)outerSampleCounts.get(outerBranch) : 0;
                    while (prevPairs.contains(outerBranch, innerBranch)) {
                        Preconditions.checkState((prevPairs.row(outerBranch).size() < matchingInnerTree.size() ? 1 : 0) != 0, (String)"Already sampled all %s inner branches for outer branch %s: %s", (Object)matchingInnerTree.size(), (Object)o, outerBranch);
                        int prevIndex = (Integer)prevPairs.get(outerBranch, innerBranch);
                        branchSampleCounts.set(prevIndex, (Integer)branchSampleCounts.get(prevIndex) + 1);
                        ++prevOuterSampleCount;
                        innerBranch = matchingInnerTree.getBranch(sampler.getRandomInt(this.pairwiseSampleRand));
                        ++numPairDuplicates;
                    }
                    prevPairs.put(outerBranch, innerBranch, (Object)this.combBranches.size());
                    outerSampleCounts.put(outerBranch, prevOuterSampleCount + 1);
                    double prevOuterWeight = outerTotalWeights.containsKey(outerBranch) ? (Double)outerTotalWeights.get(outerBranch) : 0.0;
                    outerTotalWeights.put(outerBranch, prevOuterWeight + this.outerTree.getBranchWeight(o));
                    branchSampleCounts.add(1);
                    weight = 1.0;
                } else {
                    innerBranch = matchingInnerTree.getBranch(i);
                    weight = this.outerTree.getBranchWeight(o) * this.innerTree.getBranchWeight(i);
                }
                LogicTreeBranch combBranch = new LogicTreeBranch(this.combLevels);
                int combNodeIndex = 0;
                for (l = 0; l < outerBranch.size(); ++l) {
                    LogicTreeNode remappedNode;
                    node = outerBranch.getValue(l);
                    if (this.outerNodeRemaps.containsKey(node) && (remappedNode = this.outerNodeRemaps.get(node)) != node) {
                        node = remappedNode;
                    }
                    combBranch.setValue(node);
                    getNode = combBranch.getValue(combNodeIndex);
                    Preconditions.checkState((getNode == node ? 1 : 0) != 0, (String)"Set didn't work for node %s of combined branch: %s, has %s", (Object)combNodeIndex, node, getNode);
                    ++combNodeIndex;
                }
                for (l = 0; l < innerBranch.size(); ++l) {
                    if (this.commonLevels.contains(innerBranch.getLevel(l))) continue;
                    node = innerBranch.getValue(l);
                    if (this.innerNodeRemaps.containsKey(node)) {
                        node = this.innerNodeRemaps.get(node);
                    }
                    combBranch.setValue(node);
                    getNode = combBranch.getValue(combNodeIndex);
                    Preconditions.checkState((getNode == node ? 1 : 0) != 0, (String)"Set didn't work for node %s of combined branch: %s, has %s;\n\tInner branch: %s\n\tOuter branch: %s\n\tCombined branch: %s", (Object[])new Object[]{combNodeIndex, node, getNode, innerBranch, outerBranch, combBranch});
                    ++combNodeIndex;
                }
                combBranch.setOrigBranchWeight(weight);
                if (this.combBranches.size() < debugMax) {
                    System.out.println("Build debug for branch " + this.combBranches.size());
                    System.out.println("\tCombined: " + String.valueOf(combBranch));
                    System.out.println("\tOuter " + o + ": " + String.valueOf(outerBranch));
                    System.out.println("\tInner " + String.valueOf(innerBranchIndexes.get(innerBranch)) + ": " + String.valueOf(innerBranch));
                }
                this.combBranches.add(combBranch);
                this.combBranchesOuterPortion.add(outerBranch);
                this.combBranchesInnerPortion.add(innerBranch);
                this.combBranchesOuterIndexes.add(o);
                this.combBranchesInnerIndexes.add((Integer)innerBranchIndexes.get(innerBranch));
                int count = this.combBranches.size();
                if (count % printMod == 0) {
                    String str = "\tBuilt " + countDF.format(count) + " branches";
                    if (pairwise) {
                        str = str + " (" + numPairDuplicates + " pairwise duplicates redrawn)";
                    }
                    System.out.println(str);
                }
                if (count < printMod * 10 || printMod >= 1000) continue;
                printMod *= 10;
            }
        }
        System.out.println("Built " + countDF.format(this.combBranches.size()) + " branches");
        Preconditions.checkState((!this.commonLevels.isEmpty() || this.combBranches.size() == this.expectedNum ? 1 : 0) != 0);
        this.combTree = LogicTree.fromExisting(this.combLevels, this.combBranches);
        this.combTree.setWeightProvider(new BranchWeightProvider.OriginalWeights());
        if (this.numPairwiseSamples > 0) {
            System.out.println("Pairwise tree with numPairwiseSamples=" + this.numPairwiseSamples + ", and " + numPairDuplicates + " duplicate pairs encountered");
            double sumWeight = 0.0;
            for (int i = 0; i < this.combTree.size(); ++i) {
                LogicTreeBranch<LogicTreeNode> branch = this.combTree.getBranch(i);
                LogicTreeBranch<?> outerBranch = this.combBranchesOuterPortion.get(i);
                int branchSamples = (Integer)branchSampleCounts.get(i);
                int outerTotSamples = (Integer)outerSampleCounts.get(outerBranch);
                double outerWeight = (Double)outerTotalWeights.get(outerBranch);
                double thisBranchFract = (double)branchSamples / (double)outerTotSamples;
                double weight = outerWeight * thisBranchFract;
                branch.setOrigBranchWeight(weight);
                sumWeight += weight;
            }
            HashMap<LogicTreeNode, Integer> sampledNodeCounts = new HashMap<LogicTreeNode, Integer>();
            HashMap<LogicTreeNode, Double> sampledNodeWeights = new HashMap<LogicTreeNode, Double>();
            for (LogicTreeBranch<LogicTreeNode> branch : this.combBranches) {
                double weight = branch.getOrigBranchWeight() / sumWeight;
                for (LogicTreeNode node : branch) {
                    int prevCount = 0;
                    double prevWeight = 0.0;
                    if (sampledNodeCounts.containsKey(node)) {
                        prevCount = (Integer)sampledNodeCounts.get(node);
                        prevWeight = (Double)sampledNodeWeights.get(node);
                    }
                    sampledNodeCounts.put(node, prevCount + 1);
                    sampledNodeWeights.put(node, prevWeight + weight);
                }
            }
            HashMap<LogicTreeNode, Integer> origCombNodeCounts = new HashMap<LogicTreeNode, Integer>();
            HashMap<LogicTreeNode, Double> origCombNodeWeights = new HashMap<LogicTreeNode, Double>();
            for (boolean inner : new boolean[]{false, true}) {
                HashMap origNodeCounts = new HashMap();
                HashMap origNodeWeights = new HashMap();
                double totWeight = 0.0;
                LogicTree<?> tree = inner ? this.innerTree : this.outerTree;
                Map<LogicTreeNode, LogicTreeNode> nodeRemaps = inner ? this.innerNodeRemaps : this.outerNodeRemaps;
                for (LogicTreeBranch<?> branch : tree) {
                    double weight = tree.getBranchWeight(branch);
                    totWeight += weight;
                    for (int l = 0; l < branch.size(); ++l) {
                        if (inner && this.commonLevels.contains(branch.getLevel(l))) continue;
                        Object node = branch.getValue(l);
                        if (nodeRemaps.containsKey(node)) {
                            node = nodeRemaps.get(node);
                        }
                        if (origNodeCounts.containsKey(node)) {
                            origNodeCounts.put(node, (Integer)origNodeCounts.get(node) + 1);
                            origNodeWeights.put(node, (Double)origNodeWeights.get(node) + weight);
                            continue;
                        }
                        origNodeCounts.put(node, 1);
                        origNodeWeights.put(node, weight);
                    }
                }
                for (LogicTreeNode node : origNodeCounts.keySet()) {
                    Preconditions.checkState((!origCombNodeCounts.containsKey(node) ? 1 : 0) != 0);
                    int count = (Integer)origNodeCounts.get(node);
                    double weight = (Double)origNodeWeights.get(node);
                    if (totWeight != 1.0) {
                        weight /= totWeight;
                    }
                    origCombNodeCounts.put(node, count);
                    origCombNodeWeights.put(node, weight);
                }
            }
            LogicTree.printSamplingStats(this.combLevels, sampledNodeCounts, sampledNodeWeights, origCombNodeCounts, origCombNodeWeights);
        }
        this.numSamples = pairwise ? this.combTree.size() : -1;
    }

    public void pairwiseSampleTree(int numSamples) {
        this.pairwiseSampleTree(numSamples, (long)this.expectedNum * (long)(numSamples == 0 ? this.outerTree.size() : numSamples));
    }

    public void pairwiseSampleTree(int numSamples, long randSeed) {
        this.pairwiseSampleTree(numSamples, 1, randSeed);
    }

    public void pairwiseSampleTree(int numOuterSamples, int numInnerPerOuter, long randSeed) {
        Preconditions.checkState((numInnerPerOuter > 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.combTree == null ? 1 : 0) != 0, (Object)"Can't pairwise-sample if tree is already built");
        Preconditions.checkState((this.numPairwiseSamples < 1 ? 1 : 0) != 0, (Object)"Can't pairwise-sample twice");
        this.pairwiseSampleRand = new Random(randSeed);
        if (numOuterSamples != 0 && numOuterSamples != this.outerTree.size()) {
            System.out.println("Pre-sampling outer tree to " + numOuterSamples + " samples for pairwise");
            boolean redrawDuplicates = numOuterSamples < (int)(0.95 * (double)this.outerTree.size());
            LogicTree<?> sampledOuterTree = this.outerTree.sample(numOuterSamples, redrawDuplicates, this.pairwiseSampleRand, false);
            Preconditions.checkState((sampledOuterTree.size() == numOuterSamples ? 1 : 0) != 0, (String)"Resampled outer tree from %s to %s, but asked for %s samples", (Object)this.outerTree.size(), (Object)sampledOuterTree.size(), (Object)numOuterSamples);
            this.outerTree = sampledOuterTree;
        }
        System.out.println("Pairwise-sampling inner tree with " + numInnerPerOuter + " samples per outer");
        this.numPairwiseSamples = numInnerPerOuter;
        this.expectedNum = this.outerTree.size() * numInnerPerOuter;
    }

    public void sampleTree(int maxNumCombinations) {
        this.sampleTree(maxNumCombinations, (long)this.expectedNum * (long)maxNumCombinations);
    }

    public void sampleTree(int maxNumCombinations, long randSeed) {
        if (this.combTree == null) {
            this.buildCominedTree();
        }
        System.out.println("Samping down to " + maxNumCombinations + " samples");
        HashMap<LogicTreeBranch<LogicTreeNode>, Integer> origIndexes = new HashMap<LogicTreeBranch<LogicTreeNode>, Integer>(this.combTree.size());
        for (int i = 0; i < this.combTree.size(); ++i) {
            origIndexes.put(this.combTree.getBranch(i), i);
        }
        this.combTree = this.combTree.sample(maxNumCombinations, true, new Random(randSeed));
        ArrayList<LogicTreeBranch<LogicTreeNode>> modCombBranches = new ArrayList<LogicTreeBranch<LogicTreeNode>>(maxNumCombinations);
        ArrayList<Integer> modCombBranchesOuterIndexes = new ArrayList<Integer>(maxNumCombinations);
        ArrayList modCombBranchesOuterPortion = new ArrayList(maxNumCombinations);
        ArrayList<Integer> modCombBranchesInnerIndexes = new ArrayList<Integer>(maxNumCombinations);
        ArrayList modCombBranchesInnerPortion = new ArrayList(maxNumCombinations);
        for (LogicTreeBranch<LogicTreeNode> logicTreeBranch : this.combTree) {
            int origIndex = (Integer)origIndexes.get(logicTreeBranch);
            modCombBranches.add(logicTreeBranch);
            modCombBranchesOuterIndexes.add(this.combBranchesOuterIndexes.get(origIndex));
            modCombBranchesOuterPortion.add(this.combBranchesOuterPortion.get(origIndex));
            modCombBranchesInnerIndexes.add(this.combBranchesInnerIndexes.get(origIndex));
            modCombBranchesInnerPortion.add(this.combBranchesInnerPortion.get(origIndex));
        }
        this.combBranches = modCombBranches;
        this.combBranchesOuterIndexes = modCombBranchesOuterIndexes;
        this.combBranchesOuterPortion = modCombBranchesOuterPortion;
        this.combBranchesInnerIndexes = modCombBranchesInnerIndexes;
        this.combBranchesInnerPortion = modCombBranchesInnerPortion;
        this.numPairwiseSamples = -1;
        this.numSamples = this.combTree.size();
    }

    public void addProcessor(LogicTreeCombinationProcessor processor) {
        this.processors.add(processor);
    }

    public void processCombinations() throws IOException {
        Preconditions.checkState((!this.processors.isEmpty() ? 1 : 0) != 0, (Object)"No processors supplied");
        if (this.combTree == null) {
            this.buildCominedTree();
        }
        int ioThreadCount = Integer.min(20, Integer.max(3, FaultSysTools.defaultNumThreads()));
        ExecutorService ioExec = ExecutorUtils.newNamedThreadPool(ioThreadCount, "ltCombinerIO");
        LogicTreeBranch<?> prevOuter = null;
        int numOutersProcessed = 0;
        ExecutorService exec = ExecutorUtils.newNamedThreadPool(FaultSysTools.defaultNumThreads(), "ltCombinerExec");
        Stopwatch watch = Stopwatch.createStarted();
        Stopwatch combineWatch = Stopwatch.createUnstarted();
        LogicTreeCombinationContext logicTreeContext = new LogicTreeCombinationContext(this.expectedNum, this.numSamples, this.numPairwiseSamples, this.combTree, this.outerTree, this.innerTree, this.outerLevelRemaps, this.outerNodeRemaps, this.innerLevelRemaps, this.innerNodeRemaps, this.combLevels, this.combBranches, this.combBranchesOuterIndexes, this.combBranchesOuterPortion, this.combBranchesInnerIndexes, this.combBranchesInnerPortion, this.commonLevels, this.commonSubtrees, this.averageAcrossLevels, this.origOuterTree, this.origInnerTree);
        ArrayList<CompletableFuture<Void>> processFutures = new ArrayList<CompletableFuture<Void>>(this.processors.size());
        ArrayList<Stopwatch> processWatches = new ArrayList<Stopwatch>(this.processors.size());
        for (LogicTreeCombinationProcessor processor : this.processors) {
            processor.init(logicTreeContext, exec, ioExec);
            processFutures.add(null);
            processWatches.add(Stopwatch.createUnstarted());
        }
        int combTreeSize = this.combTree.size();
        for (int n = 0; n < combTreeSize; ++n) {
            final LogicTreeBranch<LogicTreeNode> combBranch = this.combBranches.get(n);
            System.out.println("Processing branch " + n + "/" + combTreeSize + ": " + String.valueOf(combBranch));
            Preconditions.checkState((boolean)this.combBranches.get(n).equals(this.combTree.getBranch(n)));
            final double combWeight = combBranch.getOrigBranchWeight();
            final LogicTreeBranch<?> outerBranch = this.combBranchesOuterPortion.get(n);
            final LogicTreeBranch<?> innerBranch = this.combBranchesInnerPortion.get(n);
            final int outerIndex = this.combBranchesOuterIndexes.get(n);
            final int innerIndex = this.combBranchesInnerIndexes.get(n);
            System.out.println("\tOuter branch " + outerIndex + ": " + String.valueOf(outerBranch));
            System.out.println("\tInner branch " + innerIndex + ": " + String.valueOf(innerBranch));
            Preconditions.checkState((boolean)innerBranch.equals(this.innerTree.getBranch(innerIndex)), (String)"Inner branch for %s [%s] doesn't match outer branch at innerIndex=%s [%s]", (Object)n, innerBranch, (Object)innerIndex, this.innerTree.getBranch(innerIndex));
            Preconditions.checkState((boolean)outerBranch.equals(this.outerTree.getBranch(outerIndex)), (String)"Outer branch for %s [%s] doesn't match outer branch at outerIndex=%s [%s]", (Object)n, outerBranch, (Object)outerIndex, this.outerTree.getBranch(outerIndex));
            for (LogicTreeNode node : innerBranch) {
                if (this.innerNodeRemaps.containsKey(node)) {
                    node = this.innerNodeRemaps.get(node);
                }
                Preconditions.checkState((boolean)combBranch.hasValue(node), (String)"Inner branch has node %s which isn't on conbined branch: %s", (Object)node, combBranch);
            }
            for (LogicTreeNode node : outerBranch) {
                if (this.outerNodeRemaps.containsKey(node)) {
                    node = this.outerNodeRemaps.get(node);
                }
                Preconditions.checkState((boolean)combBranch.hasValue(node), (String)"Outer branch has node %s which isn't on conbined branch: %s", (Object)node, combBranch);
            }
            if (prevOuter == null || !outerBranch.equals(prevOuter)) {
                System.out.println("New outer branch: " + n + "/" + this.outerTree.size() + ": " + String.valueOf(outerBranch));
                if (n > 0) {
                    double fractDone = (double)n / (double)this.combTree.size();
                    System.out.println("DONE outer branch " + numOutersProcessed + "/" + this.outerTree.size() + ", " + n + "/" + this.combTree.size() + " total branches (" + pDF.format(fractDone) + ")");
                    this.printBlockingTimes(watch, combineWatch, processWatches);
                    double totSecs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                    double secsEach = totSecs / (double)n;
                    double expectedSecs = secsEach * (double)this.combTree.size();
                    double secsLeft = expectedSecs - totSecs;
                    double minsLeft = secsLeft / 60.0;
                    double hoursLeft = minsLeft / 60.0;
                    if (minsLeft > 90.0) {
                        System.out.println("\tEstimated time left: " + twoDigits.format(hoursLeft) + " hours");
                    } else if (secsLeft > 90.0) {
                        System.out.println("\tEstimated time left: " + twoDigits.format(minsLeft) + " mins");
                    } else {
                        System.out.println("\tEstimated time left: " + twoDigits.format(secsLeft) + " secs");
                    }
                    ++numOutersProcessed;
                }
            }
            final int combIndex = n;
            for (int p = 0; p < this.processors.size(); ++p) {
                CompletableFuture prevFuture = (CompletableFuture)processFutures.get(p);
                if (prevFuture != null) {
                    Stopwatch processWatch = (Stopwatch)processWatches.get(p);
                    processWatch.start();
                    combineWatch.start();
                    prevFuture.join();
                    combineWatch.stop();
                    processWatch.stop();
                }
                final LogicTreeCombinationProcessor processor = this.processors.get(p);
                processFutures.set(p, CompletableFuture.runAsync(new Runnable(){
                    final /* synthetic */ AbstractLogicTreeCombiner this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            processor.processBranch(combBranch, combIndex, combWeight, outerBranch, outerIndex, innerBranch, innerIndex);
                        }
                        catch (IOException e) {
                            throw ExceptionUtils.asRuntimeException((Throwable)e);
                        }
                    }
                }));
            }
            prevOuter = outerBranch;
        }
        for (int p = 0; p < this.processors.size(); ++p) {
            CompletableFuture prevFuture = (CompletableFuture)processFutures.get(p);
            if (prevFuture == null) continue;
            Stopwatch processWatch = (Stopwatch)processWatches.get(p);
            processWatch.start();
            combineWatch.start();
            prevFuture.join();
            combineWatch.stop();
            processWatch.stop();
        }
        exec.shutdown();
        ioExec.shutdown();
        watch.stop();
        double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        System.out.println("Wrote for " + this.combBranches.size() + " branches (" + (float)((double)this.combBranches.size() / secs) + " /s)");
        for (LogicTreeCombinationProcessor processor : this.processors) {
            System.out.println("Finalizing " + processor.getName());
            processor.close();
        }
        System.out.println("DONE");
        this.printBlockingTimes(watch, combineWatch, processWatches);
    }

    private void printBlockingTimes(Stopwatch watch, Stopwatch combineWatch, List<Stopwatch> processWatches) {
        System.out.println("\tTotal time combining:\t" + AbstractLogicTreeCombiner.blockingTimePrint(combineWatch, watch));
        for (int i = 0; i < this.processors.size(); ++i) {
            LogicTreeCombinationProcessor processor = this.processors.get(i);
            Stopwatch processorWatch = processWatches.get(i);
            Object processorTimeStr = processor.getTimeBreakdownString(watch);
            processorTimeStr = processorTimeStr != null && !((String)processorTimeStr).isBlank() ? ";\t" + (String)processorTimeStr : "";
            System.out.println("\t\t" + processor.getName() + ":\t" + AbstractLogicTreeCombiner.blockingTimePrint(processorWatch, watch) + (String)processorTimeStr);
        }
    }

    public static String blockingTimePrint(Stopwatch blockingWatch, Stopwatch totalWatch) {
        double blockSecs = (double)blockingWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        double blockMins = blockSecs / 60.0;
        String timeStr = blockMins > 1.0 ? twoDigits.format(blockMins) + " m" : twoDigits.format(blockSecs) + " s";
        double totSecs = (double)totalWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        return timeStr + " (" + pDF.format(blockSecs / totSecs) + ")";
    }

    static {
        countDF.setGroupingSize(3);
        countDF.setGroupingUsed(true);
    }

    public static class LogicTreeCombinationContext {
        public final int numPossibleCombinations;
        public final int numRandomSamples;
        public final int numPairwiseSamples;
        public final LogicTree<?> combTree;
        public final LogicTree<?> outerTree;
        public final LogicTree<?> innerTree;
        public final Map<LogicTreeLevel<?>, LogicTreeLevel<?>> outerLevelRemaps;
        public final Map<LogicTreeNode, LogicTreeNode> outerNodeRemaps;
        public final Map<LogicTreeLevel<?>, LogicTreeLevel<?>> innerLevelRemaps;
        public final Map<LogicTreeNode, LogicTreeNode> innerNodeRemaps;
        public final List<LogicTreeLevel<? extends LogicTreeNode>> combLevels;
        public final List<LogicTreeBranch<LogicTreeNode>> combBranches;
        public final List<Integer> combBranchesOuterIndexes;
        public final List<LogicTreeBranch<?>> combBranchesOuterPortion;
        public final List<Integer> combBranchesInnerIndexes;
        public final List<LogicTreeBranch<?>> combBranchesInnerPortion;
        public final List<LogicTreeLevel<? extends LogicTreeNode>> commonLevels;
        public final Map<LogicTreeBranch<LogicTreeNode>, LogicTree<?>> commonSubtrees;
        public final List<LogicTreeLevel<? extends LogicTreeNode>> averageAcrossLevels;
        public final LogicTree<?> preAveragingOuterTree;
        public final LogicTree<?> preAveragingInnerTree;

        private LogicTreeCombinationContext(int numPossibleCombinations, int numRandomSamples, int numPairwiseSamples, LogicTree<?> combinedTree, LogicTree<?> outerTree, LogicTree<?> innerTree, Map<LogicTreeLevel<?>, LogicTreeLevel<?>> outerLevelRemaps, Map<LogicTreeNode, LogicTreeNode> outerNodeRemaps, Map<LogicTreeLevel<?>, LogicTreeLevel<?>> innerLevelRemaps, Map<LogicTreeNode, LogicTreeNode> innerNodeRemaps, List<LogicTreeLevel<? extends LogicTreeNode>> combLevels, List<LogicTreeBranch<LogicTreeNode>> combBranches, List<Integer> combBranchesOuterIndexes, List<LogicTreeBranch<?>> combBranchesOuterPortion, List<Integer> combBranchesInnerIndexes, List<LogicTreeBranch<?>> combBranchesInnerPortion, List<LogicTreeLevel<? extends LogicTreeNode>> commonLevels, Map<LogicTreeBranch<LogicTreeNode>, LogicTree<?>> commonSubtrees, List<LogicTreeLevel<? extends LogicTreeNode>> averageAcrossLevels, LogicTree<?> preAveragingOuterTree, LogicTree<?> preAveragingInnerTree) {
            this.numPossibleCombinations = numPossibleCombinations;
            this.numRandomSamples = numRandomSamples;
            this.numPairwiseSamples = numPairwiseSamples;
            this.combTree = combinedTree;
            this.outerTree = outerTree;
            this.innerTree = innerTree;
            this.outerLevelRemaps = outerLevelRemaps;
            this.outerNodeRemaps = outerNodeRemaps;
            this.innerLevelRemaps = innerLevelRemaps;
            this.innerNodeRemaps = innerNodeRemaps;
            this.combLevels = combLevels;
            this.combBranches = combBranches;
            this.combBranchesOuterIndexes = combBranchesOuterIndexes;
            this.combBranchesOuterPortion = combBranchesOuterPortion;
            this.combBranchesInnerIndexes = combBranchesInnerIndexes;
            this.combBranchesInnerPortion = combBranchesInnerPortion;
            this.commonLevels = commonLevels;
            this.commonSubtrees = commonSubtrees;
            this.averageAcrossLevels = averageAcrossLevels;
            this.preAveragingOuterTree = preAveragingOuterTree;
            this.preAveragingInnerTree = preAveragingInnerTree;
        }
    }
}

