/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.mapping.gmt.raster.RasterExtractor;
import org.opensha.commons.util.FileUtils;

public class GMT_KML_Generator {
    String psFile;
    double minLat;
    double minLon;
    double maxLat;
    double maxLon;

    public GMT_KML_Generator(String psFile, double minLat, double maxLat, double minLon, double maxLon) {
        this.psFile = psFile;
        this.minLat = minLat;
        this.minLon = minLon;
        this.maxLat = maxLat;
        this.maxLon = maxLon;
    }

    private void extract(String pngFile) throws FileNotFoundException, IOException {
        RasterExtractor raster = new RasterExtractor(this.psFile, pngFile);
        raster.writePNG();
    }

    private void writeKML(String kmlFileName, String imgFile) throws IOException {
        FileWriter fw = new FileWriter(kmlFileName);
        fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        fw.write("<kml xmlns=\"http://earth.google.com/kml/2.2\">\n");
        fw.write("  <Folder>\n");
        fw.write("    <name>OpenSHA Hazard Maps</name>\n");
        fw.write("    <description>Open Seismic Hazard Analysis</description>\n");
        fw.write("    <GroundOverlay>\n");
        fw.write("      <name>Hazard Map</name>\n");
        fw.write("      <description></description>\n");
        fw.write("      <Icon>\n");
        fw.write("        <href>" + imgFile + "</href>\n");
        fw.write("      </Icon>\n");
        fw.write("      <LatLonBox>\n");
        fw.write("        <north>" + this.maxLat + "</north>\n");
        fw.write("        <south>" + this.minLat + "</south>\n");
        fw.write("        <east>" + this.maxLon + "</east>\n");
        fw.write("        <west>" + this.minLon + "</west>\n");
        fw.write("        <rotation>0</rotation>\n");
        fw.write("      </LatLonBox>\n");
        fw.write("    </GroundOverlay>\n");
        fw.write("  </Folder>\n");
        fw.write("</kml>\n");
        fw.write("\n");
        fw.flush();
        fw.close();
    }

    public void makeKMZ(String kmzFileName) throws FileNotFoundException, IOException {
        File tempDir = FileUtils.createTempDir();
        ArrayList<String> zipFiles = new ArrayList<String>();
        String pngFileName = "map.png";
        String absPNGFileName = tempDir.getAbsolutePath() + File.separator + pngFileName;
        if (this.psFile.toLowerCase().endsWith(".png")) {
            Files.copy(new File(this.psFile).toPath(), new File(absPNGFileName).toPath(), new CopyOption[0]);
        } else {
            this.extract(absPNGFileName);
        }
        zipFiles.add(pngFileName);
        String kmlFileName = "map.kml";
        String absKMLFileName = tempDir.getAbsolutePath() + File.separator + kmlFileName;
        this.writeKML(absKMLFileName, pngFileName);
        zipFiles.add(kmlFileName);
        FileUtils.createZipFile(kmzFileName, tempDir.getAbsolutePath(), zipFiles);
        FileUtils.deleteRecursive(tempDir);
    }

    public static double[] decodeGMTRegion(String reg) {
        String newReg = reg.substring(2);
        StringTokenizer tok = new StringTokenizer(newReg, "/");
        if (tok.countTokens() != 4) {
            throw new RuntimeException("Invalid region string: " + reg);
        }
        double[] bounds = new double[]{Double.parseDouble(tok.nextToken()), Double.parseDouble(tok.nextToken()), Double.parseDouble(tok.nextToken()), Double.parseDouble(tok.nextToken())};
        return bounds;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String psFile = null;
        String kmzFile = null;
        double minLat = 0.0;
        double maxLat = 0.0;
        double minLon = 0.0;
        double maxLon = 0.0;
        if (args.length == 6) {
            psFile = args[0];
            kmzFile = args[1];
            minLat = Double.parseDouble(args[2]);
            maxLat = Double.parseDouble(args[3]);
            minLon = Double.parseDouble(args[4]);
            maxLon = Double.parseDouble(args[5]);
        } else if (args.length == 3 && args[2].startsWith("-R")) {
            psFile = args[0];
            kmzFile = args[1];
            double[] bounds = GMT_KML_Generator.decodeGMTRegion(args[2]);
            minLon = bounds[0];
            maxLon = bounds[1];
            minLat = bounds[2];
            maxLat = bounds[3];
        } else {
            System.err.println("USAGE: GMT_KML_Generator ps/png_file kmz_file minLat maxLat minLon maxLon");
            System.err.println("\t-- OR --");
            System.err.println("USAGE: GMT_KML_Generator ps/png_file kmz_file -R<minLon>/<maxLon>/<minLat>/<maxLat>");
            System.exit(2);
        }
        GMT_KML_Generator gen = new GMT_KML_Generator(psFile, minLat, maxLat, minLon, maxLon);
        gen.makeKMZ(kmzFile);
        System.exit(0);
    }
}

