/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.mapping.gmt.GMT_KML_Generator;
import org.opensha.commons.mapping.gmt.GMT_Map;
import org.opensha.commons.mapping.gmt.SecureMapGenerator;
import org.opensha.commons.mapping.gmt.elements.CoastAttributes;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.mapping.gmt.elements.PSText;
import org.opensha.commons.mapping.gmt.elements.PSXYPolygon;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbol;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbolSet;
import org.opensha.commons.mapping.gmt.elements.TopographicSlopeFile;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.CPTParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ListUtils;
import org.opensha.commons.util.RunScript;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.cybershake.maps.GMT_InterpolationSettings;

public class GMT_MapGenerator
implements SecureMapGenerator,
Serializable {
    protected static final String C = "GMT_MapGenerator";
    protected static final boolean D = false;
    protected static final String DEFAULT_GMT_SCRIPT_NAME = "map_GMT_Script.txt";
    protected String GMT_SCRIPT_NAME = "map_GMT_Script.txt";
    protected static final String DEFAULT_XYZ_FILE_NAME = "map_data.txt";
    protected String XYZ_FILE_NAME = "map_data.txt";
    protected static final String DEFAULT_METADATA_FILE_NAME = "map_info.html";
    protected String METADATA_FILE_NAME = "map_info.html";
    protected static final String DEFAULT_PS_FILE_NAME = "map.ps";
    protected String PS_FILE_NAME = "map.ps";
    public static final String DEFAULT_JPG_FILE_NAME = "map.jpg";
    protected String JPG_FILE_NAME = "map.jpg";
    public static final String DEFAULT_PNG_FILE_NAME = "map.png";
    protected String PNG_FILE_NAME = "map.png";
    protected static final String DEFAULT_PDF_FILE_NAME = "map.pdf";
    protected String PDF_FILE_NAME = "map.pdf";
    protected String SCALE_LABEL;
    public static final String OPENSHA_GMT_PATH = "/usr/bin/gmt ";
    public static final String OPENSHA_GS_PATH = "/usr/bin/gs";
    public static final String OPENSHA_PS2PDF_PATH = "/usr/bin/ps2pdf";
    public static final String OPENSHA_CONVERT_PATH = "/usr/bin/convert";
    public static final String OPENSHA_GMT_DATA_PATH = ServerPrefUtils.SERVER_PREFS.getDataDir().getAbsolutePath() + File.separator + "gmt" + File.separator;
    public static final String OPENSHA_SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "GMT_MapGeneratorServlet";
    public static final String OPENSHA_JAVA_PATH = "/usr/bin/java";
    public static final String OPENSHA_CLASSPATH = ServerPrefUtils.SERVER_PREFS.getTomcatDir().getAbsolutePath() + File.separator + "lib" + File.separator + "opensha-dev-all.jar";
    public static final String OPENSHA_NETCDF_LIB_PATH = null;
    public static String GMT_DATA_PATH = OPENSHA_GMT_DATA_PATH;
    private static String SERVLET_URL = OPENSHA_SERVLET_URL;
    public static String JAVA_PATH = "/usr/bin/java";
    public static String JAVA_CLASSPATH = OPENSHA_CLASSPATH;
    protected static String GMT_PATH = "/usr/bin/gmt ";
    protected static String GS_PATH = "/usr/bin/gs";
    protected static String CONVERT_PATH = "/usr/bin/convert";
    protected static String PS2PDF_PATH = "/usr/bin/ps2pdf";
    protected static String NETCDF_LIB_PATH = OPENSHA_NETCDF_LIB_PATH;
    protected static String COMMAND_PATH = "/bin/";
    protected GeoDataSet xyzDataSet;
    public static final String MIN_LAT_PARAM_NAME = "Min Latitude";
    public static final String MAX_LAT_PARAM_NAME = "Max Latitude";
    public static final String MIN_LON_PARAM_NAME = "Min Longitude";
    public static final String MAX_LON_PARAM_NAME = "Max Longitude";
    public static final String GRID_SPACING_PARAM_NAME = "Grid Spacing";
    private static final String LAT_LON_PARAM_UNITS = "Degrees";
    private static final String LAT_LON_PARAM_INFO = "Corner point of mapped region";
    private static final String GRID_SPACING_PARAM_INFO = "Grid interval in the Region";
    private static final Double MIN_LAT_PARAM_DEFAULT = 20.0;
    private static final Double MAX_LAT_PARAM_DEFAULT = 60.0;
    private static final Double MIN_LON_PARAM_DEFAULT = -130.0;
    private static final Double MAX_LON_PARAM_DEFAULT = -60.0;
    private static final Double GRID_SPACING_PARAM_DEFAULT = 0.1;
    DoubleParameter minLatParam = new DoubleParameter("Min Latitude", -90.0, 90.0, "Degrees", MIN_LAT_PARAM_DEFAULT);
    DoubleParameter maxLatParam;
    DoubleParameter minLonParam;
    DoubleParameter maxLonParam;
    DoubleParameter gridSpacingParam;
    public static final String IMAGE_WIDTH_NAME = "Image Width";
    private static final String IMAGE_WIDTH_UNITS = "inches";
    private static final String IMAGE_WIDTH_INFO = "Width of the final jpg image (ps file width is always 8.5 inches)";
    private static final double IMAGE_WIDTH_MIN = 1.0;
    private static final double IMAGE_WIDTH_MAX = 20.0;
    protected static final Double IMAGE_WIDTH_DEFAULT = 6.5;
    DoubleParameter imageWidthParam;
    public static final String CPT_PARAM_NAME = "Color Scheme";
    protected static final GMT_CPT_Files CPT_PARAM_DEFAULT = GMT_CPT_Files.MAX_SPECTRUM;
    private static final String CPT_PARAM_INFO = "Color scheme for the scale";
    private CPTParameter cptParam;
    public static final String COAST_PARAM_NAME = "Coast";
    public static final String COAST_DRAW = "Draw Boundary";
    public static final String COAST_FILL = "Draw & Fill";
    public static final String COAST_NONE = "Draw Nothing";
    protected static final String COAST_DEFAULT = "Draw & Fill";
    private static final String COAST_PARAM_INFO = "Specifies how bodies of water are drawn";
    StringParameter coastParam;
    public static final String COLOR_SCALE_MODE_NAME = "Color Scale Limits";
    public static final String COLOR_SCALE_MODE_INFO = "Set manually or from max/min of the data";
    public static final String COLOR_SCALE_MODE_MANUALLY = "Manually";
    public static final String COLOR_SCALE_MODE_FROMDATA = "From Data";
    public static final String COLOR_SCALE_MODE_DEFAULT = "From Data";
    StringParameter colorScaleModeParam;
    public static final String COLOR_SCALE_MIN_PARAM_NAME = "Color-Scale Min";
    private static final Double COLOR_SCALE_MIN_PARAM_DEFAULT = -2.0;
    private static final String COLOR_SCALE_MIN_PARAM_INFO = "Lower limit on color scale (values below are the same color)";
    public static final String COLOR_SCALE_MAX_PARAM_NAME = "Color-Scale Max";
    private static final Double COLOR_SCALE_MAX_PARAM_DEFAULT = -0.5;
    private static final String COLOR_SCALE_MAX_PARAM_INFO = "Upper limit on color scale (values above are the same color)";
    DoubleParameter colorScaleMaxParam;
    DoubleParameter colorScaleMinParam;
    public static final String DPI_PARAM_NAME = "DPI";
    private static final String DPI_PARAM_INFO = "Dots per inch for PS file";
    protected static final Integer DPI_DEFAULT = 72;
    private static final Integer DPI_MIN = 0;
    private static final Integer DPI_MAX = Integer.MAX_VALUE;
    private IntegerParameter dpiParam;
    public static final String GMT_SMOOTHING_PARAM_NAME = "Apply GMT Smoothing?";
    private static final String GMT_SMOOTHING_PARAM_INFO = "Apply GMT Smoothing (if false, Topo Resolution is set to none)?";
    protected static final boolean GMT_SMOOTHING_DEFAULT = true;
    private BooleanParameter gmtSmoothingParam;
    public static final String GRD_VIEW_PARAM_NAME = "Use grdview instead of grdimage?";
    private static final String GRD_VIEW_PARAM_INFO = "Uses the grdview command instead of grdimage when smoothing and topography are disabled. This is slower, but looks better for extremely high resolution maps.";
    protected static final boolean GRD_VIEW_DEFAULT = false;
    private BooleanParameter grdViewParam;
    public static final String BLACK_BACKGROUND_PARAM_NAME = "Apply Black Background?";
    private static final String BLACK_BACKGROUND_PARAM_INFO = "Otherwise background will be white";
    protected static final boolean BLACK_BACKGROUND_PARAM_DEFAULT = true;
    private BooleanParameter blackBackgroundParam;
    public static final String TOPO_RESOLUTION_PARAM_NAME = "Topo Resolution";
    private static final String TOPO_RESOLUTION_PARAM_UNITS = "arc-sec";
    private static final String TOPO_RESOLUTION_PARAM_INFO = "Resolution of the shaded relief";
    public static final String TOPO_RESOLUTION_03_CA = "03 sec California";
    public static final String TOPO_RESOLUTION_06_US = "06 sec US";
    public static final String TOPO_RESOLUTION_18_US = "18 sec US";
    public static final String TOPO_RESOLUTION_30_US = "30 sec US";
    public static final String TOPO_RESOLUTION_30_GLOBAL = "30 sec Global";
    protected static final String TOPO_RESOLUTION_PARAM_DEFAULT = "30 sec Global";
    public static final String TOPO_RESOLUTION_NONE = "No Topo";
    StringParameter topoResolutionParam;
    public static final String SHOW_HIWYS_PARAM_NAME = "Highways in plot";
    public static final String SHOW_HIWYS_PARAM_DEFAULT = "None";
    public static final String SHOW_HIWYS_PARAM_INFO = "Select the highways you'd like to be shown";
    public static final String SHOW_HIWYS_ALL = "ca_hiwys.all.xy";
    public static final String SHOW_HIWYS_MAIN = "ca_hiwys.main.xy";
    public static final String SHOW_HIWYS_OTHER = "ca_hiwys.other.xy";
    public static final String SHOW_HIWYS_NONE = "None";
    StringParameter showHiwysParam;
    public static final String GMT_WEBSERVICE_NAME = "Use GMT WebService";
    private static final String GMT_WEBSERVICE_INFO = "Use server-mode GMT (rather than on this computer)";
    BooleanParameter gmtFromServer;
    public static final String LOG_PLOT_NAME = "Plot Log";
    private static final String LOG_PLOT_INFO = "Plot Log or Linear Map";
    protected static final boolean LOG_PLOT_PARAM_DEFAULT = true;
    protected BooleanParameter logPlotParam;
    public static final String CUSTOM_SCALE_LABEL_PARAM_CHECK_NAME = "Custom Scale Label";
    private static final String CUSTOM_SCALE_LABEL_PARAM_CHECK_INFO = "Allows to give a custom scale label to the map";
    protected BooleanParameter customScaleLabelCheckParam;
    public static final String SCALE_LABEL_PARAM_NAME = "Scale Label";
    private static final String SCALE_LABEL_PARAM_INFO = "Map Scale Label(Don't give any brackets in label)";
    protected StringParameter scaleLabelParam;
    public static final String KML_PARAM_NAME = "Generate KML Files";
    private static final Boolean KML_PARAM_DEFAULT = false;
    private BooleanParameter kmlParam;
    protected ParameterList adjustableParams;
    protected String imgWebAddr = null;
    private static final double max_height_in = 7.625;

    public GMT_MapGenerator() {
        this.minLatParam.setInfo(LAT_LON_PARAM_INFO);
        this.maxLatParam = new DoubleParameter(MAX_LAT_PARAM_NAME, -90.0, 90.0, LAT_LON_PARAM_UNITS, MAX_LAT_PARAM_DEFAULT);
        this.minLatParam.setInfo(LAT_LON_PARAM_INFO);
        this.minLonParam = new DoubleParameter(MIN_LON_PARAM_NAME, -360.0, 360.0, LAT_LON_PARAM_UNITS, MIN_LON_PARAM_DEFAULT);
        this.minLatParam.setInfo(LAT_LON_PARAM_INFO);
        this.maxLonParam = new DoubleParameter(MAX_LON_PARAM_NAME, -360.0, 360.0, LAT_LON_PARAM_UNITS, MAX_LON_PARAM_DEFAULT);
        this.minLatParam.setInfo(LAT_LON_PARAM_INFO);
        this.gridSpacingParam = new DoubleParameter(GRID_SPACING_PARAM_NAME, 0.001, 100.0, LAT_LON_PARAM_UNITS, GRID_SPACING_PARAM_DEFAULT);
        this.minLatParam.setInfo(GRID_SPACING_PARAM_INFO);
        this.imageWidthParam = new DoubleParameter(IMAGE_WIDTH_NAME, 1.0, 20.0, IMAGE_WIDTH_UNITS, IMAGE_WIDTH_DEFAULT);
        this.imageWidthParam.setInfo(IMAGE_WIDTH_INFO);
        ArrayList<CPT> cpts = null;
        try {
            cpts = GMT_CPT_Files.instances();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cptParam = new CPTParameter(CPT_PARAM_NAME, cpts, cpts.get(ListUtils.getIndexByName(cpts, CPT_PARAM_DEFAULT.getFileName())));
        this.cptParam.setInfo(CPT_PARAM_INFO);
        StringConstraint coastConstraint = new StringConstraint();
        coastConstraint.addString("Draw & Fill");
        coastConstraint.addString(COAST_DRAW);
        coastConstraint.addString(COAST_NONE);
        this.coastParam = new StringParameter(COAST_PARAM_NAME, coastConstraint, "Draw & Fill");
        this.coastParam.setInfo(COAST_PARAM_INFO);
        StringConstraint colorScaleModeConstraint = new StringConstraint();
        colorScaleModeConstraint.addString("From Data");
        colorScaleModeConstraint.addString(COLOR_SCALE_MODE_MANUALLY);
        this.colorScaleModeParam = new StringParameter(COLOR_SCALE_MODE_NAME, colorScaleModeConstraint, "From Data");
        this.colorScaleModeParam.setInfo(COLOR_SCALE_MODE_INFO);
        this.colorScaleMinParam = new DoubleParameter(COLOR_SCALE_MIN_PARAM_NAME, COLOR_SCALE_MIN_PARAM_DEFAULT);
        this.colorScaleMinParam.setInfo(COLOR_SCALE_MIN_PARAM_INFO);
        this.colorScaleMaxParam = new DoubleParameter(COLOR_SCALE_MAX_PARAM_NAME, COLOR_SCALE_MAX_PARAM_DEFAULT);
        this.colorScaleMaxParam.setInfo(COLOR_SCALE_MAX_PARAM_INFO);
        StringConstraint topoResolutionConstraint = new StringConstraint();
        topoResolutionConstraint.addString("30 sec Global");
        topoResolutionConstraint.addString(TOPO_RESOLUTION_30_US);
        topoResolutionConstraint.addString(TOPO_RESOLUTION_18_US);
        topoResolutionConstraint.addString(TOPO_RESOLUTION_06_US);
        topoResolutionConstraint.addString(TOPO_RESOLUTION_03_CA);
        topoResolutionConstraint.addString(TOPO_RESOLUTION_NONE);
        this.topoResolutionParam = new StringParameter(TOPO_RESOLUTION_PARAM_NAME, topoResolutionConstraint, TOPO_RESOLUTION_PARAM_UNITS, "30 sec Global");
        this.topoResolutionParam.setInfo(TOPO_RESOLUTION_PARAM_INFO);
        StringConstraint showHiwysConstraint = new StringConstraint();
        showHiwysConstraint.addString("None");
        showHiwysConstraint.addString(SHOW_HIWYS_ALL);
        showHiwysConstraint.addString(SHOW_HIWYS_MAIN);
        showHiwysConstraint.addString(SHOW_HIWYS_OTHER);
        this.showHiwysParam = new StringParameter(SHOW_HIWYS_PARAM_NAME, showHiwysConstraint, "None");
        this.showHiwysParam.setInfo(SHOW_HIWYS_PARAM_INFO);
        this.gmtFromServer = new BooleanParameter(GMT_WEBSERVICE_NAME, Boolean.valueOf("true"));
        this.gmtFromServer.setInfo(GMT_WEBSERVICE_INFO);
        this.logPlotParam = new BooleanParameter(LOG_PLOT_NAME, true);
        this.logPlotParam.setInfo(LOG_PLOT_INFO);
        this.customScaleLabelCheckParam = new BooleanParameter(CUSTOM_SCALE_LABEL_PARAM_CHECK_NAME, false);
        this.customScaleLabelCheckParam.setInfo(CUSTOM_SCALE_LABEL_PARAM_CHECK_INFO);
        this.scaleLabelParam = new StringParameter(SCALE_LABEL_PARAM_NAME, "");
        this.scaleLabelParam.setInfo(SCALE_LABEL_PARAM_INFO);
        this.dpiParam = new IntegerParameter(DPI_PARAM_NAME, DPI_MIN, DPI_MAX, DPI_DEFAULT);
        this.dpiParam.setInfo(DPI_PARAM_INFO);
        this.gmtSmoothingParam = new BooleanParameter(GMT_SMOOTHING_PARAM_NAME, true);
        this.gmtSmoothingParam.setInfo(GMT_SMOOTHING_PARAM_INFO);
        this.grdViewParam = new BooleanParameter(GRD_VIEW_PARAM_NAME, false);
        this.grdViewParam.setInfo(GRD_VIEW_PARAM_INFO);
        this.blackBackgroundParam = new BooleanParameter(BLACK_BACKGROUND_PARAM_NAME, true);
        this.blackBackgroundParam.setInfo(BLACK_BACKGROUND_PARAM_INFO);
        this.kmlParam = new BooleanParameter(KML_PARAM_NAME, KML_PARAM_DEFAULT);
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.minLatParam);
        this.adjustableParams.addParameter(this.maxLatParam);
        this.adjustableParams.addParameter(this.minLonParam);
        this.adjustableParams.addParameter(this.maxLonParam);
        this.adjustableParams.addParameter(this.gridSpacingParam);
        this.adjustableParams.addParameter(this.cptParam);
        this.adjustableParams.addParameter(this.colorScaleModeParam);
        this.adjustableParams.addParameter(this.colorScaleMinParam);
        this.adjustableParams.addParameter(this.colorScaleMaxParam);
        this.adjustableParams.addParameter(this.topoResolutionParam);
        this.adjustableParams.addParameter(this.showHiwysParam);
        this.adjustableParams.addParameter(this.coastParam);
        this.adjustableParams.addParameter(this.imageWidthParam);
        this.adjustableParams.addParameter(this.customScaleLabelCheckParam);
        this.adjustableParams.addParameter(this.scaleLabelParam);
        this.adjustableParams.addParameter(this.gmtSmoothingParam);
        this.adjustableParams.addParameter(this.blackBackgroundParam);
        this.adjustableParams.addParameter(this.dpiParam);
        this.adjustableParams.addParameter(this.gmtFromServer);
        this.adjustableParams.addParameter(this.logPlotParam);
        this.adjustableParams.addParameter(this.kmlParam);
        this.adjustableParams.addParameter(this.grdViewParam);
    }

    public String makeMapLocally(GeoDataSet xyzDataSet, String scaleLabel, String metadata, String dirName) throws GMT_MapException {
        boolean needswork = true;
        if (needswork) {
            throw new RuntimeException("This method needs work");
        }
        File file = new File(dirName);
        file.mkdirs();
        GMT_PATH = "/opt/homebrew/bin/gmt ";
        GS_PATH = "/opt/homebrew/bin/gs";
        PS2PDF_PATH = "/opt/homebrew/bin/ps2pdf";
        CONVERT_PATH = "/opt/homebrew/bin/convert";
        GMT_DATA_PATH = "/usr/scec/data/gmt/";
        this.GMT_SCRIPT_NAME = dirName + "/map_GMT_Script.txt";
        this.XYZ_FILE_NAME = dirName + "/map_data.txt";
        this.METADATA_FILE_NAME = dirName + "/map_info.html";
        this.PS_FILE_NAME = dirName + "/map.ps";
        this.JPG_FILE_NAME = dirName + "/map.jpg";
        this.PNG_FILE_NAME = dirName + "/map.png";
        this.PDF_FILE_NAME = dirName + "/map.pdf";
        this.createMapInfoFile(metadata);
        this.SCALE_LABEL = scaleLabel;
        this.xyzDataSet = xyzDataSet;
        this.checkForLogPlot();
        try {
            ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)xyzDataSet, this.XYZ_FILE_NAME);
        }
        catch (IOException e) {
            throw new GMT_MapException(e);
        }
        ArrayList gmtLines = this.getGMT_ScriptLines();
        this.makeFileFromLines(gmtLines, this.GMT_SCRIPT_NAME);
        String[] command = new String[]{"sh", "-c", "sh " + this.GMT_SCRIPT_NAME};
        RunScript.runScript(command);
        return this.JPG_FILE_NAME;
    }

    public GMT_Map getGMTMapSpecification(GeoDataSet xyzData) {
        Region region = new Region(new Location((Double)this.minLatParam.getValue(), (Double)this.minLonParam.getValue()), new Location((Double)this.maxLatParam.getValue(), (Double)this.maxLonParam.getValue()));
        GMT_Map map = new GMT_Map(region, xyzData, (double)((Double)this.gridSpacingParam.getValue()), (CPT)this.cptParam.getValue());
        map.setXyzFileName(this.XYZ_FILE_NAME);
        map.setPSFileName(this.PS_FILE_NAME);
        map.setPDFFileName(this.PDF_FILE_NAME);
        map.setPNGFileName(this.PNG_FILE_NAME);
        map.setJPGFileName(this.JPG_FILE_NAME);
        CoastAttributes coast = null;
        if (((String)this.coastParam.getValue()).equals(COAST_DRAW)) {
            coast = new CoastAttributes(Color.GRAY, 1.0);
        } else if (((String)this.coastParam.getValue()).equals("Draw & Fill")) {
            coast = new CoastAttributes();
        }
        map.setCoast(coast);
        if (((Boolean)this.customScaleLabelCheckParam.getValue()).booleanValue()) {
            map.setCustomLabel((String)this.scaleLabelParam.getValue());
        } else {
            map.setCustomLabel(null);
        }
        if (((String)this.colorScaleModeParam.getValue()).equals(COLOR_SCALE_MODE_MANUALLY)) {
            map.setCustomScaleMin((Double)this.colorScaleMinParam.getValue());
            map.setCustomScaleMax((Double)this.colorScaleMaxParam.getValue());
        } else {
            map.setCustomScaleMin(null);
            map.setCustomScaleMax(null);
        }
        map.setDpi((Integer)this.dpiParam.getValue());
        if (((String)this.showHiwysParam.getValue()).equals(SHOW_HIWYS_ALL)) {
            map.setHighwayFile(GMT_Map.HighwayFile.ALL);
        } else if (((String)this.showHiwysParam.getValue()).equals(SHOW_HIWYS_MAIN)) {
            map.setHighwayFile(GMT_Map.HighwayFile.MAIN);
        } else if (((String)this.showHiwysParam.getValue()).equals(SHOW_HIWYS_OTHER)) {
            map.setHighwayFile(GMT_Map.HighwayFile.OTHER);
        } else {
            map.setHighwayFile(null);
        }
        map.setImageWidth((Double)this.imageWidthParam.getValue());
        map.setLogPlot((Boolean)this.logPlotParam.getValue());
        map.setRescaleCPT(true);
        if (((String)this.topoResolutionParam.getValue()).equals(TOPO_RESOLUTION_03_CA)) {
            map.setTopoResolution(TopographicSlopeFile.CA_THREE);
        } else if (((String)this.topoResolutionParam.getValue()).equals(TOPO_RESOLUTION_06_US)) {
            map.setTopoResolution(TopographicSlopeFile.US_SIX);
        } else if (((String)this.topoResolutionParam.getValue()).equals(TOPO_RESOLUTION_18_US)) {
            map.setTopoResolution(TopographicSlopeFile.US_EIGHTEEN);
        } else if (((String)this.topoResolutionParam.getValue()).equals(TOPO_RESOLUTION_30_US)) {
            map.setTopoResolution(TopographicSlopeFile.US_THIRTY);
        } else if (((String)this.topoResolutionParam.getValue()).equals("30 sec Global")) {
            map.setTopoResolution(TopographicSlopeFile.SRTM_30_PLUS);
        } else {
            map.setTopoResolution(null);
        }
        map.setUseGMTSmoothing((Boolean)this.gmtSmoothingParam.getValue());
        map.setUseGRDView((Boolean)this.grdViewParam.getValue());
        map.setBlackBackground((Boolean)this.blackBackgroundParam.getValue());
        map.setGenerateKML((Boolean)this.kmlParam.getValue());
        return map;
    }

    public String makeMapUsingServlet(GeoDataSet xyzDataSet, String scaleLabel, String metadata, String dirName) throws GMT_MapException, RuntimeException {
        GMT_Map map = this.getGMTMapSpecification(xyzDataSet);
        if (scaleLabel != null && scaleLabel.length() > 0 && !scaleLabel.equals(" ")) {
            map.setCustomLabel(scaleLabel);
        }
        return this.makeMapUsingServlet(map, metadata, dirName);
    }

    public String makeMapUsingServlet(GMT_Map map, String metadata, String dirName) throws GMT_MapException, RuntimeException {
        GMT_PATH = OPENSHA_GMT_PATH;
        GS_PATH = OPENSHA_GS_PATH;
        PS2PDF_PATH = OPENSHA_PS2PDF_PATH;
        CONVERT_PATH = OPENSHA_CONVERT_PATH;
        this.xyzDataSet = map.getGriddedData();
        this.checkForLogPlot();
        this.imgWebAddr = this.openServletConnection(map, metadata, dirName);
        if (!this.imgWebAddr.endsWith("/")) {
            this.imgWebAddr = this.imgWebAddr + "/";
        }
        return this.imgWebAddr + this.PNG_FILE_NAME;
    }

    public String makeMapUsingWebServer(GeoDataSet xyzDataSet, String scaleLabel, String metadata) throws GMT_MapException {
        this.createMapInfoFile(metadata);
        GMT_PATH = OPENSHA_GMT_PATH;
        GS_PATH = OPENSHA_GS_PATH;
        PS2PDF_PATH = OPENSHA_PS2PDF_PATH;
        CONVERT_PATH = OPENSHA_CONVERT_PATH;
        this.SCALE_LABEL = scaleLabel;
        this.xyzDataSet = xyzDataSet;
        this.checkForLogPlot();
        try {
            ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)xyzDataSet, this.XYZ_FILE_NAME);
        }
        catch (IOException e) {
            throw new GMT_MapException(e);
        }
        ArrayList gmtLines = this.getGMT_ScriptLines();
        this.makeFileFromLines(gmtLines, this.GMT_SCRIPT_NAME);
        String[] fileNames = new String[]{this.GMT_SCRIPT_NAME, this.XYZ_FILE_NAME, this.METADATA_FILE_NAME};
        return this.imgWebAddr + this.PNG_FILE_NAME;
    }

    public ListIterator getAdjustableParamsIterator() {
        return this.adjustableParams.getParametersIterator();
    }

    public ParameterList getAdjustableParamsList() {
        return this.adjustableParams;
    }

    public String getImageFileName() {
        return this.JPG_FILE_NAME;
    }

    protected ArrayList getMapInfoLines() {
        ArrayList<String> metadataFilesLines = new ArrayList<String>();
        try {
            FileReader fr = new FileReader(this.METADATA_FILE_NAME);
            BufferedReader br = new BufferedReader(fr);
            String fileLines = br.readLine();
            while (fileLines != null) {
                metadataFilesLines.add(fileLines);
                fileLines = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return metadataFilesLines;
    }

    protected void makeFileFromLines(ArrayList lines, String fileName) {
        try {
            FileWriter fw = new FileWriter(fileName);
            BufferedWriter br = new BufferedWriter(fw);
            for (int i = 0; i < lines.size(); ++i) {
                br.write((String)lines.get(i) + "\n");
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMetatdataFileName(String fileName) {
        this.METADATA_FILE_NAME = fileName;
    }

    protected String openServletConnection(GMT_Map map, String metadataLines, String dirName) throws RuntimeException {
        String webaddr = null;
        try {
            URL gmtMapServlet = new URL(SERVLET_URL);
            URLConnection servletConnection = gmtMapServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject(dirName);
            outputToServlet.writeObject(map);
            outputToServlet.writeObject(metadataLines);
            outputToServlet.writeObject(DEFAULT_METADATA_FILE_NAME);
            outputToServlet.flush();
            outputToServlet.close();
            ObjectInputStream inputToServlet = new ObjectInputStream(servletConnection.getInputStream());
            Object messageFromServlet = inputToServlet.readObject();
            inputToServlet.close();
            if (!(messageFromServlet instanceof String)) {
                throw (RuntimeException)messageFromServlet;
            }
            webaddr = (String)messageFromServlet;
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Server is down, please try again later. If the problem persists, make sure you are using the latest version of our applications.");
        }
        return webaddr;
    }

    public void setParameter(String paramName, Object value) {
        this.adjustableParams.getParameter(paramName).setValue(value);
    }

    public String getGMTFilesWebAddress() {
        return this.imgWebAddr;
    }

    private double getNiceKmScaleLength(double lat, double minLon, double maxLon) {
        double test;
        double target = (maxLon - minLon) * 111.0 * Math.cos(Math.PI * lat / 180.0) / 4.0;
        for (test = 0.1; target > test; test *= 10.0) {
        }
        return Math.ceil(target / (test /= 10.0)) * test;
    }

    private double getNiceMapTickInterval(double minLat, double maxLat, double minLon, double maxLon) {
        double niceTick = Double.NaN;
        double diff = maxLat - minLat < maxLon - minLon ? maxLat - minLat : maxLon - minLon;
        diff /= 2.0;
        boolean finished = false;
        double fact = 100.0;
        while (!finished) {
            double d;
            double d2;
            double d3;
            niceTick = 1.0 * fact;
            if (d3 <= diff) {
                finished = true;
                continue;
            }
            niceTick = 0.5 * fact;
            if (d2 <= diff) {
                finished = true;
                continue;
            }
            niceTick = 0.25 * fact;
            if (d <= diff) {
                finished = true;
                continue;
            }
            fact /= 10.0;
        }
        return (float)niceTick;
    }

    public GriddedRegion getEvenlyGriddedGeographicRegion() {
        double minLat = (Double)this.minLatParam.getValue();
        double maxLat = (Double)this.maxLatParam.getValue();
        double minLon = (Double)this.minLonParam.getValue();
        double maxLon = (Double)this.maxLonParam.getValue();
        double gridSpacing = (Double)this.gridSpacingParam.getValue();
        return new GriddedRegion(new Location(minLat, minLon), new Location(maxLat, maxLon), gridSpacing, new Location(0.0, 0.0));
    }

    @Deprecated
    protected ArrayList getGMT_ScriptLines() throws GMT_MapException {
        double colorScaleMax;
        double colorScaleMin;
        ArrayList<CallSite> rmFiles = new ArrayList<CallSite>();
        ArrayList<Object> gmtCommandLines = new ArrayList<Object>();
        double minLat = (Double)this.minLatParam.getValue();
        double maxTempLat = (Double)this.maxLatParam.getValue();
        double minLon = (Double)this.minLonParam.getValue();
        double maxTempLon = (Double)this.maxLonParam.getValue();
        double gridSpacing = (Double)this.gridSpacingParam.getValue();
        double maxLat = Math.rint((maxTempLat - minLat) / gridSpacing) * gridSpacing + minLat;
        double maxLon = Math.rint((maxTempLon - minLon) / gridSpacing) * gridSpacing + minLon;
        String region = " -R" + minLon + "/" + maxLon + "/" + minLat + "/" + maxLat + " ";
        String fileName = "temp_junk";
        String grdFileName = fileName + ".grd";
        rmFiles.add((CallSite)((Object)grdFileName));
        String cptFile = GMT_DATA_PATH + GMT_CPT_Files.MAX_SPECTRUM.getFileName();
        String colorScaleMode = (String)this.colorScaleModeParam.getValue();
        String coast = (String)this.coastParam.getValue();
        String resolution = (String)this.topoResolutionParam.getValue();
        String topoIntenFile = GMT_DATA_PATH + "calTopoInten" + resolution + ".grd";
        String showHiwys = (String)this.showHiwysParam.getValue();
        double plotWdth = 6.5;
        String projWdth = " -JM" + plotWdth + "i ";
        double plotHght = (maxLat - minLat) / (maxLon - minLon) * plotWdth / Math.cos(Math.PI * (maxLat + minLat) / 360.0);
        double yOffset = 11.0 - plotHght - 0.5;
        String yOff = " -Y" + yOffset + "i ";
        String xOff = " -X1.0i ";
        gmtCommandLines.add("#!/bin/bash\n\n");
        gmtCommandLines.add("# path variables\n");
        gmtCommandLines.add("GMT_PATH='" + GMT_PATH + "'\n");
        gmtCommandLines.add("CONVERT_PATH='" + CONVERT_PATH + "'\n");
        gmtCommandLines.add("COMMAND_PATH='" + COMMAND_PATH + "'\n");
        gmtCommandLines.add("PS2PDF_PATH='" + PS2PDF_PATH + "'\n\n");
        Object commandLine = "${GMT_PATH}xyz2grd " + this.XYZ_FILE_NAME + " -G" + grdFileName + " -I" + gridSpacing + region + " -D/degree/degree/amp/=/=/=  -:";
        gmtCommandLines.add((String)commandLine + "\n");
        if (colorScaleMode.equals(COLOR_SCALE_MODE_MANUALLY)) {
            colorScaleMin = (Double)this.colorScaleMinParam.getValue();
            if (colorScaleMin >= (colorScaleMax = ((Double)this.colorScaleMaxParam.getValue()).doubleValue())) {
                throw new RuntimeException("Error: Color-Scale Min must be less than the Max");
            }
        } else {
            colorScaleMin = this.xyzDataSet.getMinZ();
            colorScaleMax = this.xyzDataSet.getMaxZ();
            System.out.println(colorScaleMin + "," + colorScaleMax);
            if (colorScaleMin == colorScaleMax) {
                throw new RuntimeException("Can't make the image plot because all Z values in the XYZ dataset have the same value ");
            }
        }
        float inc = (float)((colorScaleMax - colorScaleMin) / 20.0);
        commandLine = "${GMT_PATH}makecpt -C" + cptFile + " -T" + colorScaleMin + "/" + colorScaleMax + "/" + inc + " -Z > " + fileName + ".cpt";
        gmtCommandLines.add((String)commandLine + "\n");
        gmtCommandLines.add("${COMMAND_PATH}rm gmtdefaults4\n");
        if (((Boolean)this.blackBackgroundParam.getValue()).booleanValue()) {
            commandLine = "${GMT_PATH}gmtset FONT_ANNOT_PRIMARY=14p,white FONT_LABEL=18p,white PS_PAGE_COLOR=0/0/0 PS_PAGE_ORIENTATION=portrait PS_MEDIA=letter";
            commandLine = (String)commandLine + " MAP_DEFAULT_PEN=+white FORMAT_GEO_MAP=-D MAP_FRAME_WIDTH=0.1i MAP_FRAME_PEN=1p";
        } else {
            commandLine = "${GMT_PATH}gmtset FONT_ANNOT_PRIMARY=14p,black FONT_LABEL=18p,black PS_PAGE_COLOR=255/255/255 PS_PAGE_ORIENTATION=portrait PS_MEDIA=letter";
            commandLine = (String)commandLine + " MAP_DEFAULT_PEN=black FORMAT_GEO_MAP=-D MAP_FRAME_WIDTH=0.1i MAP_FRAME_PEN=1p";
        }
        gmtCommandLines.add((String)commandLine + "\n");
        int dpi = (Integer)this.dpiParam.getValue();
        if (!((Boolean)this.gmtSmoothingParam.getValue()).booleanValue()) {
            commandLine = "${GMT_PATH}grdimage " + grdFileName + xOff + yOff + projWdth + " -C" + fileName + ".cpt  -K -E" + dpi + region + " > " + this.PS_FILE_NAME;
            gmtCommandLines.add((String)commandLine + "\n");
        } else if (resolution.equals(TOPO_RESOLUTION_NONE)) {
            commandLine = "${GMT_PATH}grdimage " + grdFileName + xOff + yOff + projWdth + " -C" + fileName + ".cpt  -K -E" + dpi + region + " > " + this.PS_FILE_NAME;
            gmtCommandLines.add((String)commandLine + "\n");
        } else {
            gridSpacing = Integer.valueOf(resolution).doubleValue() / 3600.0;
            double tempNum = Math.ceil((minLat - 32.0) / gridSpacing);
            minLat = tempNum * gridSpacing + 32.0;
            tempNum = Math.ceil((minLon - -126.0) / gridSpacing);
            minLon = tempNum * gridSpacing + -126.0;
            maxLat = Math.floor((maxLat - minLat) / gridSpacing) * gridSpacing + minLat;
            maxLon = Math.floor((maxLon - minLon) / gridSpacing) * gridSpacing + minLon;
            region = " -R" + minLon + "/" + maxLon + "/" + minLat + "/" + maxLat + " ";
            String hiResFile = fileName + "HiResData.grd";
            rmFiles.add((CallSite)((Object)hiResFile));
            commandLine = "${GMT_PATH}grdsample " + grdFileName + " -G" + hiResFile + " -I" + resolution + "s -nl " + region;
            gmtCommandLines.add((String)commandLine + "\n");
            String intenFile = fileName + "Inten.grd";
            commandLine = "${GMT_PATH}grdcut " + topoIntenFile + " -G" + intenFile + " " + region;
            rmFiles.add((CallSite)((Object)intenFile));
            gmtCommandLines.add((String)commandLine + "\n");
            commandLine = "${GMT_PATH}grdimage " + hiResFile + " " + xOff + yOff + projWdth + " -I" + fileName + "Inten.grd -C" + fileName + ".cpt -K -E" + dpi + region + " > " + this.PS_FILE_NAME;
            gmtCommandLines.add((String)commandLine + "\n");
        }
        if (!showHiwys.equals("None")) {
            commandLine = "${GMT_PATH}psxy  " + region + projWdth + " -K -O -W1p,125/125/125 -: " + GMT_DATA_PATH + showHiwys + " >> " + this.PS_FILE_NAME;
            gmtCommandLines.add((String)commandLine + "\n");
        }
        if (coast.equals("Draw & Fill")) {
            commandLine = "${GMT_PATH}pscoast " + region + projWdth + " -K -O  -W1p,17/73/71 -P -S17/73/71 -Dh -Na >> " + this.PS_FILE_NAME;
            gmtCommandLines.add((String)commandLine + "\n");
        } else if (coast.equals(COAST_DRAW)) {
            commandLine = "${GMT_PATH}pscoast " + region + projWdth + " -K -O  -W4 -P -Dh -Na>> " + this.PS_FILE_NAME;
            gmtCommandLines.add((String)commandLine + "\n");
        }
        this.addIntermediateGMT_ScriptLines(gmtCommandLines, region, projWdth);
        DecimalFormat df2 = new DecimalFormat("0.E0");
        Float tickInc = Float.valueOf(df2.format((colorScaleMax - colorScaleMin) / 4.0));
        inc = tickInc.floatValue();
        boolean customLabelSelected = (Boolean)this.customScaleLabelCheckParam.getValue();
        String scaleLabel = "";
        scaleLabel = customLabelSelected ? (String)this.scaleLabelParam.getValue() : this.SCALE_LABEL;
        commandLine = "${GMT_PATH}psscale -Ba" + inc + ":" + scaleLabel + ": -D3.25i/-0.5i/6i/0.3ih -C" + fileName + ".cpt -O -K -N70 >> " + this.PS_FILE_NAME;
        gmtCommandLines.add((String)commandLine + "\n");
        double niceKmLength = this.getNiceKmScaleLength(minLat, minLon, maxLon);
        double kmScaleXoffset = plotWdth / 4.0;
        double niceTick = this.getNiceMapTickInterval(minLat, maxLat, minLon, maxLon);
        commandLine = "${GMT_PATH}psbasemap -B" + niceTick + "/" + niceTick + "eWNs " + projWdth + region + " -Lfx" + kmScaleXoffset + "i/0.5i/" + minLat + "/" + niceKmLength + "+l -O >> " + this.PS_FILE_NAME;
        gmtCommandLines.add((String)commandLine + "\n");
        boolean use_gs_raster = true;
        int heightInPixels = (int)((11.0 - yOffset + 2.0) * (double)dpi);
        String convertArgs = "-crop 595x" + heightInPixels + "+0+0";
        double imageWidth = (Double)this.imageWidthParam.getValue();
        if (imageWidth != IMAGE_WIDTH_DEFAULT) {
            int wdth = (int)(imageWidth * (double)dpi);
            convertArgs = convertArgs + " -filter Lanczos -geometry " + wdth;
        }
        if (use_gs_raster) {
            int jpeg_quality = 90;
            gmtCommandLines.add("${COMMAND_PATH}cat " + this.PS_FILE_NAME + " | " + GS_PATH + " -sDEVICE=jpeg  -dJPEGQ=" + jpeg_quality + " -sOutputFile=" + this.JPG_FILE_NAME + " -\n");
            gmtCommandLines.add("${COMMAND_PATH}cat " + this.PS_FILE_NAME + " | " + GS_PATH + " -sDEVICE=png16m -dTextAlphaBits=4 -sOutputFile=" + this.PNG_FILE_NAME + " -\n");
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + this.JPG_FILE_NAME + " " + this.JPG_FILE_NAME + "\n");
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + this.PNG_FILE_NAME + " " + this.PNG_FILE_NAME + "\n");
        } else {
            convertArgs = "-density " + dpi + " " + convertArgs;
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + this.PS_FILE_NAME + " " + this.JPG_FILE_NAME + "\n");
            gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + this.PS_FILE_NAME + " " + this.PNG_FILE_NAME + "\n");
        }
        boolean googleearth = true;
        if (googleearth) {
            System.out.println("Making Google Earth files!");
            String gEarth_psFileName = "gEarth_" + this.PS_FILE_NAME;
            String gEarth_proj = " -JQ180/" + plotWdth + "i ";
            String string = "./map.kmz";
            if (!((Boolean)this.gmtSmoothingParam.getValue()).booleanValue()) {
                commandLine = "${GMT_PATH}grdview " + grdFileName + xOff + yOff + gEarth_proj + " -C" + fileName + ".cpt -Ts -K" + dpi + region + " > " + gEarth_psFileName;
                gmtCommandLines.add((String)commandLine + "\n");
            } else if (resolution.equals(TOPO_RESOLUTION_NONE)) {
                commandLine = "${GMT_PATH}grdimage " + grdFileName + xOff + yOff + gEarth_proj + " -C" + fileName + ".cpt  -K -E" + dpi + region + " > " + gEarth_psFileName;
                gmtCommandLines.add((String)commandLine + "\n");
            } else {
                commandLine = "${GMT_PATH}grdimage " + fileName + "HiResData.grd " + xOff + yOff + gEarth_proj + " -I" + fileName + "Inten.grd -C" + fileName + ".cpt -K -E" + dpi + region + " > " + gEarth_psFileName;
                gmtCommandLines.add((String)commandLine + "\n");
            }
            commandLine = JAVA_PATH + " -cp " + JAVA_CLASSPATH + " " + GMT_KML_Generator.class.getName() + " " + gEarth_psFileName + " " + string + " " + minLat + " " + maxLat + " " + minLon + " " + maxLon;
            gmtCommandLines.add((String)commandLine + "\n");
        }
        commandLine = "${PS2PDF_PATH}  " + this.PS_FILE_NAME + "  " + this.PDF_FILE_NAME;
        gmtCommandLines.add((String)commandLine + "\n");
        if (rmFiles.size() > 0) {
            Object rmCommand = "${COMMAND_PATH}rm";
            for (String string : rmFiles) {
                rmCommand = (String)rmCommand + " " + string;
            }
            gmtCommandLines.add((String)rmCommand + "\n");
        }
        this.addFinalGMT_ScriptLines(gmtCommandLines);
        return gmtCommandLines;
    }

    public static String getGMTColorString(Color color) {
        return color.getRed() + "/" + color.getGreen() + "/" + color.getBlue();
    }

    private static String stripFormatLabel(String label) {
        label = label.replaceAll("'", "");
        label = label.replaceAll(";", "");
        return "'" + label + "'";
    }

    public static void clearEnv() {
        GMT_PATH = null;
        GS_PATH = null;
        CONVERT_PATH = null;
        COMMAND_PATH = null;
        PS2PDF_PATH = null;
        NETCDF_LIB_PATH = null;
    }

    public static ArrayList<String> getGMTPathEnvLines() {
        ArrayList<String> gmtCommandLines = new ArrayList<String>();
        gmtCommandLines.add("## path variables ##");
        String gmtPath = GMT_PATH;
        if (gmtPath == null) {
            gmtPath = "gmt ";
        }
        gmtCommandLines.add("GMT_PATH='" + gmtPath + "'");
        String gsPath = GS_PATH;
        if (gsPath == null) {
            gsPath = "gs";
        }
        gmtCommandLines.add("GS_PATH='" + gsPath + "'");
        String convertPath = CONVERT_PATH;
        if (convertPath == null) {
            convertPath = "convert";
        }
        gmtCommandLines.add("CONVERT_PATH='" + convertPath + "'");
        String cmdPath = COMMAND_PATH;
        if (cmdPath == null) {
            cmdPath = "";
        }
        gmtCommandLines.add("COMMAND_PATH='" + cmdPath + "'");
        String ps2pdfPath = PS2PDF_PATH;
        if (ps2pdfPath == null) {
            ps2pdfPath = "ps2pdf";
        }
        gmtCommandLines.add("PS2PDF_PATH='" + ps2pdfPath + "'");
        String netCDFPath = NETCDF_LIB_PATH;
        if (netCDFPath == null) {
            netCDFPath = "";
        }
        gmtCommandLines.add("NETCDF_LIB_PATH='" + netCDFPath + "'");
        gmtCommandLines.add("");
        gmtCommandLines.add("## ENV info");
        gmtCommandLines.add("echo \"SHELL: $SHELL\"");
        gmtCommandLines.add("echo \"PATH: $PATH\"");
        gmtCommandLines.add("if [[ -d $NETCDF_LIB_PATH ]];then");
        gmtCommandLines.add("\texport LD_LIBRARY_PATH=$NETCDF_LIB_PATH:${LD_LIBRARY_PATH}");
        gmtCommandLines.add("fi");
        gmtCommandLines.add("echo \"LD_LIBRARY_PATH: $LD_LIBRARY_PATH\"");
        gmtCommandLines.add("");
        return gmtCommandLines;
    }

    @Override
    public ArrayList<String> getGMT_ScriptLines(GMT_Map map, String dir) throws GMT_MapException {
        boolean googleearth;
        double colorScaleMax;
        double colorScaleMin;
        GeoDataSet griddedData;
        Object cptFile;
        System.out.println("Generating map for dir: " + (String)dir);
        if (!((String)dir).endsWith(File.separator)) {
            dir = (String)dir + File.separator;
        }
        ArrayList<String> rmFiles = new ArrayList<String>();
        ArrayList<String> gmtCommandLines = new ArrayList<String>();
        double minLat = map.getRegion().getMinLat();
        double maxTempLat = map.getRegion().getMaxLat();
        double minLon = map.getRegion().getMinLon();
        double maxTempLon = map.getRegion().getMaxLon();
        double gridSpacing = map.getGriddedDataInc();
        double maxLat = Math.rint((maxTempLat - minLat) / gridSpacing) * gridSpacing + minLat;
        double maxLon = Math.rint((maxTempLon - minLon) / gridSpacing) * gridSpacing + minLon;
        String region = " -R" + (float)minLon + "/" + (float)maxLon + "/" + (float)minLat + "/" + (float)maxLat + " ";
        String tempFilePrefix = "temp_junk";
        Object grdFileName = tempFilePrefix + ".grd";
        rmFiles.add((String)grdFileName);
        if (map.getCptFile() != null) {
            cptFile = GMT_DATA_PATH + map.getCptFile();
        } else {
            cptFile = map.getCustomCptFileName();
            CPT cpt = map.getCpt();
            try {
                cpt.writeCPTFile((String)dir + (String)cptFile);
            }
            catch (IOException e) {
                throw new GMT_MapException("Could not write custom CPT file", e);
            }
        }
        String topoIntenFile = null;
        if (map.getTopoResolution() != null) {
            topoIntenFile = GMT_DATA_PATH + map.getTopoResolution().fileName();
        }
        if (topoIntenFile != null && !map.getTopoResolution().region().contains(map.getRegion())) {
            throw new GMT_MapException("Topography not available for the chosen region; please select \"No Topo\" for the Topo Resolution parameter");
        }
        double plotWdth = 6.5;
        double cosTerm = Math.cos(Math.PI * (maxLat + minLat) / 360.0);
        double plotHght = (maxLat - minLat) / (maxLon - minLon) * plotWdth / cosTerm;
        System.out.println("calc height: " + plotHght);
        if (plotHght > 7.625) {
            plotHght = 7.625;
            plotWdth = plotHght * cosTerm * (maxLon - minLon) / (maxLat - minLat);
        }
        String projWdth = " -JM" + plotWdth + "i ";
        double yOffset = 11.0 - plotHght - 0.5;
        System.out.println("yOffset: " + yOffset + ", height=" + plotHght + ", width=" + plotWdth);
        String yOff = " -Y" + yOffset + "i ";
        double xOffset = 1.0 + 0.5 * (6.5 - plotWdth);
        String xOff = " -X" + (float)xOffset + "i ";
        gmtCommandLines.add("#!/bin/bash");
        gmtCommandLines.add("");
        gmtCommandLines.add("cd " + (String)dir);
        gmtCommandLines.add("");
        gmtCommandLines.addAll(GMT_MapGenerator.getGMTPathEnvLines());
        gmtCommandLines.add("## Plot Script ##");
        gmtCommandLines.add("");
        gmtCommandLines.add("# Set GMT paper/font & map defaults");
        Object commandLine = map.isBlackBackground() ? "${GMT_PATH}gmtset FONT_ANNOT_PRIMARY=14p,white FONT_LABEL=18p,white PS_PAGE_COLOR=0/0/0 PS_PAGE_ORIENTATION=portrait PS_MEDIA=letter" : "${GMT_PATH}gmtset FONT_ANNOT_PRIMARY=14p,black FONT_LABEL=18p,black PS_PAGE_COLOR=255/255/255 PS_PAGE_ORIENTATION=portrait PS_MEDIA=letter";
        gmtCommandLines.add((String)commandLine);
        gmtCommandLines.add("");
        commandLine = map.isBlackBackground() ? "${GMT_PATH}gmtset MAP_DEFAULT_PEN=+white FORMAT_GEO_MAP=-D MAP_FRAME_WIDTH=0.1i COLOR_FOREGROUND=255/255/255 MAP_FRAME_PEN=1p" : "${GMT_PATH}gmtset MAP_DEFAULT_PEN=black FORMAT_GEO_MAP=-D MAP_FRAME_WIDTH=0.1i COLOR_FOREGROUND=255/255/255 MAP_FRAME_PEN=1p";
        gmtCommandLines.add((String)commandLine);
        gmtCommandLines.add("");
        if (map.getGMT_Params() != null) {
            gmtCommandLines.add("# GMT Params");
            for (String name : map.getGMT_Params().keySet()) {
                String value = map.getGMT_Params().get(name);
                gmtCommandLines.add("${GMT_PATH}gmtset " + name + " " + value);
            }
            gmtCommandLines.add("");
        }
        if ((griddedData = map.getGriddedData()) != null) {
            try {
                ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)griddedData, (String)dir + map.getXyzFileName());
            }
            catch (IOException e) {
                throw new GMT_MapException("Could not write XYZ data to a file", e);
            }
            if (map.getInterpSettings() == null) {
                gmtCommandLines.add("# convert xyz file to grd file");
                commandLine = "${GMT_PATH}xyz2grd " + map.getXyzFileName() + " -G" + (String)grdFileName + " -I" + gridSpacing + region + " -D/degree/degree/amp/=/=/=  -:";
                gmtCommandLines.add((String)commandLine);
            } else {
                GMT_InterpolationSettings interpSettings = map.getInterpSettings();
                gmtCommandLines.add("# do GMT interpolation on the scatter data");
                commandLine = "${GMT_PATH}surface " + map.getXyzFileName() + " -G" + (String)grdFileName + " -I" + gridSpacing + region + interpSettings.getConvergenceArg() + " " + interpSettings.getSearchArg() + " " + interpSettings.getTensionArg() + " -: -H0";
                gmtCommandLines.add((String)commandLine);
                if (interpSettings.isSaveInterpSurface()) {
                    gmtCommandLines.add("# write interpolated XYZ file");
                    commandLine = "${GMT_PATH}grd2xyz " + (String)grdFileName + " > map_data_interpolated.txt";
                    gmtCommandLines.add((String)commandLine);
                }
            }
        } else if (map.getCustomGRDPath() != null) {
            File grdFile = new File(map.getCustomGRDPath());
            Preconditions.checkState((boolean)grdFile.exists(), (Object)("File doesn't esist: " + grdFile.getAbsolutePath()));
            grdFileName = grdFile.getAbsolutePath();
        }
        if (map.isCustomScale()) {
            colorScaleMin = map.getCustomScaleMin();
            if (colorScaleMin >= (colorScaleMax = map.getCustomScaleMax().doubleValue())) {
                throw new RuntimeException("Error: Color-Scale Min must be less than the Max");
            }
        } else {
            colorScaleMin = griddedData.getMinZ();
            colorScaleMax = griddedData.getMaxZ();
            System.out.println(colorScaleMin + "," + colorScaleMax);
            if (colorScaleMin == colorScaleMax) {
                throw new RuntimeException("Can't make the image plot because all Z values in the XYZ dataset have the same value ");
            }
        }
        if (map.isRescaleCPT()) {
            float inc = (float)((colorScaleMax - colorScaleMin) / 20.0);
            String tempCPT = tempFilePrefix + ".cpt";
            rmFiles.add(tempCPT);
            gmtCommandLines.add("# Rescale the CPT file");
            commandLine = "${GMT_PATH}makecpt -C" + (String)cptFile + " -T" + colorScaleMin + "/" + colorScaleMax + "/" + inc + " -Z > " + tempCPT;
            gmtCommandLines.add((String)commandLine);
            cptFile = tempCPT;
        }
        String psFileName = map.getPSFileName();
        boolean doContour = map.getGriddedData() != null && map.getContourIncrement() > 0.0;
        boolean contourOnly = doContour && map.isContourOnly();
        Object grdFileForContour = grdFileName;
        int dpi = map.getDpi();
        if (griddedData == null && map.getCustomGRDPath() == null) {
            commandLine = "echo 1000 1000 | ${GMT_PATH}psxy " + region + xOff + yOff + projWdth + " -K > " + psFileName;
            gmtCommandLines.add((String)commandLine + "\n");
        } else {
            if (map.isMaskIfNotRectangular() && !map.getRegion().isRectangular() && (!map.isUseGMTSmoothing() || map.getTopoResolution() == null || contourOnly)) {
                String maskName = "mask.xy";
                String maskGRD = "mask.grd";
                rmFiles.add(maskGRD);
                try {
                    GMT_MapGenerator.writeMaskFile(map.getRegion(), (String)dir + maskName);
                }
                catch (IOException e) {
                    throw new GMT_MapException("Couldn't write mask file!", e);
                }
                String spacing = "" + gridSpacing;
                gmtCommandLines.add("# create mask");
                commandLine = "${GMT_PATH}grdmask " + maskName + region + " -I" + spacing + " -NNaN/1/1 -G" + maskGRD;
                gmtCommandLines.add((String)commandLine + "\n");
                String unmaskedGRD = "unmasked_" + (String)grdFileName;
                rmFiles.add(unmaskedGRD);
                gmtCommandLines.add("mv " + (String)grdFileName + " " + unmaskedGRD);
                gmtCommandLines.add("${GMT_PATH}grdmath " + unmaskedGRD + " " + maskGRD + " MUL = " + (String)grdFileName + "\n");
            }
            if (!map.isUseGMTSmoothing()) {
                if (!contourOnly) {
                    commandLine = map.isUseGRDView() ? "${GMT_PATH}grdview " + (String)grdFileName + xOff + yOff + projWdth + " -C" + (String)cptFile + " -Ts -K" + region + " > " + psFileName : "${GMT_PATH}grdimage " + (String)grdFileName + xOff + yOff + projWdth + " -C" + (String)cptFile + " -K" + region + " > " + psFileName;
                    gmtCommandLines.add((String)commandLine + "\n");
                }
            } else if (map.getTopoResolution() == null && map.getCustomIntenPath() == null) {
                if (!contourOnly) {
                    gmtCommandLines.add("# Plot the gridded data");
                    commandLine = "${GMT_PATH}grdimage " + (String)grdFileName + xOff + yOff + projWdth + " -C" + (String)cptFile + "  -K -E" + dpi + region + " > " + psFileName;
                    gmtCommandLines.add((String)commandLine + "\n");
                }
            } else if (!contourOnly) {
                Object intenFile;
                Object hiResFile;
                TopographicSlopeFile topoFile = map.getTopoResolution();
                if (topoFile != null) {
                    gridSpacing = GeoTools.secondsToDeg(map.getTopoResolution().resolution());
                    double tempNum = Math.ceil((minLat - topoFile.region().getMinLat()) / gridSpacing);
                    minLat = tempNum * gridSpacing + topoFile.region().getMinLat();
                    tempNum = Math.ceil((minLon - topoFile.region().getMinLon()) / gridSpacing);
                    minLon = tempNum * gridSpacing + topoFile.region().getMinLon();
                    maxLat = Math.floor((maxLat - minLat) / gridSpacing) * gridSpacing + minLat;
                    maxLon = Math.floor((maxLon - minLon) / gridSpacing) * gridSpacing + minLon;
                    region = " -R" + (float)minLon + "/" + (float)maxLon + "/" + (float)minLat + "/" + (float)maxLat + " ";
                    hiResFile = tempFilePrefix + "HiResData.grd";
                    rmFiles.add((String)hiResFile);
                    gmtCommandLines.add("# Resample the map to the topo resolution");
                    commandLine = "${GMT_PATH}grdsample " + (String)grdFileName + " -G" + (String)hiResFile + " -I" + topoFile.resolution() + "s -nl " + region;
                    gmtCommandLines.add((String)commandLine);
                    intenFile = tempFilePrefix + "Inten.grd";
                    gmtCommandLines.add("# Cut the topo file to match the data region");
                    commandLine = "${GMT_PATH}grdcut " + topoIntenFile + " -G" + (String)intenFile + " " + region;
                    rmFiles.add((String)intenFile);
                    gmtCommandLines.add((String)commandLine);
                } else {
                    Preconditions.checkNotNull((Object)map.getCustomIntenPath());
                    hiResFile = grdFileName;
                    intenFile = map.getCustomIntenPath();
                }
                if (map.isMaskIfNotRectangular() && !map.getRegion().isRectangular()) {
                    String maskName = "mask.xy";
                    String maskGRD = "mask.grd";
                    rmFiles.add(maskGRD);
                    try {
                        GMT_MapGenerator.writeMaskFile(map.getRegion(), (String)dir + maskName);
                    }
                    catch (IOException e) {
                        throw new GMT_MapException("Couldn't write mask file!", e);
                    }
                    String spacing = topoFile.resolution() + "c";
                    gmtCommandLines.add("# create mask");
                    commandLine = "${GMT_PATH}grdmask " + maskName + region + " -I" + spacing + " -NNaN/1/1 -G" + maskGRD;
                    gmtCommandLines.add((String)commandLine + "\n");
                    String unmaskedGRD = "unmasked_" + (String)hiResFile;
                    rmFiles.add(unmaskedGRD);
                    gmtCommandLines.add("mv " + (String)hiResFile + " " + unmaskedGRD);
                    gmtCommandLines.add("${GMT_PATH}grdmath " + unmaskedGRD + " " + maskGRD + " MUL = " + (String)hiResFile + "\n");
                }
                grdFileForContour = hiResFile;
                gmtCommandLines.add("# Plot the gridded data with topographic shading");
                commandLine = "${GMT_PATH}grdimage " + (String)hiResFile + " " + xOff + yOff + projWdth + " -I" + (String)intenFile + " -C" + (String)cptFile + " -K -E" + dpi + region + " > " + psFileName;
                gmtCommandLines.add((String)commandLine);
            }
        }
        if (doContour) {
            gmtCommandLines.add("# Plot contours");
            Object contourPenIncStr = " -W1p ";
            contourPenIncStr = map.isCPTEqualSpacing() ? (String)contourPenIncStr + "-C" + (String)cptFile : (String)contourPenIncStr + "-A" + (float)map.getContourIncrement();
            commandLine = contourOnly ? "${GMT_PATH}grdcontour " + (String)grdFileForContour + xOff + yOff + projWdth + " -K " + region + (String)contourPenIncStr + " > " + psFileName : "${GMT_PATH}grdcontour " + (String)grdFileForContour + projWdth + " -O -K " + region + (String)contourPenIncStr + " >> " + psFileName;
            gmtCommandLines.add((String)commandLine + "\n");
        }
        gmtCommandLines.add("");
        GMT_MapGenerator.addSpecialElements(gmtCommandLines, map, region, projWdth, psFileName);
        GMT_MapGenerator.addColorbarCommand(gmtCommandLines, map, colorScaleMin, colorScaleMax, (String)cptFile, psFileName, plotWdth);
        double niceTick = this.getNiceMapTickInterval(minLat, maxLat, minLon, maxLon);
        gmtCommandLines.add("# Map frame and KM scale label");
        commandLine = "${GMT_PATH}psbasemap -B" + niceTick + "/" + niceTick + "eWNs " + projWdth + region;
        if (map.isDrawScaleKM()) {
            double niceKmLength = this.getNiceKmScaleLength(minLat, minLon, maxLon);
            double kmScaleXoffset = plotWdth / 4.0;
            commandLine = (String)commandLine + " -Lfx" + kmScaleXoffset + "i/0.5i/" + minLat + "/" + niceKmLength + "+l";
        }
        commandLine = (String)commandLine + " -O >> " + psFileName;
        gmtCommandLines.add((String)commandLine);
        gmtCommandLines.add("");
        gmtCommandLines.add("## PostScript conversion ##");
        boolean use_gs_raster = true;
        String jpgFileName = map.getJPGFileName();
        String pngFileName = map.getPNGFileName();
        int heightInPixels = (int)((11.0 - yOffset + 2.0) * (double)dpi);
        String convertArgs = "-crop 595x" + heightInPixels + "+0+0";
        double imageWidth = map.getImageWidth();
        if (imageWidth != IMAGE_WIDTH_DEFAULT) {
            int wdth = (int)(imageWidth * (double)dpi);
            convertArgs = convertArgs + " -filter Lanczos -geometry " + wdth;
        }
        String gsArgs = " -dNumRenderingThreads=4 -dBandBufferSpace=500000000 -dBufferSpace=1000000000 ";
        if (use_gs_raster) {
            int jpeg_quality = 90;
            if (jpgFileName != null) {
                gmtCommandLines.add("${COMMAND_PATH}cat " + psFileName + " | ${GS_PATH}" + gsArgs + " -sDEVICE=jpeg  -dJPEGQ=" + jpeg_quality + " -sOutputFile=" + jpgFileName + " -");
            }
            if (pngFileName != null) {
                gmtCommandLines.add("${COMMAND_PATH}cat " + psFileName + " | ${GS_PATH}" + gsArgs + " -sDEVICE=png16m -dTextAlphaBits=4 -sOutputFile=" + pngFileName + " -");
            }
            if (jpgFileName != null) {
                gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + jpgFileName + " " + jpgFileName);
            }
            if (pngFileName != null) {
                gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + pngFileName + " " + pngFileName);
            }
        } else {
            convertArgs = "-density " + dpi + " " + convertArgs;
            if (jpgFileName != null) {
                gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + psFileName + " " + jpgFileName);
            }
            if (pngFileName != null) {
                gmtCommandLines.add("${CONVERT_PATH} " + convertArgs + " " + psFileName + " " + pngFileName);
            }
        }
        if (map.getPDFFileName() != null) {
            commandLine = "${PS2PDF_PATH}" + gsArgs + " " + psFileName + "  " + map.getPDFFileName();
            gmtCommandLines.add((String)commandLine);
        }
        if ((googleearth = map.isGenerateKML()) && griddedData != null) {
            gmtCommandLines.add("## Google earth files ##");
            System.out.println("Making Google Earth files!");
            String gEarth_pngFileName = "gEarth.png";
            String gEarth_proj = " -JQ180/" + plotWdth + "i ";
            String gEarth_kmz_name = "./map.kmz";
            gmtCommandLines.add("# Make PS file for google earth");
            String aArg = " -A" + gEarth_pngFileName + "=PNG";
            if (!map.isUseGMTSmoothing()) {
                commandLine = "${GMT_PATH}grdimage " + (String)grdFileName + xOff + yOff + gEarth_proj + aArg + " -C" + (String)cptFile + "  -E" + dpi + region;
                gmtCommandLines.add((String)commandLine);
            } else if (map.getTopoResolution() == null) {
                commandLine = "${GMT_PATH}grdimage " + (String)grdFileName + xOff + yOff + gEarth_proj + aArg + " -C" + (String)cptFile + "  -E" + dpi + region;
                gmtCommandLines.add((String)commandLine);
            } else {
                commandLine = "${GMT_PATH}grdimage " + tempFilePrefix + "HiResData.grd " + xOff + yOff + gEarth_proj + aArg + " -I" + tempFilePrefix + "Inten.grd -C" + (String)cptFile + " -E" + dpi + region;
                gmtCommandLines.add((String)commandLine);
            }
            commandLine = JAVA_PATH + " -Xmx4G -cp " + JAVA_CLASSPATH + " " + GMT_KML_Generator.class.getName() + " " + gEarth_pngFileName + " " + gEarth_kmz_name + " " + minLat + " " + maxLat + " " + minLon + " " + maxLon;
            gmtCommandLines.add((String)commandLine);
        }
        GMT_MapGenerator.addCleanup(gmtCommandLines, rmFiles);
        this.addFinalGMT_ScriptLines(gmtCommandLines);
        return gmtCommandLines;
    }

    public static void writeMaskFile(Region region, String fileName) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        Location first = null;
        for (Location loc : region.getBorder()) {
            if (first == null) {
                first = loc;
            }
            fw.write(loc.getLongitude() + " " + loc.getLatitude() + "\n");
        }
        fw.write(first.getLongitude() + " " + first.getLatitude() + "\n");
        fw.close();
    }

    public static void addCleanup(ArrayList<String> gmtCommandLines, ArrayList<String> rmFiles) {
        if (rmFiles.size() > 0) {
            gmtCommandLines.add("");
            gmtCommandLines.add("# Clean up");
            Object rmCommand = "${COMMAND_PATH}rm";
            for (String rmFile : rmFiles) {
                rmCommand = (String)rmCommand + " " + rmFile;
            }
            gmtCommandLines.add((String)rmCommand);
        }
    }

    public static void addHighwayCommand(ArrayList<String> gmtCommandLines, GMT_Map map, String region, String proj, String psFile) {
        if (map.getHighwayFile() != null) {
            gmtCommandLines.add("# Add highways to plot");
            gmtCommandLines.add("${GMT_PATH}psxy  " + region + proj + " -K -O -W1p,125/125/125 -: " + GMT_DATA_PATH + map.getHighwayFile().fileName() + " >> " + psFile + "\n");
        }
    }

    public static void addCoastCommand(ArrayList<String> gmtCommandLines, GMT_Map map, String region, String proj, String psFile) {
        CoastAttributes coastAt = map.getCoast();
        if (coastAt != null) {
            Object fillColor = "";
            if (coastAt.getFillColor() != null) {
                fillColor = "-S" + GMT_MapGenerator.getGMTColorString(coastAt.getFillColor());
            }
            Object lineColor = "";
            if (coastAt.getLineColor() != null) {
                lineColor = "-W" + coastAt.getLineSize() + "p," + GMT_MapGenerator.getGMTColorString(coastAt.getLineColor());
            }
            gmtCommandLines.add("# Draw coastline");
            gmtCommandLines.add("${GMT_PATH}pscoast " + region + proj + " -K -O " + (String)lineColor + " -P " + (String)fillColor + " -Dh -Na/" + coastAt.getLineSize() + "p," + GMT_MapGenerator.getGMTColorString(coastAt.getLineColor()) + " >> " + psFile + "\n");
        }
    }

    public static void addPolyCommands(ArrayList<String> gmtCommandLines, GMT_Map map, String region, String proj, String psFile) throws GMT_MapException {
        ArrayList<PSXYPolygon> polys = map.getPolys();
        if (polys != null && polys.size() > 0) {
            System.out.println("Map has " + polys.size() + " polygons!");
            gmtCommandLines.add("");
            gmtCommandLines.add("# Lines/Polygons");
            String polyFile = "polys.xy";
            gmtCommandLines.add("${COMMAND_PATH}cat  << END > " + polyFile);
            for (int i = 0; i < polys.size(); ++i) {
                PSXYPolygon poly = polys.get(i);
                if (!poly.isValid()) {
                    throw new GMT_MapException("Polygons must have at least 2 points");
                }
                String sep = "> " + poly.getPenString();
                if (poly.size() > 2) {
                    sep = sep + " " + poly.getFillString();
                }
                gmtCommandLines.add(sep);
                for (Point2D point : poly.getPoints()) {
                    gmtCommandLines.add(point.getX() + "\t" + point.getY());
                }
            }
            gmtCommandLines.add("END");
            gmtCommandLines.add("${GMT_PATH}psxy " + polyFile + " " + region + proj + " -K -O >> " + psFile);
        }
    }

    public static void addSymbolCommands(ArrayList<String> gmtCommandLines, GMT_Map map, String region, String proj, String psFile) {
        ArrayList<PSXYSymbol> symbols = map.getSymbols();
        if (symbols != null && symbols.size() > 0) {
            System.out.println("Map has " + symbols.size() + " symbols!");
            gmtCommandLines.add("");
            gmtCommandLines.add("# Symbols");
            for (int i = 0; i < symbols.size(); ++i) {
                PSXYSymbol symbol = symbols.get(i);
                Point2D point = symbol.getPoint();
                String line = "echo " + point.getX() + " " + point.getY() + " | ${GMT_PATH}psxy " + symbol.getSymbolString() + " " + symbol.getFillString();
                if (symbol.getPenColor() != null) {
                    line = line + " " + symbol.getPenString();
                }
                line = line + " " + region + proj + " -K -O >> " + psFile;
                gmtCommandLines.add(line);
            }
        }
    }

    public static void addSymbolSetCommands(ArrayList<String> gmtCommandLines, GMT_Map map, String region, String proj, String psFile) {
        if (map.getSymbolSet() != null) {
            PSXYSymbolSet symSet = map.getSymbolSet();
            System.out.println("Map has a symbol set!");
            gmtCommandLines.add("");
            gmtCommandLines.add("# Symbol set");
            String symbolCPTFile = "symbol_set.cpt";
            gmtCommandLines.add("${COMMAND_PATH}cat  << END > " + symbolCPTFile);
            gmtCommandLines.add(symSet.getCpt().toString());
            gmtCommandLines.add("END");
            String symbolFile = "symbol_set.xy";
            gmtCommandLines.add("${COMMAND_PATH}cat  << END > " + symbolFile);
            List<PSXYSymbol> symbols = symSet.getSymbols();
            List<Double> vals = symSet.getVals();
            for (int i = 0; i < symbols.size(); ++i) {
                PSXYSymbol symbol = symbols.get(i);
                double val = vals.get(i);
                Point2D point = symbol.getPoint();
                String line = point.getX() + "\t" + point.getY() + "\t" + val + "\t" + symbol.getSymbol().val() + symbol.getWidth() + "i";
                gmtCommandLines.add(line);
            }
            gmtCommandLines.add("END");
            Object penStr = "";
            if (symSet.getPenColor() != null) {
                penStr = " " + symSet.getPenString();
            }
            gmtCommandLines.add("${GMT_PATH}psxy " + symbolFile + " -C" + symbolCPTFile + (String)penStr + " -S " + region + proj + " -K -O >> " + psFile);
        }
    }

    public static void addTextCommands(ArrayList<String> gmtCommandLines, GMT_Map map, String region, String proj, String psFile) {
        ArrayList<PSText> text = map.getText();
        if (text != null && text.size() > 0) {
            System.out.println("Map has " + text.size() + " text items!");
            gmtCommandLines.add("");
            gmtCommandLines.add("# Text");
            for (int i = 0; i < text.size(); ++i) {
                PSText item = text.get(i);
                Point2D point = item.getPoint();
                String line = "echo " + point.getX() + " " + point.getY() + " " + item.getText() + " | ${GMT_PATH}pstext " + item.getFontArg();
                line = line + " " + region + proj + " -K -O >> " + psFile;
                gmtCommandLines.add(line);
            }
        }
    }

    public static void addSpecialElements(ArrayList<String> gmtCommandLines, GMT_Map map, String region, String proj, String psFile) throws GMT_MapException {
        GMT_MapGenerator.addHighwayCommand(gmtCommandLines, map, region, proj, psFile);
        GMT_MapGenerator.addCoastCommand(gmtCommandLines, map, region, proj, psFile);
        GMT_MapGenerator.addPolyCommands(gmtCommandLines, map, region, proj, psFile);
        GMT_MapGenerator.addSymbolCommands(gmtCommandLines, map, region, proj, psFile);
        GMT_MapGenerator.addSymbolSetCommands(gmtCommandLines, map, region, proj, psFile);
        GMT_MapGenerator.addTextCommands(gmtCommandLines, map, region, proj, psFile);
    }

    public static void addColorbarCommand(ArrayList<String> gmtCommandLines, GMT_Map map, double colorScaleMin, double colorScaleMax, String cptFile, String psFile, double plotWidth) {
        if (!map.isHideColorbar()) {
            GMT_MapGenerator.addColorbarCommand(gmtCommandLines, map.getCustomLabel(), map.isLogPlot(), colorScaleMin, colorScaleMax, cptFile, psFile, map.isCPTEqualSpacing(), map.getCPTCustomInterval(), map.getLabelSize(), map.getLabelTickSize(), plotWidth);
        }
    }

    public static void addColorbarCommand(ArrayList<String> gmtCommandLines, String scaleLabel, boolean isLog, double colorScaleMin, double colorScaleMax, String cptFile, String psFile, boolean cptEqualSpacing, Double customTickInterval, Integer fontSize, Integer tickFontSize, double plotWidth) {
        String commandLine;
        DecimalFormat df2 = new DecimalFormat("0.E0");
        Float tickInc = customTickInterval == null ? Float.valueOf(df2.format((colorScaleMax - colorScaleMin) / 4.0)) : Float.valueOf(customTickInterval.floatValue());
        if (scaleLabel == null) {
            scaleLabel = " ";
        } else if (isLog) {
            scaleLabel = "Log10(" + (String)scaleLabel + ")";
        }
        scaleLabel = GMT_MapGenerator.stripFormatLabel((String)scaleLabel);
        gmtCommandLines.add("# Colorbar/label");
        if (fontSize != null && fontSize > 0) {
            commandLine = "${GMT_PATH}set FONT_LABEL=" + fontSize + "p,Helvetica,black";
            gmtCommandLines.add(commandLine + "\n");
        }
        if (tickFontSize != null && tickFontSize > 0) {
            commandLine = "${GMT_PATH}set FONT_ANNOT_PRIMARY=" + tickFontSize + "p,Helvetica,black";
            gmtCommandLines.add(commandLine + "\n");
        }
        float w = (float)Math.max(1.0, plotWidth - 0.5);
        float x = (float)(plotWidth / 2.0);
        if (cptEqualSpacing) {
            String commandLine2 = "${GMT_PATH}psscale -L -B+l" + (String)scaleLabel + " -D" + x + "i/-0.5i/" + w + "i/0.3ih -C" + cptFile + " -O -K -N70 >> " + psFile;
            gmtCommandLines.add(commandLine2 + "\n");
        } else {
            String commandLine3 = "${GMT_PATH}psscale -Ba" + tickInc + ":" + (String)scaleLabel + ": -D" + x + "i/-0.5i/" + w + "i/0.3ih -C" + cptFile + " -O -K -N70 >> " + psFile;
            gmtCommandLines.add(commandLine3 + "\n");
        }
    }

    protected void addIntermediateGMT_ScriptLines(ArrayList gmtLines, String region, String projWdth) {
    }

    protected void addFinalGMT_ScriptLines(ArrayList gmtCommandLines) {
    }

    private void checkForLogPlot() {
        boolean logPlotCheck = (Boolean)this.logPlotParam.getValue();
        if (logPlotCheck && this.xyzDataSet != null) {
            this.xyzDataSet.log10();
            this.SCALE_LABEL = "\"log@-10@-(" + this.SCALE_LABEL + ")\"";
        }
    }

    public void createMapInfoFile(String mapInfo) {
        ArrayList<String> mapInfoLines = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(mapInfo, "\n");
        while (st.hasMoreTokens()) {
            mapInfoLines.add(st.nextToken());
        }
        this.makeFileFromLines(mapInfoLines, this.METADATA_FILE_NAME);
    }
}

