/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt.elements;

import java.awt.Color;
import java.io.Serializable;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;

public abstract class PSXYElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double penWidth = 1.0;
    private Color penColor = Color.BLACK;
    private Color fillColor = null;
    private PlotLineType lineType = PlotLineType.SOLID;

    public PSXYElement() {
    }

    public PSXYElement(double penWidth, Color penColor, Color fillColor) {
        this.penWidth = penWidth;
        this.penColor = penColor;
        this.fillColor = fillColor;
    }

    public String getPenString() {
        if (this.penColor == null) {
            return "-W-";
        }
        if (this.penWidth <= 0.0) {
            return "-W-";
        }
        String str = "-W" + this.penWidth + "p," + GMT_MapGenerator.getGMTColorString(this.penColor);
        if (this.lineType != PlotLineType.SOLID) {
            switch (this.lineType) {
                case DASHED: {
                    str = str + ",-";
                    break;
                }
                case DOTTED: {
                    str = str + ",.";
                    break;
                }
                case DOTTED_AND_DASHED: {
                    str = str + ",-.";
                    break;
                }
                default: {
                    throw new IllegalStateException("LineType not supported: " + String.valueOf((Object)this.lineType));
                }
            }
        }
        return str;
    }

    public void setLineType(PlotLineType lineType) {
        this.lineType = lineType;
    }

    public PlotLineType getLineType() {
        return this.lineType;
    }

    public String getFillString() {
        if (this.fillColor == null) {
            return "";
        }
        return "-G" + GMT_MapGenerator.getGMTColorString(this.fillColor);
    }

    public double getPenWidth() {
        return this.penWidth;
    }

    public void setPenWidth(double penWidth) {
        this.penWidth = penWidth;
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public void setPenColor(Color penColor) {
        this.penColor = penColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }
}

