/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt.elements;

import java.awt.Color;
import java.awt.geom.Point2D;
import org.opensha.commons.mapping.gmt.elements.PSXYElement;

public class PSXYSymbol
extends PSXYElement {
    private static final long serialVersionUID = 1L;
    private Symbol symbol;
    private double width;
    private Point2D pt;

    public PSXYSymbol() {
    }

    public PSXYSymbol(Point2D pt, Symbol symbol, double width) {
        this.symbol = symbol;
        this.width = width;
        this.pt = pt;
    }

    public PSXYSymbol(Point2D pt, Symbol symbol, double width, double penWidth, Color penColor, Color fillColor) {
        super(penWidth, penColor, fillColor);
        this.symbol = symbol;
        this.width = width;
        this.pt = pt;
    }

    public String getSymbolString() {
        return "-S" + this.symbol.val() + this.width + "i";
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public Point2D getPoint() {
        return this.pt;
    }

    public void setPoint(Point2D pt) {
        this.pt = pt;
    }

    public static enum Symbol {
        SQUARE("s"),
        DIAMOND("d"),
        CIRCLE("c"),
        STAR("a"),
        OCTAGON("g"),
        HEXAGON("h"),
        INVERTED_TRIANGLE("i"),
        PENTAGON("n"),
        CROSS("x"),
        Y_DASH("y");

        private String val;

        private Symbol(String val) {
            this.val = val;
        }

        public String val() {
            return this.val;
        }
    }
}

