/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt.topo;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.primitives.Shorts;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.opensha.commons.geo.GeoTools;

public class NED_Convert {
    private static final short buffer = 6;

    public static void main(String[] args) throws ZipException, IOException {
        int arcSecs;
        double input_res = GeoTools.secondsToDeg(1.0);
        short in_rows = 3612;
        short in_cols = 3612;
        if (args.length == 1) {
            arcSecs = Integer.parseInt(args[0]);
        } else {
            if (args.length > 1) {
                throw new IllegalArgumentException("too many arguments!");
            }
            arcSecs = 3;
        }
        double output_res = GeoTools.secondsToDeg(arcSecs);
        File inputDir = new File("/home/scec-01/opensha/ned_usa/1sec_tiles");
        double regMinLat = 20.0;
        double regMaxLat = 52.0;
        double regMinLon = -128.0;
        double regMaxLon = -60.0;
        File outputFile = new File("/home/scec-01/opensha/ned_usa/us_dem_" + arcSecs + "sec.flt");
        long out_rows = (long)((regMaxLat - regMinLat) / output_res + 1.5);
        long out_cols = (long)((regMaxLon - regMinLon) / output_res + 1.5);
        long outputSize = out_rows * out_cols;
        int numBits = 4;
        long outputSizeBits = outputSize * (long)numBits;
        System.out.println("output size: " + out_rows + " x " + out_cols + " = " + outputSize);
        System.out.println("output bits: " + outputSizeBits);
        int maxSingleBuffer = (int)Math.pow(2.0, 30.0);
        System.out.println("max buffer size: " + maxSingleBuffer);
        System.out.println("multi buffers? " + (outputSizeBits > (long)maxSingleBuffer));
        Preconditions.checkState((maxSingleBuffer < Integer.MAX_VALUE ? 1 : 0) != 0);
        HashMap filesMap = Maps.newHashMap();
        System.out.println("Mapping output indexes to files.");
        int i = 0;
        double lat = regMinLat;
        while ((float)lat <= (float)regMaxLat) {
            int j = 0;
            FileIndex prevFile = null;
            int startJ = -1;
            short fileI = -1;
            ArrayList fileJs = Lists.newArrayList();
            double lon = regMinLon;
            while ((float)lon <= (float)regMaxLon) {
                short[] locInFile;
                FileIndex fileCoords = NED_Convert.getFileForLoc(lat, lon);
                if (!filesMap.containsKey(fileCoords)) {
                    filesMap.put(fileCoords, new ArrayList());
                }
                Preconditions.checkState(((locInFile = NED_Convert.getLocInFile(lat, lon, input_res))[0] < in_rows ? 1 : 0) != 0);
                Preconditions.checkState((locInFile[1] < in_cols ? 1 : 0) != 0);
                if (!fileCoords.equals(prevFile)) {
                    if (prevFile != null) {
                        Preconditions.checkState((j - 1 - startJ + 1 == fileJs.size() ? 1 : 0) != 0);
                        ((List)filesMap.get(prevFile)).add(new IndexedLoc(i, startJ, j - 1, fileI, Shorts.toArray((Collection)fileJs)));
                    }
                    prevFile = fileCoords;
                    startJ = j;
                    fileJs = Lists.newArrayList();
                    fileI = locInFile[0];
                } else {
                    Preconditions.checkState((fileI == locInFile[0] ? 1 : 0) != 0, (Object)("? " + fileI + " != " + locInFile[0]));
                }
                fileJs.add(locInFile[1]);
                ++j;
                lon += output_res;
            }
            Preconditions.checkState((startJ >= 0 ? 1 : 0) != 0);
            Preconditions.checkState((out_cols - 1L - (long)startJ + 1L == (long)fileJs.size() ? 1 : 0) != 0, (Object)("huh? out_cols=" + out_cols + ", j=" + j + ", startJ=" + startJ + ", fileJs.length=" + fileJs.size()));
            ((List)filesMap.get(prevFile)).add(new IndexedLoc(i, startJ, (int)out_cols - 1, fileI, Shorts.toArray((Collection)fileJs)));
            ++i;
            lat += output_res;
        }
        System.out.println("Writing file by file.");
        RandomAccessFile raOut = new RandomAccessFile(outputFile, "rw");
        long curSize = 0L;
        ArrayList outBufs = Lists.newArrayList();
        ArrayList outEnds = Lists.newArrayList();
        while (curSize < outputSizeBits) {
            long prevSize = curSize;
            if ((curSize += (long)maxSingleBuffer) > outputSizeBits) {
                curSize = outputSizeBits;
            }
            long subLen = curSize - prevSize;
            System.out.println("Mapping at " + prevSize + " of size " + subLen);
            outBufs.add(raOut.getChannel().map(FileChannel.MapMode.READ_WRITE, prevSize, subLen));
            outEnds.add(curSize);
        }
        for (FileIndex fileIndices : filesMap.keySet()) {
            float[][] fileVals = NED_Convert.loadFile(inputDir, fileIndices, in_rows, in_cols);
            for (IndexedLoc loc : (List)filesMap.get(fileIndices)) {
                long index = (long)numBits * ((long)loc.i * out_cols + (long)loc.jStart);
                int len = 1 + loc.jEnd - loc.jStart;
                short fileI = loc.fileI;
                short[] fileJs = loc.fileJs;
                Preconditions.checkState((fileJs.length == len ? 1 : 0) != 0, (Object)("fileJ lengh wrong. fileJs.lengh = " + fileJs.length + ", len=" + len + ", jStart=" + loc.jStart + ", jEnd=" + loc.jEnd));
                for (short fileJ : fileJs) {
                    Preconditions.checkState((index <= outputSizeBits ? 1 : 0) != 0, (Object)("file overrun: " + index + " > " + outputSizeBits));
                    long prevEnd = 0L;
                    int relativeIndex = -1;
                    ByteBuffer outBuf = null;
                    for (int b = 0; b < outBufs.size(); ++b) {
                        long end = (Long)outEnds.get(b);
                        if (index < end) {
                            relativeIndex = (int)(index - prevEnd);
                            outBuf = (MappedByteBuffer)outBufs.get(b);
                            break;
                        }
                        prevEnd = end;
                    }
                    outBuf.putFloat(relativeIndex, fileVals[fileI][fileJ]);
                    index += (long)numBits;
                }
            }
        }
        for (MappedByteBuffer outBuf : outBufs) {
            outBuf.force();
        }
        raOut.close();
    }

    private static void runTests(double input_res) {
        System.out.println("*** Lat Tests ***");
        NED_Convert.test(36.0, -120.0, input_res);
        NED_Convert.test(36.0 - input_res, -120.0, input_res);
        NED_Convert.test(36.0 - 2.0 * input_res, -120.0, input_res);
        NED_Convert.test(36.0 - 3.0 * input_res, -120.0, input_res);
        System.out.println("*** Lon Tests ***");
        NED_Convert.test(36.0, -120.0, input_res);
        NED_Convert.test(36.0, -120.0 + input_res, input_res);
        NED_Convert.test(36.0, -120.0 + 2.0 * input_res, input_res);
        NED_Convert.test(36.0, -120.0 + 3.0 * input_res, input_res);
    }

    private static void test(double lat, double lon, double input_res) {
        System.out.println("file for " + lat + ", " + lon + ": " + String.valueOf(NED_Convert.getFileForLoc(lat, lon)));
        System.out.println("loc in file for " + lat + ", " + lon + ": " + NED_Convert.getShortArrayStr(NED_Convert.getLocInFile(lat, lon, input_res)));
    }

    private static String getShortArrayStr(short[] array) {
        return "[" + array[0] + ", " + array[1] + "]";
    }

    private static short[] getLocInFile(double lat, double lon, double input_res) {
        lat = lat == Math.floor(lat) ? 0.0 : 1.0 - (lat - Math.floor(lat));
        Preconditions.checkState((lat >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkState((lat <= 1.0 ? 1 : 0) != 0);
        lon = Math.abs(lon);
        lon = 1.0 - (lon - Math.floor(lon));
        Preconditions.checkState((lon >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkState((lat <= 1.0 ? 1 : 0) != 0);
        double latIndex = lat / input_res;
        double lonIndex = lon / input_res;
        short i = (short)((short)Math.round(latIndex) + 6);
        short j = (short)((short)Math.round(lonIndex) + 6);
        return new short[]{i, j};
    }

    private static FileIndex getFileForLoc(double lat, double lon) {
        return new FileIndex((short)Math.ceil(lat), (short)Math.ceil(Math.abs(lon)));
    }

    private static float[][] loadFile(File dir, FileIndex indexes, short rows, short cols) throws ZipException, IOException {
        String jStr = "" + indexes.j;
        if (indexes.j < 100) {
            jStr = "0" + jStr;
        }
        String regName = "n" + indexes.i + "w" + jStr;
        float[][] ret = new float[rows][cols];
        File zipFile = new File(dir, regName + ".zip");
        if (!zipFile.exists()) {
            System.out.println("Zip file '" + zipFile.getAbsolutePath() + "' doesn't exist, skipping");
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    ret[i][j] = Float.NaN;
                }
            }
            return ret;
        }
        ZipFile zip = new ZipFile(zipFile);
        String entryName = regName + "/float" + regName + "_1.flt";
        System.out.println("Reading " + entryName + " from " + zipFile.getAbsolutePath());
        ZipEntry entry = zip.getEntry(entryName);
        InputStream is = zip.getInputStream(entry);
        LittleEndianDataInputStream dis = new LittleEndianDataInputStream((InputStream)new BufferedInputStream(is));
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < rows; ++j) {
                float val = dis.readFloat();
                if (val == -9999.0f) {
                    val = Float.NaN;
                }
                ret[i][j] = val;
            }
        }
        dis.close();
        return ret;
    }

    private static class FileIndex {
        short i;
        short j;

        public FileIndex(short i, short j) {
            this.i = i;
            this.j = j;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.i;
            result = 31 * result + this.j;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileIndex other = (FileIndex)obj;
            if (this.i != other.i) {
                return false;
            }
            return this.j == other.j;
        }

        public String toString() {
            return "[" + this.i + "," + this.j + "]";
        }
    }

    private static class IndexedLoc {
        int i;
        int jStart;
        int jEnd;
        short fileI;
        short[] fileJs;

        public IndexedLoc(int i, int jStart, int jEnd, short fileI, short[] fileJs) {
            this.i = i;
            this.jStart = jStart;
            this.jEnd = jEnd;
            this.fileI = fileI;
            this.fileJs = fileJs;
        }
    }
}

