/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.servlet;

import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.mapping.servlet.GMT_MapGeneratorServlet;
import org.opensha.commons.util.RunScript;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.cybershake.maps.GMT_InterpolationSettings;

public class GME_InterpolationServlet
extends HttpServlet {
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "GME_InterpolationServlet";
    private static final boolean D = true;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            if (!GMT_MapGeneratorServlet.GMT_DATA_DIR.exists()) {
                GMT_MapGeneratorServlet.GMT_DATA_DIR.mkdir();
            }
            Preconditions.checkState((boolean)GMT_MapGeneratorServlet.GMT_DATA_DIR.exists());
            ObjectInputStream inputFromApplet = new ObjectInputStream((InputStream)request.getInputStream());
            GeoDataSet scatterData = (GeoDataSet)inputFromApplet.readObject();
            Region region = (Region)inputFromApplet.readObject();
            GMT_InterpolationSettings interpSettings = (GMT_InterpolationSettings)inputFromApplet.readObject();
            GriddedGeoDataSet ret = GME_InterpolationServlet.doInterpolate(scatterData, region, interpSettings);
            outputToApplet.writeObject(ret);
            outputToApplet.close();
        }
        catch (Throwable t) {
            outputToApplet.writeObject(new RuntimeException(t));
            outputToApplet.close();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private static GriddedGeoDataSet doInterpolate(GeoDataSet scatterData, Region region, GMT_InterpolationSettings interpSettings) throws IOException {
        File outputDir = GMT_MapGeneratorServlet.createUniqueDir(GMT_MapGeneratorServlet.GMT_DATA_DIR);
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        String xyzName = "scatter.txt";
        scatterData.setLatitudeX(true);
        ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)scatterData, new File(outputDir, xyzName));
        double minLat = region.getMinLat();
        double maxTempLat = region.getMaxLat();
        double minLon = region.getMinLon();
        double maxTempLon = region.getMaxLon();
        double gridSpacing = interpSettings.getInterpSpacing();
        double maxLat = Math.rint((maxTempLat - minLat) / gridSpacing) * gridSpacing + minLat;
        double maxLon = Math.rint((maxTempLon - minLon) / gridSpacing) * gridSpacing + minLon;
        String regionStr = " -R" + (float)minLon + "/" + (float)maxLon + "/" + (float)minLat + "/" + (float)maxLat + " ";
        File gmtScriptFile = new File(outputDir, "gmtScript.sh");
        ArrayList<Object> gmtScript = new ArrayList<Object>();
        gmtScript.add("#!/bin/bash");
        gmtScript.add("");
        gmtScript.add("cd " + outputDir.getAbsolutePath());
        gmtScript.add("");
        gmtScript.addAll(GMT_MapGenerator.getGMTPathEnvLines());
        String grdFileName = "interpolated.grd";
        String interpFileName = "interpolated.txt";
        gmtScript.add("## Interpolation Script ##");
        gmtScript.add("");
        gmtScript.add("# do GMT interpolation on the scatter data");
        String commandLine = "${GMT_PATH}surface " + xyzName + " -G" + grdFileName + " -I" + gridSpacing + regionStr + interpSettings.getConvergenceArg() + " " + interpSettings.getSearchArg() + " " + interpSettings.getTensionArg() + " -: -H0";
        gmtScript.add(commandLine);
        gmtScript.add("# write interpolated XYZ file");
        commandLine = "${GMT_PATH}grd2xyz " + grdFileName + " > " + interpFileName;
        gmtScript.add(commandLine);
        FileWriter fw = new FileWriter(gmtScriptFile);
        BufferedWriter bw = new BufferedWriter(fw);
        int size = gmtScript.size();
        for (int i = 0; i < size; ++i) {
            bw.write((String)gmtScript.get(i) + "\n");
        }
        bw.close();
        System.out.println("Running command GMT for map: " + outputDir.getAbsolutePath());
        String[] command = new String[]{"sh", "-c", "/bin/bash " + String.valueOf(gmtScriptFile)};
        RunScript.runScript(command);
        File interpFile = new File(outputDir, interpFileName);
        System.out.println("DONE, loading map from " + interpFile.getAbsolutePath());
        Preconditions.checkState((boolean)interpFile.exists(), (String)"Interpolated file doesn't exist? %s", (Object)interpFile.getAbsoluteFile());
        return GriddedGeoDataSet.loadXYZFile(interpFile, false);
    }

    public static GriddedGeoDataSet interpolate(GeoDataSet scatterData, Region region, double gridSpacing) {
        GMT_InterpolationSettings interpSettings = GMT_InterpolationSettings.getDefaultSettings();
        interpSettings.setInterpSpacing(gridSpacing);
        return GME_InterpolationServlet.interpolate(scatterData, region, interpSettings);
    }

    public static GriddedGeoDataSet interpolate(GeoDataSet scatterData, Region region, GMT_InterpolationSettings interpSettings) {
        GriddedGeoDataSet ret = null;
        try {
            System.out.println("starting to make connection with servlet");
            URL gmtMapServlet = new URL(SERVLET_URL);
            URLConnection servletConnection = gmtMapServlet.openConnection();
            System.out.println("connection established");
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject(scatterData);
            outputToServlet.writeObject(region);
            outputToServlet.writeObject(interpSettings);
            outputToServlet.flush();
            outputToServlet.close();
            ObjectInputStream inputToServlet = new ObjectInputStream(servletConnection.getInputStream());
            Object messageFromServlet = inputToServlet.readObject();
            inputToServlet.close();
            if (!(messageFromServlet instanceof GriddedGeoDataSet)) {
                throw (RuntimeException)messageFromServlet;
            }
            ret = (GriddedGeoDataSet)messageFromServlet;
            System.out.println("Receiving the Input from the Servlet: " + ret.size() + " points");
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Server is down, please try again later. If the problem persists, make sure you are using the latest version of our applications.");
        }
        return ret;
    }

    public static void main(String[] args) {
        Region region = new Region(new Location(34.0, -118.0), new Location(36.0, -120.0));
        double minLat = region.getMinLat();
        double latSpan = region.getMaxLat() - minLat;
        double minLon = region.getMinLon();
        double lonSpan = region.getMaxLon() - minLon;
        int numScatter = 15;
        ArbDiscrGeoDataSet scatterData = new ArbDiscrGeoDataSet(false);
        for (int i = 0; i < numScatter; ++i) {
            double lat = minLat + Math.random() * latSpan;
            double lon = minLon + Math.random() * lonSpan;
            Location loc = new Location(lat, lon);
            double val = Math.random();
            System.out.println("Location " + i + ": " + String.valueOf(loc) + " = " + val);
            scatterData.set(loc, val);
        }
        System.out.println("Interpolated:");
        GriddedGeoDataSet interp = GME_InterpolationServlet.interpolate((GeoDataSet)scatterData, region, 0.2);
        for (int i = 0; i < interp.size(); ++i) {
            System.out.println(String.valueOf(interp.getLocation(i)) + " =\t" + interp.get(i));
        }
    }
}

