/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.servlet;

import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.SystemUtils;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.mapping.gmt.GMT_Map;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.mapping.gmt.SecureMapGenerator;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.RunScript;
import org.opensha.commons.util.ServerPrefUtils;

public class GMT_MapGeneratorServlet
extends HttpServlet {
    public static final String GMT_URL_PATH = "https://" + ServerPrefUtils.SERVER_PREFS.getHostName() + "/gmtData/";
    public static final File GMT_DATA_DIR = new File(ServerPrefUtils.SERVER_PREFS.getTempDir(), "gmtData");
    private static final String GMT_SCRIPT_FILE = "gmtScript.txt";
    private GMT_MapGenerator gmt = new GMT_MapGenerator();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            if (!GMT_DATA_DIR.exists()) {
                GMT_DATA_DIR.mkdir();
            }
            Preconditions.checkState((boolean)GMT_DATA_DIR.exists());
            ObjectInputStream inputFromApplet = new ObjectInputStream((InputStream)request.getInputStream());
            String dirName = (String)inputFromApplet.readObject();
            GMT_Map map = (GMT_Map)inputFromApplet.readObject();
            String metadata = (String)inputFromApplet.readObject();
            String metadataFileName = (String)inputFromApplet.readObject();
            String mapImagePath = GMT_MapGeneratorServlet.createMap(this.gmt, map, dirName, metadata, metadataFileName);
            outputToApplet.writeObject(mapImagePath);
            outputToApplet.close();
        }
        catch (Throwable t) {
            outputToApplet.writeObject(new RuntimeException(t));
            outputToApplet.close();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private static File getPlotDir(String plotDirName) {
        if (plotDirName != null) {
            File f = new File(GMT_DATA_DIR, plotDirName);
            int fileCounter = 1;
            Object modPlotDirName = plotDirName;
            while (f.exists()) {
                modPlotDirName = plotDirName + "_" + fileCounter;
                f = new File(GMT_DATA_DIR, (String)modPlotDirName);
                ++fileCounter;
            }
            return f;
        }
        return GMT_MapGeneratorServlet.createUniqueDir(GMT_DATA_DIR);
    }

    public static synchronized File createUniqueDir(File parentDir) {
        int count = 0;
        long millis = System.currentTimeMillis();
        File newDir = new File(parentDir, "" + millis);
        while (newDir.exists()) {
            newDir = new File(parentDir, millis + "_" + ++count);
        }
        Preconditions.checkState((!newDir.exists() ? 1 : 0) != 0, (String)"new dir is supposed to be unique but already exists: %s", (Object)newDir.getAbsoluteFile());
        Preconditions.checkState((boolean)newDir.mkdir(), (String)"cannot create unique map dir: %s", (Object)newDir.getAbsoluteFile());
        return newDir;
    }

    public static String createMap(SecureMapGenerator gmt, GMT_Map map, String plotDirName, String metadata, String metadataFileName) throws IOException, GMT_MapException {
        File newDir = GMT_MapGeneratorServlet.getPlotDir(plotDirName);
        plotDirName = newDir.getName();
        Preconditions.checkState((newDir.exists() || newDir.mkdir() ? 1 : 0) != 0);
        File gmtScriptFile = new File(newDir, GMT_SCRIPT_FILE);
        ArrayList<String> gmtMapScript = gmt.getGMT_ScriptLines(map, newDir.getAbsolutePath());
        System.out.println("Writing file and data for map: " + plotDirName);
        FileWriter fw = new FileWriter(gmtScriptFile);
        BufferedWriter bw = new BufferedWriter(fw);
        int size = gmtMapScript.size();
        for (int i = 0; i < size; ++i) {
            bw.write(gmtMapScript.get(i) + "\n");
        }
        bw.close();
        String metadataFile = String.valueOf(newDir) + "/" + new File(metadataFileName).getName();
        fw = new FileWriter(metadataFile);
        bw = new BufferedWriter(fw);
        bw.write(" " + metadata + "\n");
        bw.close();
        if (map.getGriddedData() != null) {
            GeoDataSet griddedData = map.getGriddedData();
            griddedData.setLatitudeX(true);
            ArbDiscrGeoDataSet.writeXYZFile((XYZ_DataSet)griddedData, String.valueOf(newDir) + "/" + new File(map.getXyzFileName()).getName());
        }
        System.out.println("Running command GMT for map: " + plotDirName);
        String[] command = new String[]{"sh", "-c", "/bin/bash " + String.valueOf(gmtScriptFile)};
        RunScript.runScript(command);
        System.out.println("Zipping results for map: " + plotDirName);
        FileUtils.createZipFile(newDir.getAbsolutePath());
        String mapImagePath = GMT_URL_PATH + plotDirName + SystemUtils.FILE_SEPARATOR;
        System.out.println("DONE. Map URL for '" + plotDirName + "': " + mapImagePath);
        return mapImagePath;
    }
}

