/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;

public abstract class AbstractParameter<E>
implements Parameter<E> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "Parameter";
    public static final String XML_GROUP_METADATA_NAME = "Parameters";
    public static final String XML_METADATA_NAME = "Parameter";
    public static final String XML_COMPLEX_VAL_EL_NAME = "ComplexValue";
    public static final String XML_NULL_VALUE = "(null)";
    protected static final boolean D = false;
    protected String name = "";
    protected String info = "";
    protected String units = "";
    protected ParameterConstraint constraint = null;
    protected boolean editable = true;
    protected E value;
    protected E defaultValue = null;
    private transient ArrayList<ParameterChangeListener> changeListeners;
    private transient ArrayList<ParameterChangeFailListener> failListeners;
    protected ArrayList<Parameter<?>> independentParameters = new ArrayList();
    protected String metadataString;

    protected AbstractParameter() {
    }

    protected void checkEditable(String S) throws EditableException {
        if (!this.editable) {
            throw new EditableException(S + "This parameter is currently not editable");
        }
    }

    public AbstractParameter(String name, ParameterConstraint constraint, String units, E value) throws ConstraintException {
        String S = "Parameter: Constructor(): ";
        if (value != null && constraint != null && !constraint.isAllowed(value)) {
            System.out.println(S + "Value not allowed");
            throw new ConstraintException(S + "Value not allowed: " + String.valueOf(value));
        }
        this.constraint = constraint;
        this.name = name;
        this.value = value;
        this.units = units;
    }

    @Override
    public boolean isAllowed(E obj) {
        if (obj == null && !this.isNullAllowed()) {
            return false;
        }
        if (this.constraint != null) {
            return this.constraint.isAllowed(obj);
        }
        return true;
    }

    @Override
    public void setValue(E value) throws ConstraintException, ParameterException {
        String S = this.getName() + ": setValue(): ";
        if (!this.isAllowed(value)) {
            throw new ConstraintException(S + "Value is not allowed: " + String.valueOf(value));
        }
        if (this.value != null && this.value.equals(value)) {
            return;
        }
        ParameterChangeEvent event = new ParameterChangeEvent(this, this.getName(), this.getValue(), value);
        this.value = value;
        this.firePropertyChange(event);
    }

    @Override
    public void setDefaultValue(E defaultValue) throws ConstraintException {
        this.checkEditable("Parameter: setDefaultValue(): ");
        if (!this.isAllowed(defaultValue)) {
            throw new ConstraintException(this.getName() + ": setDefaultValue(): Value is not allowed: " + defaultValue.toString());
        }
        this.defaultValue = defaultValue;
    }

    @Override
    public void setValueAsDefault() throws ConstraintException, ParameterException {
        this.setValue(this.defaultValue);
    }

    @Override
    public E getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void unableToSetValue(Object value) throws ConstraintException {
        ParameterChangeFailEvent event = new ParameterChangeFailEvent(this, this.getName(), this.getValue(), value);
        this.firePropertyChangeFailed(event);
    }

    @Override
    public synchronized void addParameterChangeFailListener(ParameterChangeFailListener listener) {
        if (this.failListeners == null) {
            this.failListeners = new ArrayList();
        }
        if (!this.failListeners.contains(listener)) {
            this.failListeners.add(listener);
        }
    }

    @Override
    public String getConstraintName() {
        if (this.constraint != null) {
            String name = this.constraint.getName();
            if (name == null) {
                return "";
            }
            return name;
        }
        return "";
    }

    @Override
    public synchronized void removeParameterChangeFailListener(ParameterChangeFailListener listener) {
        if (this.failListeners != null && this.failListeners.contains(listener)) {
            this.failListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void firePropertyChangeFailed(ParameterChangeFailEvent event) {
        String S = "Parameter: firePropertyChange(): ";
        AbstractParameter abstractParameter = this;
        synchronized (abstractParameter) {
            if (this.failListeners == null) {
                return;
            }
            ParameterChangeFailListener[] listeners = new ParameterChangeFailListener[this.failListeners.size()];
            this.failListeners.toArray(listeners);
        }
        for (ParameterChangeFailListener listener : this.failListeners) {
            listener.parameterChangeFailed(event);
        }
    }

    @Override
    public synchronized void addParameterChangeListener(ParameterChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeParameterChangeListener(ParameterChangeListener listener) {
        if (this.changeListeners != null && this.changeListeners.contains(listener)) {
            this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void firePropertyChange(ParameterChangeEvent event) {
        String S = "Parameter: firePropertyChange(): ";
        ParameterChangeListener[] parameterChangeListenerArray = this;
        synchronized (this) {
            if (this.changeListeners == null) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            ParameterChangeListener[] listeners = new ParameterChangeListener[this.changeListeners.size()];
            this.changeListeners.toArray(listeners);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (ParameterChangeListener listener : listeners) {
                listener.parameterChange(event);
            }
            return;
        }
    }

    @Override
    public boolean isNullAllowed() {
        if (this.constraint != null) {
            return this.constraint.isNullAllowed();
        }
        return true;
    }

    @Override
    public void setInfo(String info) throws EditableException {
        this.checkEditable("Parameter: setInfo(): ");
        this.info = info;
    }

    @Override
    public void setUnits(String units) throws EditableException {
        this.checkEditable("Parameter: setUnits(): ");
        this.units = units;
    }

    @Override
    public E getValue() {
        return this.value;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public ParameterConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    public void setConstraint(ParameterConstraint constraint) throws EditableException {
        this.checkEditable("Parameter: setConstraint(): ");
        this.constraint = constraint;
        E value = this.getValue();
        if (!constraint.isAllowed(value)) {
            constraint.setNullAllowed(true);
            this.setValue(null);
            constraint.setNullAllowed(false);
        }
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public void setNonEditable() {
        this.editable = false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.checkEditable("Parameter: setName(): ");
        this.name = name;
    }

    @Override
    public String getType() {
        return "Parameter";
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public String getMetadataString() {
        if (this.value != null) {
            return this.name + " = " + this.value.toString();
        }
        return this.name + " = null";
    }

    @Override
    public abstract Object clone();

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter p = (Parameter)obj;
        if (!this.getClass().equals(p.getClass())) {
            return false;
        }
        if (!this.name.equals(p.getName())) {
            return false;
        }
        if (this.value == null) {
            return p.getValue() == null;
        }
        return this.value.equals(p.getValue());
    }

    @Override
    public int compareTo(Parameter<?> param) {
        return this.getName().compareToIgnoreCase(param.getName());
    }

    @Override
    public Element toXMLMetadata(Element root) {
        return this.toXMLMetadata(root, "Parameter");
    }

    protected void valueToXML(Element paramEl) {
        E val = this.getValue();
        if (val instanceof XMLSaveable) {
            Element valEl = paramEl.addElement(XML_COMPLEX_VAL_EL_NAME);
            ((XMLSaveable)val).toXMLMetadata(valEl);
        } else {
            paramEl.addAttribute("value", val.toString());
        }
    }

    @Override
    public Element toXMLMetadata(Element root, String elementName) {
        AbstractParameter param;
        int num;
        Element xml = root.addElement(elementName);
        xml.addAttribute("name", this.getName());
        xml.addAttribute("type", this.getType());
        xml.addAttribute("units", this.getUnits());
        if (this.getValue() == null) {
            xml.addAttribute("value", XML_NULL_VALUE);
        } else {
            this.valueToXML(xml);
        }
        if (this instanceof Parameter && (num = (param = this).getNumIndependentParameters()) > 0) {
            Element dependent = xml.addElement("IndependentParameters");
            for (Parameter<?> depParam : param.getIndependentParameterList()) {
                dependent = depParam.toXMLMetadata(dependent);
            }
        }
        return root;
    }

    protected abstract boolean setIndividualParamValueFromXML(Element var1);

    @Override
    public final boolean setValueFromXMLMetadata(Element el) {
        boolean setToNull = false;
        boolean success = true;
        Attribute valueAtt = el.attribute("value");
        if (valueAtt != null && valueAtt.getStringValue().equals(XML_NULL_VALUE)) {
            try {
                this.setValue(null);
                setToNull = true;
            }
            catch (ConstraintException e) {
                success = false;
            }
            catch (ParameterException e) {
                success = false;
            }
        }
        if (!setToNull && success) {
            success = this.setIndividualParamValueFromXML(el);
        }
        boolean indepsuccess = this.setIndepParamsFromXML(el);
        if (success) {
            success = indepsuccess;
        }
        return success;
    }

    @Override
    public Parameter getIndependentParameter(String name) throws ParameterException {
        int index = this.getIndexOf(name);
        if (index != -1) {
            Parameter<?> param = this.independentParameters.get(index);
            return param;
        }
        String S = "Parameter: getParameter(): ";
        throw new ParameterException(S + "No parameter exists named " + name);
    }

    private int getIndexOf(String paramName) {
        int size = this.independentParameters.size();
        for (int i = 0; i < size; ++i) {
            if (!this.independentParameters.get(i).getName().equals(paramName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getIndependentParametersKey() {
        StringBuffer key = new StringBuffer(this.name);
        Iterator<Parameter<?>> it = this.independentParameters.iterator();
        while (it.hasNext()) {
            Object value = it.next().getValue();
            if (value == null) continue;
            key.append('/');
            key.append(value.toString());
        }
        return key.toString();
    }

    @Override
    public boolean containsIndependentParameter(String paramName) {
        int index = this.getIndexOf(paramName);
        return index != -1;
    }

    @Override
    public void setIndependentParameters(ParameterList list) throws ParameterException, EditableException {
        String S = "Parameter: setIndependentParameters(): ";
        this.checkEditable(S);
        this.independentParameters.clear();
        if (list != null) {
            ListIterator<Parameter<?>> it = list.getParametersIterator();
            while (it.hasNext()) {
                Parameter<?> param = it.next();
                this.independentParameters.add(param);
            }
        }
    }

    @Override
    public String getDependentParamMetadataString() {
        if (this.independentParameters.size() > 0) {
            StringBuffer metadata = new StringBuffer();
            metadata.append(this.getName() + " [ ");
            for (Parameter<?> tempParam : this.getIndependentParameterList()) {
                metadata.append(tempParam.getMetadataString() + " ; ");
            }
            metadata.replace(metadata.length() - 2, metadata.length(), " ]");
            this.metadataString = metadata.toString();
        }
        return this.metadataString;
    }

    public void setDependentParamMetadataString(String dependentParamMedataString) {
        this.metadataString = dependentParamMedataString;
    }

    @Override
    public void addIndependentParameter(Parameter parameter) throws ParameterException, EditableException {
        String S = "Parameter: addIndependentParameter(): ";
        this.checkEditable(S);
        String name = parameter.getName();
        int index = this.getIndexOf(name);
        if (index != -1) {
            throw new ParameterException(S + "A Parameter already exists named " + name);
        }
        this.independentParameters.add(parameter);
    }

    @Override
    public void removeIndependentParameter(String name) throws ParameterException, EditableException {
        String S = "Parameter: removeIndependentParameter(): ";
        this.checkEditable(S);
        int index = this.getIndexOf(name);
        if (index == -1) {
            throw new ParameterException(S + "No Parameter exist named " + name + ", unable to remove");
        }
        this.independentParameters.remove(index);
    }

    @Override
    public ParameterList getIndependentParameterList() {
        ParameterList params = new ParameterList();
        for (Parameter<?> param : this.independentParameters) {
            params.addParameter(param);
        }
        return params;
    }

    @Override
    public int getNumIndependentParameters() {
        return this.independentParameters.size();
    }

    protected final boolean setIndepParamsFromXML(Element el) {
        Element depParamsEl = el.element("IndependentParameters");
        if (depParamsEl == null) {
            return true;
        }
        boolean success = true;
        Iterator it = depParamsEl.elementIterator();
        while (it.hasNext()) {
            Element paramEl = (Element)it.next();
            String name = paramEl.attribute("name").getValue();
            try {
                Parameter param = this.getIndependentParameter(name);
                boolean newSuccess = param.setValueFromXMLMetadata(paramEl);
                if (newSuccess) continue;
                success = false;
            }
            catch (ParameterException e) {
                System.err.println("Parameter '" + this.getName() + "' doesn't have an independent parameter named '" + name + "', and cannot be set from XML");
            }
        }
        return success;
    }
}

