/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;

public class ParamLinker<E>
implements ParameterChangeListener {
    private static final boolean D = false;
    private Parameter<E> parentParam;
    private Parameter<E> childParam;
    private WarningParameter<E> warnChild = null;
    private boolean throwExceptions = true;

    public ParamLinker(Parameter<E> parentParam, Parameter<E> childParam) {
        this(parentParam, childParam, true);
    }

    public ParamLinker(Parameter<E> parentParam, Parameter<E> childParam, boolean throwExceptions) {
        this.parentParam = parentParam;
        this.childParam = childParam;
        this.throwExceptions = throwExceptions;
        if (childParam instanceof WarningParameter) {
            this.warnChild = (WarningParameter)childParam;
        }
        E parentVal = parentParam.getValue();
        E childVal = childParam.getValue();
        if (parentVal == null || !parentVal.equals(childVal)) {
            this.setChildVal(parentVal);
        }
        parentParam.addParameterChangeListener(this);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.setChildVal(event.getNewValue());
    }

    private void setChildVal(E value) {
        block6: {
            try {
                if (this.warnChild != null) {
                    this.warnChild.setValueIgnoreWarning(value);
                } else {
                    this.childParam.setValue(value);
                }
            }
            catch (ConstraintException e) {
                System.err.println("WARNING: child parameter '" + this.childParam.getName() + "' could not be set to '" + String.valueOf(value) + "'");
                if (this.throwExceptions) {
                    throw e;
                }
            }
            catch (ParameterException e) {
                System.err.println("WARNING: child parameter '" + this.childParam.getName() + "' could not be set to '" + String.valueOf(value) + "'");
                if (!this.throwExceptions) break block6;
                throw e;
            }
        }
    }
}

