/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.constraint.impl;

import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.param.constraint.AbstractParameterConstraint;

public class DoubleConstraint
extends AbstractParameterConstraint<Double> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "DoubleConstraint";
    protected static final boolean D = false;
    protected double min;
    protected double max;
    protected boolean hasMin;
    protected boolean hasMax;

    public DoubleConstraint() {
        this.hasMin = false;
        this.hasMax = false;
    }

    public DoubleConstraint(double min, double max) {
        this.setMinMax(min, max);
    }

    public DoubleConstraint(Double min, Double max) {
        this.setMinMax(min, max);
    }

    public void setMinMax(double min, double max) throws EditableException {
        String S = "DoubleConstraint: setMinMax(double, double): ";
        this.checkEditable(S);
        this.min = min;
        this.max = max;
        this.hasMin = Double.isFinite(min) || min < 0.0;
        this.hasMax = Double.isFinite(max) || max > 0.0;
    }

    public void setMinMax(Double min, Double max) throws EditableException {
        String S = "DoubleConstraint: setMinMax(Double, Double): ";
        this.checkEditable(S);
        double mind = min == null ? Double.NaN : min;
        double maxd = max == null ? Double.NaN : max;
        this.setMinMax(mind, maxd);
    }

    public Double getMin() {
        return this.hasMin ? Double.valueOf(this.min) : null;
    }

    public Double getMax() {
        return this.hasMax ? Double.valueOf(this.max) : null;
    }

    @Override
    public boolean isAllowed(Double d) {
        if (d == null) {
            return this.nullAllowed;
        }
        double dv = d;
        return !(this.hasMin && dv < this.min) && (!this.hasMax || !(dv > this.max));
    }

    @Override
    public boolean isAllowed(double d) {
        return this.isAllowed((Double)d);
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        if (this.name != null) {
            b.append(TAB + "Name = " + this.name + "\n");
        }
        if (this.hasMin) {
            b.append(TAB + "Min = " + this.min + "\n");
        }
        if (this.hasMax) {
            b.append(TAB + "Max = " + this.max + "\n");
        }
        b.append(TAB + "Null Allowed = " + this.nullAllowed + "\n");
        return b.toString();
    }

    @Override
    public Object clone() {
        DoubleConstraint c1 = new DoubleConstraint(this.min, this.max);
        c1.setName(this.name);
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }
}

