/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.constraint.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.param.constraint.AbstractParameterConstraint;
import org.opensha.commons.param.constraint.DiscreteParameterConstraint;

public class EnumConstraint<E extends Enum<E>>
extends AbstractParameterConstraint<E>
implements DiscreteParameterConstraint<E> {
    private List<E> values;

    public EnumConstraint(EnumSet<E> values, boolean allowsNull) {
        Preconditions.checkNotNull(values, (Object)"Supplied value set is null");
        Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (Object)"Supplied value set is empty");
        this.setNullAllowed(allowsNull);
        this.values = Collections.unmodifiableList(Lists.newArrayList(values));
    }

    @Override
    public boolean isAllowed(E value) {
        return value == null && this.isNullAllowed() ? true : this.values.contains(value);
    }

    @Override
    public List<E> getAllowedValues() {
        return this.values;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.values.listIterator();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Object clone() {
        return new EnumConstraint<E>(EnumSet.copyOf(this.values), this.isNullAllowed());
    }
}

