/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor;

import javax.swing.JComponent;
import javax.swing.border.Border;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;

public abstract class AbstractParameterEditorConverter<E, F>
implements ParameterEditor<E>,
ParameterChangeListener {
    private Parameter<E> nativeParam;
    private Parameter<F> convertedParam;
    private ParameterEditor<F> editor;

    public AbstractParameterEditorConverter() {
        this(null);
    }

    public AbstractParameterEditorConverter(Parameter<E> nativeParam) {
        this.setParameter(nativeParam);
    }

    protected abstract Parameter<F> buildParameter(Parameter<E> var1);

    protected abstract F convertFromNative(E var1);

    protected abstract E convertToNative(F var1);

    @Override
    public void setValue(E object) {
        this.nativeParam.setValue(object);
        this.editor.setValue(this.convertFromNative(object));
    }

    @Override
    public E getValue() {
        return this.nativeParam.getValue();
    }

    @Override
    public void unableToSetValue(Object object) {
        this.editor.unableToSetValue(object);
    }

    @Override
    public void refreshParamEditor() {
        this.editor.refreshParamEditor();
    }

    @Override
    public Parameter<E> getParameter() {
        return this.nativeParam;
    }

    @Override
    public void setParameter(Parameter<E> model) {
        if (model == null) {
            this.nativeParam = null;
            this.convertedParam = null;
            this.editor = null;
        } else {
            this.nativeParam = model;
            this.convertedParam = this.buildParameter(model);
            this.convertedParam.addParameterChangeListener(this);
            if (this.editor == null) {
                this.editor = this.convertedParam.getEditor();
            } else {
                this.editor.setParameter(this.convertedParam);
            }
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.convertedParam) {
            E nativeVal = this.convertToNative(this.convertedParam.getValue());
            this.nativeParam.setValue(nativeVal);
        }
    }

    @Override
    public void setFocusEnabled(boolean newFocusEnabled) {
        this.editor.setFocusEnabled(newFocusEnabled);
    }

    @Override
    public boolean isFocusEnabled() {
        return this.editor.isFocusEnabled();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.editor.setEnabled(isEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.editor.isEnabled();
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.editor.setVisible(isVisible);
    }

    @Override
    public boolean isVisible() {
        return this.editor.isVisible();
    }

    @Override
    public JComponent getComponent() {
        return this.editor.getComponent();
    }

    @Override
    public void setEditorBorder(Border b) {
        this.editor.setEditorBorder(b);
    }
}

