/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.editor.impl.ArbitrarilyDiscretizedFuncTableModel;
import org.opensha.commons.param.impl.ArbitrarilyDiscretizedFuncParameter;

public class ArbitrarilyDiscretizedFuncParameterEditor
extends AbstractParameterEditor<ArbitrarilyDiscretizedFunc>
implements ActionListener,
DocumentListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "DiscretizedFuncParameterEditor";
    protected static final boolean D = false;
    private ArbitrarilyDiscretizedFuncTableModel tableModel;
    private JTable table;
    private JButton addButton;
    private JButton removeButton;
    private JTextField xField;
    private JTextField yField;
    boolean xDataGood;
    boolean yDataGood;
    private boolean isFocusListenerForX = false;
    private ArbitrarilyDiscretizedFuncTableModel.ArbitrarilyDiscretizedFuncTableCellRenderer renderer;
    private JPanel widgetPanel;

    public ArbitrarilyDiscretizedFuncParameterEditor(Parameter<ArbitrarilyDiscretizedFunc> model) throws Exception {
        super(model);
    }

    public void setXEnabled(boolean isEnabled) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.table.setEnabled(isEnabled);
        this.tableModel.setEnabled(isEnabled);
        this.xField.setEnabled(isEnabled);
        this.yField.setEnabled(isEnabled);
        this.addButton.setEnabled(isEnabled);
        this.removeButton.setEnabled(isEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.table != null && this.table.isEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] selected;
        if (e.getSource() == this.addButton) {
            double x = Double.parseDouble(this.xField.getText());
            double y = Double.parseDouble(this.yField.getText());
            this.tableModel.addPoint(x, y);
        } else if (e.getSource() == this.removeButton && (selected = this.table.getSelectedRows()).length > 0) {
            this.tableModel.removePoints(selected);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateAddInput();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateAddInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateAddInput();
    }

    private void validateAddInput() {
        try {
            Double x = Double.parseDouble(this.xField.getText());
            Double y = Double.parseDouble(this.yField.getText());
            boolean bad = x.isNaN() || y.isNaN() || x.isInfinite() || y.isInfinite();
            this.addButton.setEnabled(!bad);
        }
        catch (NumberFormatException e1) {
            this.addButton.setEnabled(false);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.setValue(this.tableModel.getFunction().deepClone());
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame();
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(0.1, 5.5);
        func.set(0.2, 90.5);
        func.set(0.4, 2.5);
        func.set(0.8, 1.5);
        ArbitrarilyDiscretizedFuncParameter param = new ArbitrarilyDiscretizedFuncParameter("Param", func);
        ArbitrarilyDiscretizedFuncParameterEditor editor = new ArbitrarilyDiscretizedFuncParameterEditor(param);
        frame.setSize(500, 500);
        frame.setContentPane(editor);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        editor.validate();
        editor.refreshParamEditor();
    }

    @Override
    public boolean isParameterSupported(Parameter<ArbitrarilyDiscretizedFunc> param) {
        if (param == null) {
            return false;
        }
        return param.getValue() == null || param.getValue() instanceof ArbitrarilyDiscretizedFunc;
    }

    @Override
    protected JComponent buildWidget() {
        ArbitrarilyDiscretizedFunc function = (ArbitrarilyDiscretizedFunc)this.getValue();
        if (function == null) {
            function = new ArbitrarilyDiscretizedFunc();
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout(new BoxLayout(leftButtonPanel, 0));
        if (this.addButton == null) {
            this.addButton = new JButton("+");
            this.addButton.addActionListener(this);
            this.addButton.setEnabled(false);
        }
        if (this.removeButton == null) {
            this.removeButton = new JButton("-");
            this.removeButton.addActionListener(this);
        }
        if (this.xField == null) {
            this.xField = new JTextField();
            this.xField.getDocument().addDocumentListener(this);
            this.xField.setColumns(4);
            this.xDataGood = false;
        }
        if (this.yField == null) {
            this.yField = new JTextField();
            this.yField.getDocument().addDocumentListener(this);
            this.yField.setColumns(4);
            this.yDataGood = false;
        }
        leftButtonPanel.add(new JLabel("x: "));
        leftButtonPanel.add(this.xField);
        leftButtonPanel.add(new JLabel("y: "));
        leftButtonPanel.add(this.yField);
        leftButtonPanel.add(this.addButton);
        buttonPanel.add((Component)leftButtonPanel, "West");
        buttonPanel.add((Component)this.removeButton, "East");
        this.tableModel = new ArbitrarilyDiscretizedFuncTableModel(function);
        this.table = new JTable(this.tableModel);
        this.tableModel.addTableModelListener(this);
        this.renderer = this.tableModel.getRenderer();
        this.table.setDefaultRenderer(Double.class, this.renderer);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(100, 200));
        this.widgetPanel = new JPanel(new BorderLayout());
        this.widgetPanel.add((Component)scroll, "Center");
        this.widgetPanel.add((Component)buttonPanel, "South");
        this.widgetPanel.setBackground(null);
        this.widgetPanel.validate();
        this.widgetPanel.repaint();
        return this.widgetPanel;
    }

    @Override
    protected JComponent updateWidget() {
        ArbitrarilyDiscretizedFunc function = (ArbitrarilyDiscretizedFunc)this.getValue();
        if (function == null) {
            function = new ArbitrarilyDiscretizedFunc();
        }
        this.tableModel.updateData(function);
        this.widgetPanel.validate();
        this.widgetPanel.repaint();
        return this.widgetPanel;
    }
}

