/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;

public class ArbitrarilyDiscretizedFuncTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected boolean D = false;
    private ArbitrarilyDiscretizedFunc func;
    private boolean xEditable = true;
    public static DecimalFormat format = new DecimalFormat();
    public Color disabledBackgroundColor;
    public Color enabledBackgroundColor;
    ArbitrarilyDiscretizedFuncTableCellRenderer renderer = null;

    public ArbitrarilyDiscretizedFuncTableModel(ArbitrarilyDiscretizedFunc func) {
        this.func = func;
        Color defaultBackground = UIManager.getColor("Panel.background");
        double avgColor = (double)(defaultBackground.getRed() + defaultBackground.getGreen() + defaultBackground.getBlue()) / 3.0;
        if (avgColor > 127.0) {
            this.enabledBackgroundColor = Color.WHITE;
            this.disabledBackgroundColor = new Color(210, 210, 210);
        } else {
            this.enabledBackgroundColor = defaultBackground;
            this.disabledBackgroundColor = new Color(80, 80, 80);
        }
    }

    public void updateData(ArbitrarilyDiscretizedFunc newFunc) {
        if (!ArbitrarilyDiscretizedFuncTableModel.areFunctionPointsEqual(this.func, newFunc)) {
            if (this.D) {
                System.out.println("Update called with new data...");
                if (this.func == null) {
                    System.out.println("old func: null");
                } else if (this.func.size() == 0) {
                    System.out.println("old func: empty");
                } else {
                    System.out.println("Old First: " + this.func.getX(0) + ", " + this.func.getY(0));
                }
                if (newFunc == null) {
                    System.out.println("new func: null");
                } else if (newFunc.size() == 0) {
                    System.out.println("new func: empty");
                } else {
                    System.out.println("New First: " + newFunc.getX(0) + ", " + newFunc.getY(0));
                }
            }
            this.func.clear();
            for (int i = 0; i < newFunc.size(); ++i) {
                double x = newFunc.getX(i);
                double y = newFunc.getY(i);
                this.func.set(x, y);
            }
            if (this.D) {
                System.out.println("Update firing event");
            }
            this.fireTableDataChanged();
        } else if (this.D) {
            System.out.println("Update called with old data");
            if (this.func == null) {
                System.out.println("old func: null");
            } else if (this.func.size() == 0) {
                System.out.println("old func: empty");
            } else {
                System.out.println("Old First: " + this.func.getX(0) + ", " + this.func.getY(0));
            }
            if (newFunc == null) {
                System.out.println("new func: null");
            } else if (newFunc.size() == 0) {
                System.out.println("new func: empty");
            } else {
                System.out.println("New First: " + newFunc.getX(0) + ", " + newFunc.getY(0));
            }
        }
        if (this.D) {
            System.out.println("Update call DONE");
        }
    }

    public static boolean areFunctionPointsEqual(ArbitrarilyDiscretizedFunc func1, ArbitrarilyDiscretizedFunc func2) {
        if (func1 == null && func2 == null) {
            return true;
        }
        if (func1 == null || func2 == null) {
            return false;
        }
        int size = func1.size();
        if (size != func2.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            double x1 = func1.getX(i);
            double x2 = func2.getX(i);
            double y1 = func1.getY(i);
            double y2 = func2.getY(i);
            if (x1 == x2 && y1 == y2) continue;
            return false;
        }
        return true;
    }

    public ArbitrarilyDiscretizedFunc getFunction() {
        return this.func;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public void setXEditable(boolean xEditable) {
        this.xEditable = xEditable;
    }

    @Override
    public int getRowCount() {
        if (this.func == null) {
            if (this.D) {
                System.out.println("ROW COUNT ON NULL FUNC!");
            }
            return 0;
        }
        int rows = this.func.size();
        return rows;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            String name = this.func.getXAxisName();
            if (name == null || name.length() == 0) {
                name = "x";
            }
            return name;
        }
        String name = this.func.getYAxisName();
        if (name == null || name.length() == 0) {
            name = "y";
        }
        return name;
    }

    public void removePoint(int index) {
        int[] indexes = new int[]{index};
        this.doRemovePoints(indexes);
        this.fireTableDataChanged();
    }

    private void doRemovePoints(int[] indexes) {
        ArbitrarilyDiscretizedFunc old = this.func.deepClone();
        this.func.clear();
        for (int i = 0; i < old.size(); ++i) {
            boolean match = false;
            for (int j : indexes) {
                if (i != j) continue;
                if (this.D) {
                    System.out.println("Removing point: " + i);
                }
                match = true;
                break;
            }
            if (match) continue;
            this.func.set(old.get(i));
        }
    }

    public void removePoints(int[] indexes) {
        this.doRemovePoints(indexes);
        this.fireTableDataChanged();
    }

    public void addPoint(double x, double y) {
        this.func.set(x, y);
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        super.getColumnClass(c);
        return Double.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.func.getX(rowIndex);
        }
        return this.func.getY(rowIndex);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0 || this.xEditable;
    }

    public void setEnabled(boolean isEnabled) {
        ArbitrarilyDiscretizedFuncTableCellRenderer renderer = this.getRenderer();
        if (isEnabled) {
            renderer.setBackground(this.enabledBackgroundColor);
        } else {
            renderer.setBackground(this.disabledBackgroundColor);
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        double val = (Double)aValue;
        if (this.D) {
            System.out.println("Setting value at (" + rowIndex + "," + columnIndex + ") to: " + val);
        }
        if (columnIndex == 1) {
            this.func.set(rowIndex, val);
        } else {
            double origY = this.func.getY(rowIndex);
            int[] indexes = new int[]{rowIndex};
            this.doRemovePoints(indexes);
            this.func.set(val, origY);
        }
        this.fireTableDataChanged();
    }

    public ArbitrarilyDiscretizedFuncTableCellRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new ArbitrarilyDiscretizedFuncTableCellRenderer();
        }
        return this.renderer;
    }

    static {
        format.setMaximumFractionDigits(10);
    }

    class ArbitrarilyDiscretizedFuncTableCellRenderer
    extends DefaultTableCellRenderer.UIResource {
        public ArbitrarilyDiscretizedFuncTableCellRenderer() {
            this.setHorizontalAlignment(4);
            this.setPreferredSize(new Dimension(20, 8));
        }

        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : format.format(value));
        }
    }
}

