/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.Component;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.StringListConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditorOld;
import org.opensha.commons.param.impl.StringListParameter;

public class ConstrainedStringListParameterEditor
extends AbstractParameterEditorOld
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "ConstrainedStringListParameterEditor";
    protected static final boolean D = false;

    public ConstrainedStringListParameterEditor() {
        String S = "ConstrainedStringListParameterEditor: Constructor(): ";
    }

    public ConstrainedStringListParameterEditor(Parameter model) throws ConstraintException {
        super(model);
        String S = "ConstrainedStringListParameterEditor: Constructor(model): ";
    }

    @Override
    public void setParameter(Parameter model) {
        String S = "ConstrainedStringListParameterEditor: setParameter(): ";
        this.verifyModel(model);
        this.model = model;
        String name = model.getName();
        Object value = model.getValue();
        this.removeWidget();
        this.addWidget();
        this.setWidgetObject(name, value);
    }

    private void verifyModel(Parameter model) throws ConstraintException {
        String S = "ConstrainedStringListParameterEditor: Constructor(model): ";
        if (model == null) {
            throw new NullPointerException(S + "Input Parameter model cannot be null");
        }
        if (!(model instanceof StringListParameter)) {
            throw new ConstraintException(S + "Input model parameter must be a StringListParameter.");
        }
        ParameterConstraint constraint = model.getConstraint();
        if (!(constraint instanceof StringListConstraint)) {
            throw new ConstraintException(S + "Input model constraints must be a StringListConstraint.");
        }
        int numConstriants = ((StringListConstraint)constraint).size();
        if (numConstriants < 1) {
            throw new ConstraintException(S + "There are no constraints present, unable to build editor selection list.");
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    @Override
    protected void setWidgetObject(String name, Object obj) {
        String S = "ConstrainedStringListParameterEditor: setWidgetObject(): ";
        super.setWidgetObject(name, obj);
        if (obj != null && this.valueEditor != null && this.valueEditor instanceof JList) {
            this.setSelectedItems((ArrayList)obj);
        }
    }

    @Override
    protected void addWidget() {
        String S = "ConstrainedStringListParameterEditor: addWidget(): ";
        if (this.model != null) {
            StringListConstraint con = (StringListConstraint)((StringListParameter)this.model).getConstraint();
            ListIterator it = con.listIterator();
            Vector<String> strs = new Vector<String>();
            while (it.hasNext()) {
                String str = it.next().toString();
                if (strs.contains(str)) continue;
                strs.add(str);
            }
            this.valueEditor = new JList(strs);
            this.valueEditor.setFont(DEFAULT_FONT);
            JScrollPane scrollPane = new JScrollPane(this.valueEditor);
            scrollPane.setPreferredSize(JLIST_DIM);
            scrollPane.setMinimumSize(JLIST_DIM);
            this.widgetPanel.setPreferredSize(JLIST_DIM);
            this.widgetPanel.setMinimumSize(JLIST_DIM);
            ((JList)this.valueEditor).addListSelectionListener(this);
            this.widgetPanel.add((Component)scrollPane, WIDGET_GBC);
            this.widgetPanel.setBackground(null);
            this.widgetPanel.validate();
            this.widgetPanel.repaint();
        }
    }

    @Override
    public void refreshParamEditor() {
        ArrayList list;
        if (this.valueEditor instanceof JList && (list = (ArrayList)this.model.getValue()) != null) {
            this.setSelectedItems(list);
        }
    }

    private void setSelectedItems(ArrayList selectItemsList) {
        int size = selectItemsList.size();
        StringListConstraint stringListConstraint = (StringListConstraint)this.model.getConstraint();
        ArrayList allowedVals = stringListConstraint.getAllowedValues();
        int[] selectedIndices = new int[size];
        for (int i = 0; i < size; ++i) {
            int index = allowedVals.indexOf(selectItemsList.get(i));
            if (index >= 0) {
                selectedIndices[i] = index;
                continue;
            }
            new ConstraintException(selectItemsList.get(i).toString() + " is not allowed");
        }
        ((JList)this.valueEditor).setSelectedIndices(selectedIndices);
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        int[] selectedIndices = ((JList)this.valueEditor).getSelectedIndices();
        ListModel listModel = ((JList)this.valueEditor).getModel();
        ArrayList list = new ArrayList();
        for (int i = 0; i < selectedIndices.length; ++i) {
            list.add(listModel.getElementAt(selectedIndices[i]));
        }
        this.model.setValue(list);
    }
}

