/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.impl.StringParameter;

public class ConstrainedStringParameterEditor
extends AbstractParameterEditor<String>
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "ConstrainedStringParameterEditor";
    protected static final boolean D = false;
    private JComponent widget;

    public ConstrainedStringParameterEditor(Parameter<String> model) throws ConstraintException {
        super(model);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String S = "ConstrainedStringParameterEditor: itemStateChanged(): ";
        String value = ((JComboBox)this.widget).getSelectedItem().toString();
        this.setValue(value);
    }

    @Override
    public boolean isParameterSupported(Parameter<String> param) {
        if (param == null) {
            return false;
        }
        if (!(param.getValue() instanceof String)) {
            return false;
        }
        if (!(param instanceof StringParameter)) {
            return false;
        }
        ParameterConstraint constraint = param.getConstraint();
        if (!(constraint instanceof StringConstraint)) {
            return false;
        }
        int numConstriants = ((StringConstraint)constraint).size();
        if (numConstriants < 1) {
            return false;
        }
        if (param.isNullAllowed()) {
            return false;
        }
        return param.getValue() != null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.widget != null) {
            this.widget.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.widget != null && this.widget.isEnabled();
    }

    @Override
    protected JComponent buildWidget() {
        StringConstraint con = (StringConstraint)this.getParameter().getConstraint();
        ArrayList<String> strs = con.getAllowedStrings();
        if (strs.size() > 1) {
            JComboBox<Object> combo = new JComboBox<Object>(strs.toArray());
            combo.setMaximumRowCount(32);
            this.widget = combo;
            this.widget.setPreferredSize(WIGET_PANEL_DIM);
            this.widget.setMinimumSize(WIGET_PANEL_DIM);
            combo.setSelectedIndex(strs.indexOf(this.getParameter().getValue()));
            combo.addItemListener(this);
        } else {
            JLabel label = ConstrainedStringParameterEditor.makeSingleConstraintValueLabel(strs.get(0).toString());
            this.widget = new JPanel(new BorderLayout());
            this.widget.setBackground(Color.LIGHT_GRAY);
            this.widget.add(label);
        }
        return this.widget;
    }

    @Override
    protected JComponent updateWidget() {
        StringConstraint con = (StringConstraint)this.getParameter().getConstraint();
        ArrayList<String> strs = con.getAllowedStrings();
        if (strs.size() > 1) {
            if (this.widget instanceof JComboBox) {
                JComboBox combo = (JComboBox)this.widget;
                combo.removeItemListener(this);
                combo.setModel(new DefaultComboBoxModel<Object>(strs.toArray()));
                combo.setSelectedIndex(strs.indexOf(this.getParameter().getValue()));
                combo.addItemListener(this);
                return this.widget;
            }
            return this.buildWidget();
        }
        return this.buildWidget();
    }
}

