/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.AbstractParameterEditorOld;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.impl.EvenlyDiscretizedFuncParameter;

public class EvenlyDiscretizedFuncParameterEditor
extends AbstractParameterEditorOld {
    private static final long serialVersionUID = 1L;
    protected static final String C = "EvenlyDiscretizedFuncParameterEditor";
    protected static final boolean D = false;
    private static final String ONE_Y_VAL_MSG = "Each line should have just one Y value";
    private static final String Y_VALID_MSG = "Y Values entered must be valid numbers";
    private static final String INCORRECT_NUM_Y_VALS = "Number of Y vals should be equal to number of X values";
    protected static final Dimension SCROLLPANE_DIM = new Dimension(70, 230);
    private ParameterList parameterList;
    private EvenlyDiscretizedFuncParameter evenlyDiscrFuncParam;
    private ParameterListEditor editor;
    private JTextArea xTextArea;
    private JScrollPane xScrollPane;
    private JTextArea yTextArea;
    private JScrollPane yScrollPane;
    private EvenlyDiscretizedFunc function;
    private String xAxisName = "";
    private String yAxisName = "";
    private String title;

    public EvenlyDiscretizedFuncParameterEditor() {
    }

    public EvenlyDiscretizedFuncParameterEditor(Parameter model) throws Exception {
        super(model);
        String S = "EvenlyDiscretizedFuncParameterEditor: Constructor(model): ";
        this.setParameter(model);
    }

    @Override
    protected void jbInit() throws Exception {
        this.focusLostProcessing = true;
        this.setLayout(GBL);
    }

    @Override
    public void setParameter(Parameter param) {
        String S = "EvenlyDiscretizedFuncParameterEditor: Constructor(): ";
        if (param != null && !(param instanceof EvenlyDiscretizedFuncParameter)) {
            throw new RuntimeException(S + "Input model parameter must be a EvenlyDiscretizedFuncParameter.");
        }
        this.setParameterInEditor(param);
        this.evenlyDiscrFuncParam = (EvenlyDiscretizedFuncParameter)param;
        this.function = (EvenlyDiscretizedFunc)param.getValue();
        this.xAxisName = "";
        this.yAxisName = "";
        this.title = param.getName();
        if (this.function != null) {
            if (this.function.getXAxisName() != null) {
                this.xAxisName = this.function.getXAxisName();
            }
            if (this.function.getYAxisName() != null) {
                this.yAxisName = this.function.getYAxisName();
            }
        }
        JLabel xLabel = new JLabel(this.xAxisName);
        JLabel yLabel = new JLabel(this.yAxisName);
        this.initParamListAndEditor();
        this.setLayout(GBL);
        this.add((Component)this.editor, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)xLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)yLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.xScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.yScrollPane, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.refreshParamEditor();
    }

    protected void initParamListAndEditor() {
        String S = "EvenlyDiscretizedFuncParameterEditor: initControlsParamListAndEditor(): ";
        this.parameterList = this.evenlyDiscrFuncParam.getEvenlyDiscretizedParams();
        this.editor = new ParameterListEditor(this.parameterList);
        this.editor.setTitle(this.title);
        this.xTextArea = new JTextArea();
        this.xTextArea.setEnabled(false);
        this.xScrollPane = new JScrollPane(this.xTextArea);
        this.xScrollPane.setMinimumSize(SCROLLPANE_DIM);
        this.xScrollPane.setPreferredSize(SCROLLPANE_DIM);
        this.yTextArea = new JTextArea();
        this.yTextArea.addFocusListener(this);
        this.yScrollPane = new JScrollPane(this.yTextArea);
        this.yScrollPane.setMinimumSize(SCROLLPANE_DIM);
        this.yScrollPane.setPreferredSize(SCROLLPANE_DIM);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.editor.setEnabled(isEnabled);
        this.xTextArea.setEnabled(isEnabled);
        this.yTextArea.setEnabled(isEnabled);
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.focusLostProcessing = false;
        Double minVal = (Double)this.parameterList.getParameter("Min ").getValue();
        String isMissing = " is missing";
        if (minVal == null) {
            this.editor.getParameterEditor("Min ").getComponent().grabFocus();
            JOptionPane.showMessageDialog(this, "Min " + isMissing);
            return;
        }
        double min = minVal;
        Double maxVal = (Double)this.parameterList.getParameter("Max ").getValue();
        if (maxVal == null) {
            this.editor.getParameterEditor("Max ").getComponent().grabFocus();
            JOptionPane.showMessageDialog(this, "Max " + isMissing);
            return;
        }
        double max = maxVal;
        Integer numVal = (Integer)this.parameterList.getParameter("Number of Points").getValue();
        if (numVal == null) {
            this.editor.getParameterEditor("Number of Points").getComponent().grabFocus();
            JOptionPane.showMessageDialog(this, "Number of Points" + isMissing);
            return;
        }
        int num = numVal;
        double[] y = new double[this.function.size()];
        for (int i = 0; i < this.function.size(); ++i) {
            y[i] = this.function.getY(i);
        }
        this.function.set(min, max, num);
        Object xStr = "";
        Object yStr = "";
        for (int i = 0; i < num; ++i) {
            if (i < y.length) {
                this.function.set(i, y[i]);
            } else {
                this.function.set(i, 0.0);
            }
            xStr = (String)xStr + (float)this.function.getX(i) + "\n";
            yStr = (String)yStr + this.function.getY(i) + " \n";
        }
        this.xTextArea.setText((String)xStr);
        this.yTextArea.setText((String)yStr);
        this.focusLostProcessing = true;
    }

    public double getMin() {
        return (Double)this.parameterList.getParameter("Min ").getValue();
    }

    public double getMax() {
        return (Double)this.parameterList.getParameter("Max ").getValue();
    }

    public int getNum() {
        return (Integer)this.parameterList.getParameter("Number of Points").getValue();
    }

    @Override
    public void focusLost(FocusEvent e) throws ConstraintException {
        String S = "EvenlyDiscretizedFuncParameterEditor: focusLost(): ";
        super.focusLost(e);
        if (!this.focusLostProcessing) {
            return;
        }
        String str = this.yTextArea.getText();
        StringTokenizer st = new StringTokenizer(str, "\n");
        int yIndex = 0;
        while (st.hasMoreTokens()) {
            StringTokenizer st1 = new StringTokenizer(st.nextToken());
            int numVals = st1.countTokens();
            if (numVals != 1) {
                JOptionPane.showMessageDialog(this, ONE_Y_VAL_MSG);
                return;
            }
            double tempY_Val = 0.0;
            try {
                tempY_Val = Double.parseDouble(st1.nextToken());
                this.function.set(yIndex, tempY_Val);
                ++yIndex;
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, Y_VALID_MSG);
                return;
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(this, INCORRECT_NUM_Y_VALS);
                return;
            }
        }
        if (yIndex != this.function.size()) {
            JOptionPane.showMessageDialog(this, INCORRECT_NUM_Y_VALS);
        }
    }

    @Override
    public void refreshParamEditor() {
        if (this.evenlyDiscrFuncParam == null || this.evenlyDiscrFuncParam.getValue() == null) {
            return;
        }
        EvenlyDiscretizedFunc func = (EvenlyDiscretizedFunc)this.evenlyDiscrFuncParam.getValue();
        this.parameterList.getParameter("Min ").setValue(func.getMinX());
        this.parameterList.getParameter("Max ").setValue(func.getMaxX());
        this.parameterList.getParameter("Number of Points").setValue(func.size());
        this.editor.getParameterEditor("Min ").refreshParamEditor();
        this.editor.getParameterEditor("Max ").refreshParamEditor();
        this.editor.getParameterEditor("Number of Points").refreshParamEditor();
        if (func != null) {
            this.xTextArea.setText("");
            this.yTextArea.setText("");
            int num = func.size();
            Object xText = "";
            Object yText = "";
            for (int i = 0; i < num; ++i) {
                xText = (String)xText + (float)func.getX(i) + "\n";
                yText = (String)yText + func.getY(i) + "\n";
            }
            this.xTextArea.setText((String)xText);
            this.yTextArea.setText((String)yText);
        } else {
            this.xTextArea.setText("");
            this.yTextArea.setText("");
        }
        this.repaint();
    }
}

