/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.impl.FileParameter;

public class FileParameterEditor
extends AbstractParameterEditor<File>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton browseButton;
    private JFileChooser chooser;
    private static final String Browse = "Browse";

    public FileParameterEditor(FileParameter param) {
        super(param);
        this.browseButton.addActionListener(this);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.browseButton != null) {
            this.browseButton.setEnabled(isEnabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.browseButton != null && this.browseButton.isEnabled();
    }

    private JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton(Browse);
        }
        return this.browseButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browseButton) {
            int retVal;
            if (this.chooser == null) {
                File initialDir = null;
                if (this.getParameter() instanceof FileParameter) {
                    initialDir = ((FileParameter)this.getParameter()).getDefaultInitialDir();
                }
                this.chooser = new JFileChooser(initialDir);
            }
            if (this.getParameter() instanceof FileParameter && ((FileParameter)this.getParameter()).isDirectorySelect()) {
                this.chooser.setFileSelectionMode(1);
            } else {
                this.chooser.setFileSelectionMode(0);
            }
            if (this.getParameter() instanceof FileParameter) {
                this.chooser.setFileHidingEnabled(!((FileParameter)this.getParameter()).isShowHiddenFiles());
            }
            if ((retVal = this.chooser.showOpenDialog(this)) == 0) {
                File file = this.chooser.getSelectedFile();
                this.setValue(file);
            }
        }
    }

    @Override
    public boolean isParameterSupported(Parameter<File> param) {
        if (param == null) {
            return false;
        }
        return param.getValue() == null && param.isNullAllowed() || param.getValue() instanceof File;
    }

    @Override
    protected JComponent buildWidget() {
        JButton button = this.getBrowseButton();
        File file = (File)this.getValue();
        if (file == null) {
            button.setText(Browse);
        } else {
            Object name = file.getName();
            if (((String)name).length() > 20) {
                int splitIndex = ((String)name).lastIndexOf(46);
                if (splitIndex > 0) {
                    String main = ((String)name).substring(0, splitIndex);
                    String ext = ((String)name).substring(splitIndex);
                    if (main.length() > 20) {
                        main = main.substring(0, 20);
                        name = main + "(...)" + ext;
                    }
                } else {
                    name = ((String)name).substring(0, 20) + "(...)";
                }
            }
            button.setText((String)name);
        }
        return button;
    }

    @Override
    protected JComponent updateWidget() {
        return this.buildWidget();
    }

    public void setDefaultDir(File dir) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setCurrentDirectory(dir);
    }
}

