/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditorConverter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.ParameterListParameter;

public class LocationParameterEditor
extends AbstractParameterEditorConverter<Location, ParameterList> {
    private static String DEFAULT_LATITUDE_LABEL = "Latitude";
    private static String DEFAULT_LONGITUDE_LABEL = "Longitude";
    private static String DEFAULT_DEPTH_LABEL = "Depth";
    private static final String DECIMAL_DEGREES = "Decimal Degrees";
    private static final String KMS = "kms";
    private DoubleParameter latParam;
    private DoubleParameter lonParam;
    private DoubleParameter depthParam;
    private ParameterList list;
    ParameterListParameter plp;

    public LocationParameterEditor(Parameter<Location> param) {
        this(param, true);
    }

    public LocationParameterEditor(Parameter<Location> param, boolean showDepth) {
        Double depth;
        Double lon;
        Double lat;
        Location loc = param.getValue();
        if (loc == null) {
            lat = null;
            lon = null;
            depth = null;
        } else {
            lat = loc.getLatitude();
            lon = loc.getLongitude();
            depth = loc.getDepth();
        }
        this.latParam = new DoubleParameter(DEFAULT_LATITUDE_LABEL, new DoubleConstraint(-90.0, 90.0), DECIMAL_DEGREES, lat);
        this.latParam.getConstraint().setNullAllowed(true);
        this.lonParam = new DoubleParameter(DEFAULT_LONGITUDE_LABEL, new DoubleConstraint(-180.0, 360.0), DECIMAL_DEGREES, lon);
        this.lonParam.getConstraint().setNullAllowed(true);
        if (showDepth) {
            this.depthParam = new DoubleParameter(DEFAULT_DEPTH_LABEL, new DoubleConstraint(-5.0, 1000.0), KMS, depth);
            this.depthParam.getConstraint().setNullAllowed(true);
        }
        this.list = new ParameterList();
        this.list.addParameter(this.latParam);
        this.list.addParameter(this.lonParam);
        if (this.depthParam != null) {
            this.list.addParameter(this.depthParam);
        }
        this.plp = new ParameterListParameter(param.getName(), this.list);
        this.setParameter(param);
    }

    public void setShowDepth(boolean showDepth) {
        if (showDepth) {
            if (this.depthParam == null) {
                Double depth = this.getParameter().getValue() == null ? null : Double.valueOf(((Location)this.getParameter().getValue()).getDepth());
                this.depthParam = new DoubleParameter(DEFAULT_DEPTH_LABEL, new DoubleConstraint(-5.0, 1000.0), KMS, depth);
                this.depthParam.getConstraint().setNullAllowed(true);
            }
            if (!this.list.containsParameter(this.depthParam)) {
                this.list.addParameter(this.depthParam);
                this.plp.getEditor().refreshParamEditor();
            }
        } else if (this.depthParam != null) {
            this.list.removeParameter(this.depthParam);
            this.plp.getEditor().refreshParamEditor();
        }
    }

    @Override
    protected Parameter<ParameterList> buildParameter(Parameter<Location> myParam) {
        this.updateLocParams(myParam.getValue());
        return this.plp;
    }

    private void updateLocParams(Location loc) {
        if (loc == null) {
            this.latParam.setValue(null);
            this.lonParam.setValue(null);
            if (this.depthParam != null) {
                this.depthParam.setValue(null);
            }
        } else {
            this.latParam.setValue(loc.getLatitude());
            this.lonParam.setValue(loc.getLongitude());
            if (this.depthParam != null) {
                this.depthParam.setValue(loc.getDepth());
            }
        }
        this.plp.getEditor().refreshParamEditor();
    }

    @Override
    protected ParameterList convertFromNative(Location value) {
        this.updateLocParams(value);
        return this.list;
    }

    @Override
    protected Location convertToNative(ParameterList value) {
        Double depth;
        Double lat = (Double)this.latParam.getValue();
        Double lon = (Double)this.lonParam.getValue();
        Double d = depth = this.depthParam == null ? Double.valueOf(0.0) : (Double)this.depthParam.getValue();
        if (lat == null || lon == null) {
            return null;
        }
        if (depth == null) {
            depth = 0.0;
        }
        return new Location(lat, lon, depth);
    }
}

