/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.WarningException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;

public class LongParameterEditor
extends AbstractParameterEditor<Long>
implements FocusListener,
KeyListener {
    private JTextField widget;
    private boolean keyTypeProcessing;
    private boolean focusLostProcessing;

    public LongParameterEditor(Parameter<Long> param) {
        super(param);
    }

    @Override
    public boolean isParameterSupported(Parameter<Long> param) {
        if (param == null) {
            return false;
        }
        return param.getValue() == null || param.getValue() instanceof Long;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.widget != null) {
            this.widget.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.widget != null && this.widget.isEnabled();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        String S = "LabeledBorderPanel: keyTyped(): ";
        this.keyTypeProcessing = false;
        if (this.focusLostProcessing) {
            return;
        }
        if (e.getKeyChar() == '\n') {
            this.keyTypeProcessing = true;
            this.setParamFromField();
        }
        this.keyTypeProcessing = false;
    }

    @Override
    public void focusLost(FocusEvent e) {
        String S = "LabeledBorderPanel: focusLost(): ";
        this.focusLostProcessing = false;
        if (this.keyTypeProcessing) {
            return;
        }
        this.focusLostProcessing = true;
        this.setParamFromField();
        this.focusLostProcessing = false;
    }

    private void setParamFromField() {
        String value = this.widget.getText();
        try {
            Long val = value.equals("") ? null : Long.valueOf(Long.parseLong(value));
            this.setValue(val);
            this.refreshParamEditor();
            this.widget.validate();
            this.widget.repaint();
        }
        catch (NumberFormatException ee) {
            Long obj = (Long)this.getValue();
            if (obj == null) {
                this.widget.setText("");
            } else {
                this.widget.setText(obj.toString());
            }
            this.unableToSetValue(value);
        }
        catch (ConstraintException ee) {
            Long obj = (Long)this.getValue();
            if (obj == null) {
                this.widget.setText("");
            } else {
                this.widget.setText(obj.toString());
            }
            this.unableToSetValue(value);
        }
        catch (WarningException ee) {
            this.refreshParamEditor();
            this.widget.validate();
            this.widget.repaint();
        }
    }

    @Override
    protected JComponent buildWidget() {
        this.widget = new JTextField();
        this.widget.setPreferredSize(LABEL_DIM);
        this.widget.setMinimumSize(LABEL_DIM);
        this.widget.setBorder(ETCHED);
        this.widget.addFocusListener(this);
        this.widget.addKeyListener(this);
        this.updateWidget();
        return this.widget;
    }

    @Override
    protected JComponent updateWidget() {
        Long val = (Long)this.getValue();
        if (val == null) {
            this.widget.setText("");
        } else {
            this.widget.setText("" + val);
        }
        return this.widget;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

