/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.opensha.commons.param.editor.document.NumericPlainDocument;

public class NumericTextField
extends JTextField
implements NumericPlainDocument.InsertErrorListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "NumericTextField";
    protected static final boolean D = false;
    protected static final String S = "NumericTextFieldsetText: (): ";
    protected static final String S2 = "NumericTextFieldsetText: (): ";

    public NumericTextField() {
        this(null, 0, null);
    }

    public NumericTextField(String text, int columns, DecimalFormat format) {
        super(null, text, columns);
        NumericPlainDocument numericDoc = (NumericPlainDocument)this.getDocument();
        if (format != null) {
            numericDoc.setFormat(format);
        }
        numericDoc.addInsertErrorListener(this);
    }

    public NumericTextField(int columns, DecimalFormat format) {
        this(null, columns, format);
    }

    public NumericTextField(String text) {
        this(text, 0, null);
    }

    public NumericTextField(String text, int columns) {
        this(text, columns, null);
    }

    public void setFormat(DecimalFormat format) {
        ((NumericPlainDocument)this.getDocument()).setFormat(format);
    }

    public DecimalFormat getFormat() {
        return ((NumericPlainDocument)this.getDocument()).getFormat();
    }

    public void formatChanged() {
        this.setFormat(this.getFormat());
    }

    public Long getLongValue() throws ParseException {
        return ((NumericPlainDocument)this.getDocument()).getLongValue();
    }

    public Double getDoubleValue() throws ParseException {
        return ((NumericPlainDocument)this.getDocument()).getDoubleValue();
    }

    public Number getNumberValue() throws ParseException {
        return ((NumericPlainDocument)this.getDocument()).getNumberValue();
    }

    public void setValue(Number number) {
        this.setText(this.getFormat().format(number));
    }

    public void setValue(long l) {
        this.setText(this.getFormat().format(l));
    }

    public void setValue(double d) {
        this.setText(this.getFormat().format(d));
    }

    public void normalize() throws ParseException {
        this.setText(this.getFormat().format(this.getNumberValue()));
    }

    @Override
    public void setText(String t) {
        try {
            Document doc = this.getDocument();
            doc.remove(0, doc.getLength());
            doc.insertString(0, t, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public String getText() {
        String txt;
        Document doc = this.getDocument();
        try {
            txt = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            txt = null;
        }
        return txt;
    }

    @Override
    public void insertFailed(NumericPlainDocument doc, int offset, String str, AttributeSet a) {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    protected Document createDefaultModel() {
        return new NumericPlainDocument();
    }

    public static void main(String[] args) {
        DecimalFormat format = new DecimalFormat("#,###.###");
        format.setGroupingUsed(true);
        format.setGroupingSize(3);
        format.setParseIntegerOnly(false);
        JFrame f = new JFrame("Numeric Text Field Example");
        final NumericTextField tf = new NumericTextField(10, format);
        tf.setValue(123456.789);
        JLabel lbl = new JLabel("Type a number: ");
        f.getContentPane().add((Component)tf, "East");
        f.getContentPane().add((Component)lbl, "West");
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    tf.normalize();
                    Long l = tf.getLongValue();
                    System.out.println("Value is (Long)".concat(String.valueOf(l)));
                }
                catch (ParseException e1) {
                    try {
                        Double d = tf.getDoubleValue();
                        System.out.println("Value is (Double)".concat(String.valueOf(d)));
                    }
                    catch (ParseException e2) {
                        System.out.println(e2);
                    }
                }
            }
        });
        f.pack();
        f.setVisible(true);
    }
}

