/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.ParameterEditor;

public class ParameterListEditor
extends LabeledBoxPanel {
    private static final long serialVersionUID = 1L;
    protected static final String C = "ParameterListEditor";
    protected static final boolean D = false;
    protected ParameterList parameterList;
    protected ArrayList<ParameterEditor> parameterEditors = new ArrayList();
    protected ArrayList<String> parametersName = new ArrayList();
    private static GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(4, 4, 4, 4), 0, 0);

    public ParameterListEditor() {
        this.setLayout(new GridBagLayout());
    }

    public ParameterListEditor(ParameterList paramList) {
        this();
        this.setParameterList(paramList);
    }

    public void setParameterList(ParameterList paramList) {
        this.parameterList = paramList;
        this.addParameters();
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public void setParameterVisible(String parameterName, boolean visible) {
        int index = this.getIndexOf(parameterName = this.parameterList.getParameterName(parameterName));
        if (index != -1) {
            ParameterEditor editor = this.parameterEditors.get(index);
            editor.setVisible(visible);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        for (int i = 0; i < this.parameterEditors.size(); ++i) {
            this.parameterEditors.get(i).getComponent().setEnabled(isEnabled);
        }
    }

    private int getIndexOf(String paramName) {
        int size = this.parametersName.size();
        for (int i = 0; i < size; ++i) {
            if (!this.parametersName.get(i).equals(paramName)) continue;
            return i;
        }
        return -1;
    }

    public ParameterList getVisibleParameters() {
        ParameterList visibles = new ParameterList();
        for (ParameterEditor editor : this.parameterEditors) {
            if (!editor.isVisible()) continue;
            Parameter param = editor.getParameter();
            visibles.addParameter(param);
        }
        return visibles;
    }

    public ParameterList getVisibleParametersCloned() {
        return (ParameterList)this.getVisibleParameters().clone();
    }

    public ParameterEditor getParameterEditor(String parameterName) throws NoSuchElementException {
        int index = this.getIndexOf(parameterName = this.parameterList.getParameterName(parameterName));
        if (index != -1) {
            ParameterEditor editor = this.parameterEditors.get(index);
            return editor;
        }
        throw new NoSuchElementException("No ParameterEditor exist named " + parameterName);
    }

    public void refreshParamEditor() {
        for (ParameterEditor editor : this.parameterEditors) {
            editor.refreshParamEditor();
        }
    }

    public void replaceParameterForEditor(String parameterName, Parameter param) {
        int index = this.getIndexOf(parameterName = this.parameterList.getParameterName(parameterName));
        if (index != -1) {
            ParameterEditor editor = this.parameterEditors.get(index);
            editor.setParameter(param);
            this.parameterList.removeParameter(parameterName);
            this.parameterList.addParameter(param);
        }
    }

    protected void addParameters() {
        this.editorPanel.removeAll();
        if (this.parameterList == null) {
            return;
        }
        this.parametersName.clear();
        this.parameterEditors.clear();
        int counter = 0;
        for (Parameter<?> param : this.parameterList) {
            ParameterEditor paramEdit = param.getEditor();
            if (paramEdit == null) {
                throw new RuntimeException("No parameter editor exists for type: " + param.getType() + " (" + param.getClass().getName() + ")");
            }
            this.parametersName.add(param.getName());
            this.parameterEditors.add(paramEdit);
            ParameterListEditor.gbc.gridy = counter++;
            this.editorPanel.add((Component)paramEdit.getComponent(), gbc);
        }
    }
}

