/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListParameterEditor;
import org.opensha.commons.param.impl.TreeBranchWeightsParameter;

public class TreeBranchWeightsParameterEditor
extends ParameterListParameterEditor
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "TreeBranchWeightsParameterEditor";
    private static final String AUTO_WEIGHTS_PARAM_NAME = "Set All";
    private static final String EQUAL_WEIGHTS = "Equal Weights";
    private static final String ZERO_WEIGHT = "Zero Weight";
    private JComboBox autoWeightComboBox;

    public TreeBranchWeightsParameterEditor(Parameter<ParameterList> model) {
        super(model, true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.frame = new JDialog();
        this.frame.setModal(true);
        this.frame.setSize(300, 400);
        this.frame.setTitle(this.getParameter().getName());
        this.frame.getContentPane().setLayout(new GridBagLayout());
        this.frame.getContentPane().add((Component)this.editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.frame.getContentPane().add((Component)this.editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.makeAutoWeightsParamAndEditor();
        this.frame.getContentPane().add((Component)this.autoWeightComboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        JButton button = new JButton();
        button.setText("Update " + this.getParameter().getName());
        button.setForeground(new Color(80, 80, 133));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeBranchWeightsParameterEditor.this.button_actionPerformed(e);
            }
        });
        this.frame.getContentPane().add((Component)button, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.frame.setVisible(true);
        this.frame.pack();
    }

    private void makeAutoWeightsParamAndEditor() {
        this.autoWeightComboBox = new JComboBox();
        this.autoWeightComboBox.setMaximumRowCount(32);
        this.autoWeightComboBox.addItem(AUTO_WEIGHTS_PARAM_NAME);
        this.autoWeightComboBox.addItem(EQUAL_WEIGHTS);
        this.autoWeightComboBox.addItem(ZERO_WEIGHT);
        this.autoWeightComboBox.addItemListener(this);
    }

    @Override
    protected void button_actionPerformed(ActionEvent e) {
        ParameterList paramList = this.editor.getParameterList();
        boolean doSumToOne = ((TreeBranchWeightsParameter)this.getParameter()).doWeightsSumToOne(paramList);
        if (doSumToOne) {
            if (this.parameterChangeFlag) {
                this.getParameter().setValue(paramList);
                this.parameterChangeFlag = false;
            }
            this.frame.dispose();
        } else {
            JOptionPane.showMessageDialog(this.frame, "Parameters Value should sum to One", "Incorrect Input", 0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.autoWeightComboBox) {
            this.setWeightsAuto();
        }
    }

    private void setWeightsAuto() {
        String weightsAutoOption = (String)this.autoWeightComboBox.getSelectedItem();
        double weight = 0.0;
        ParameterList paramList = (ParameterList)this.getParameter().getValue();
        if (weightsAutoOption == EQUAL_WEIGHTS) {
            int numParams = 0;
            ListIterator<Parameter<?>> it = paramList.getParametersIterator();
            while (it.hasNext()) {
                it.next();
                ++numParams;
            }
            weight = 1.0 / (double)numParams;
        } else if (weightsAutoOption == ZERO_WEIGHT) {
            weight = 0.0;
        } else {
            return;
        }
        ListIterator<Parameter<?>> it = paramList.getParametersIterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            param.setValue(weight);
        }
        this.autoWeightComboBox.setSelectedItem(AUTO_WEIGHTS_PARAM_NAME);
        this.editor.refreshParamEditor();
    }

    @Override
    public boolean isParameterSupported(Parameter<ParameterList> param) {
        if (param == null) {
            return false;
        }
        return param instanceof TreeBranchWeightsParameter;
    }
}

