/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedDoubleDiscreteParameterEditor;
import org.opensha.commons.util.ExceptionUtils;

public class DoubleDiscreteParameter
extends AbstractParameter<Double>
implements Parameter<Double> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "DoubleDiscreteParameter";
    protected static final boolean D = false;
    private transient ParameterEditor<Double> paramEdit = null;

    public DoubleDiscreteParameter(String name) {
        super(name, null, null, null);
    }

    public DoubleDiscreteParameter(String name, String units) {
        super(name, null, units, null);
    }

    public DoubleDiscreteParameter(String name, ArrayList doubles) throws ConstraintException {
        super(name, new DoubleDiscreteConstraint(doubles), null, null);
    }

    public DoubleDiscreteParameter(String name, ArrayList doubles, String units) throws ConstraintException {
        super(name, new DoubleDiscreteConstraint(doubles), units, null);
    }

    public DoubleDiscreteParameter(String name, DoubleDiscreteConstraint constraint) throws ConstraintException {
        super(name, constraint, null, null);
    }

    public DoubleDiscreteParameter(String name, DoubleDiscreteConstraint constraint, String units) throws ConstraintException {
        super(name, constraint, units, null);
    }

    public DoubleDiscreteParameter(String name, Double value) {
        super(name, null, null, value);
    }

    public DoubleDiscreteParameter(String name, String units, Double value) throws ConstraintException {
        super(name, null, units, value);
    }

    public DoubleDiscreteParameter(String name, ArrayList doubles, Double value) throws ConstraintException {
        super(name, new DoubleDiscreteConstraint(doubles), null, value);
    }

    public DoubleDiscreteParameter(String name, ArrayList doubles, String units, Double value) throws ConstraintException {
        super(name, new DoubleDiscreteConstraint(doubles), units, value);
    }

    public DoubleDiscreteParameter(String name, DoubleDiscreteConstraint constraint, Double value) throws ConstraintException {
        super(name, constraint, null, value);
    }

    public DoubleDiscreteParameter(String name, DoubleDiscreteConstraint constraint, String units, Double value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    @Override
    public void setConstraint(ParameterConstraint constraint) throws ParameterException, EditableException {
        String S = "DoubleDiscreteParameter: setConstraint( ): ";
        this.checkEditable(S);
        if (!(constraint instanceof DoubleDiscreteConstraint)) {
            throw new ParameterException(S + "This parameter only accepts DoubleDiscreteConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    @Override
    public String getType() {
        Object type = C;
        ParameterConstraint constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + (String)type;
        }
        return type;
    }

    public List<Double> getAllowedDoubles() {
        return ((DoubleDiscreteConstraint)this.constraint).getAllowedDoubles();
    }

    @Override
    public Object clone() {
        DoubleDiscreteConstraint c1 = null;
        if (this.constraint != null) {
            c1 = (DoubleDiscreteConstraint)this.constraint.clone();
        }
        DoubleDiscreteParameter param = null;
        param = this.value == null ? new DoubleDiscreteParameter(this.name, c1, this.units) : new DoubleDiscreteParameter(this.name, c1, this.units, Double.valueOf(((Double)this.value).toString()));
        param.editable = true;
        param.info = this.info;
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        try {
            Double val = Double.parseDouble(el.attributeValue("value"));
            this.setValue(val);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public ParameterEditor<Double> getEditor() {
        if (this.paramEdit == null && this.constraint != null) {
            try {
                this.paramEdit = new ConstrainedDoubleDiscreteParameterEditor(this);
            }
            catch (Exception e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }
        return this.paramEdit;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.paramEdit != null;
    }
}

