/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import java.io.File;
import org.dom4j.Element;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.FileParameterEditor;

public class FileParameter
extends AbstractParameter<File> {
    private static final long serialVersionUID = 1L;
    private FileParameterEditor editor;
    private File initialDir;
    private boolean directorySelect = false;
    private boolean showHiddenFiles = false;

    public FileParameter(String name) {
        this(name, null);
    }

    public FileParameter(String name, File file) {
        super(name, null, null, file);
    }

    @Override
    public ParameterEditor<File> getEditor() {
        if (this.editor == null) {
            this.editor = new FileParameterEditor(this);
        }
        return this.editor;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.editor != null;
    }

    @Override
    public Object clone() {
        return new FileParameter(this.getName(), (File)this.getValue());
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        File file = new File(el.attributeValue("value"));
        this.setValue(file);
        return true;
    }

    public void setDefaultInitialDir(File initialDir) {
        this.initialDir = initialDir;
    }

    public File getDefaultInitialDir() {
        return this.initialDir;
    }

    public boolean isDirectorySelect() {
        return this.directorySelect;
    }

    public void setDirectorySelect(boolean directorySelect) {
        this.directorySelect = directorySelect;
    }

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
    }
}

