/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import java.util.List;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.LocationConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditorOld;
import org.opensha.commons.param.editor.impl.RegionParameterEditor;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.ParameterListParameter;

public class RegionParameter
extends AbstractParameter<Region> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "RegionParameter";
    protected static final boolean D = false;
    protected static final String PARAM_TYPE = "RegionParameter";
    protected ParameterListParameter regionParameterListParameter;
    public static final String MIN_LONGITUDE = "Min Longitude";
    public static final String MAX_LONGITUDE = "Max Longitude";
    public static final String MIN_LATITUDE = "Min Latitude";
    public static final String MAX_LATITUDE = "Max Latitude";
    private DoubleParameter minLon = new DoubleParameter("Min Longitude", (Double)-360.0, (Double)360.0, (Double)-119.5);
    private DoubleParameter maxLon = new DoubleParameter("Max Longitude", (Double)-360.0, (Double)360.0, (Double)-117.0);
    private DoubleParameter minLat = new DoubleParameter("Min Latitude", (Double)-90.0, (Double)90.0, (Double)33.5);
    private DoubleParameter maxLat = new DoubleParameter("Max Latitude", (Double)-90.0, (Double)90.0, (Double)34.7);
    protected Parameter minLatParam;
    protected Parameter maxLatParam;
    protected Parameter minLonParam;
    protected Parameter maxLonParam;
    private Region region;
    private static final String REGION_PARAMETER_LIST_PARAMETER_NAME = "Rectangular Region";
    private transient AbstractParameterEditorOld paramEdit = null;

    public RegionParameter(String name) {
        super(name, null, null, null);
        this.setupParams(null);
    }

    public RegionParameter(String name, Region value) throws ConstraintException {
        super(name, null, null, value);
        this.region = value;
        this.setupParams(value);
    }

    public RegionParameter(String name, String units, double minLat, double maxLat, double minLon, double maxLon) throws ConstraintException {
        super(name, null, units, new Region(new Location(minLat, minLon), new Location(maxLat, maxLon)));
        this.region = (Region)this.value;
        this.setupParams(this.region);
    }

    public void setupParams(Region value) {
        if (value == null) {
            value = new Region(new Location((Double)this.minLat.getValue(), (Double)this.minLon.getValue()), new Location((Double)this.maxLat.getValue(), (Double)this.maxLon.getValue()));
        }
        ParameterList paramList = new ParameterList();
        paramList.addParameter(this.minLat);
        paramList.addParameter(this.maxLat);
        paramList.addParameter(this.minLon);
        paramList.addParameter(this.maxLon);
        this.regionParameterListParameter = new ParameterListParameter(REGION_PARAMETER_LIST_PARAMETER_NAME, paramList);
        this.setValue(value);
        this.setIndependentParameters(paramList);
    }

    public Parameter getRegionParameter() {
        if (this.constraint == null) {
            return this.regionParameterListParameter;
        }
        return this;
    }

    @Override
    public void setConstraint(ParameterConstraint constraint) throws ParameterException, EditableException {
        String S = "RegionParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof LocationConstraint)) {
            throw new ParameterException(S + "This parameter only accepts LocationConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    @Override
    public void setValue(Region reg) {
        this.minLat.setValue(reg.getMinLat());
        this.maxLat.setValue(reg.getMaxLat());
        this.minLon.setValue(reg.getMinLon());
        this.maxLon.setValue(reg.getMaxLon());
        this.region = reg;
        super.setValue(this.region);
    }

    public double getMinLatitude() {
        if (this.constraint != null) {
            return this.region.getMinLat();
        }
        return (Double)this.minLat.getValue();
    }

    public double getMaxLatitude() {
        if (this.constraint != null) {
            return this.region.getMaxLat();
        }
        return (Double)this.maxLat.getValue();
    }

    public double getMinLongitude() {
        if (this.constraint != null) {
            return this.region.getMinLon();
        }
        return (Double)this.minLon.getValue();
    }

    public double getMaxLongitude() {
        if (this.constraint != null) {
            return this.region.getMaxLon();
        }
        return (Double)this.maxLon.getValue();
    }

    public List<Location> getAllowedLocations() {
        return ((LocationConstraint)this.constraint).getAllowedLocations();
    }

    @Override
    public Object clone() {
        RegionParameter param = null;
        param = this.value != null ? new RegionParameter(this.name, (Region)this.value) : new RegionParameter(this.name);
        param.editable = true;
        param.info = this.info;
        return param;
    }

    @Override
    public String getType() {
        String type = this.constraint != null ? "ConstrainedRegionParameter" : "RegionParameter";
        return type;
    }

    @Override
    public String getMetadataString() {
        if (this.constraint == null) {
            return this.getDependentParamMetadataString();
        }
        return super.getMetadataString();
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        return false;
    }

    @Override
    public AbstractParameterEditorOld getEditor() {
        if (this.paramEdit == null) {
            this.paramEdit = new RegionParameterEditor(this);
        }
        return this.paramEdit;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.paramEdit != null;
    }
}

