/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.function.DefaultXY_DataSet;

public class DataUtils {
    private static final Range<Double> POS_RANGE = Range.open((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(Double.POSITIVE_INFINITY));
    private static final int MAX_SEQ_LEN = 10001;
    private static final Function<Double, Double> ABS = new Function<Double, Double>(){

        public Double apply(Double in) {
            return Math.abs(in);
        }
    };
    private static final Function<Double, Double> EXP = new Function<Double, Double>(){

        public Double apply(Double in) {
            return Math.exp(in);
        }
    };
    private static final Function<Double, Double> LN = new Function<Double, Double>(){

        public Double apply(Double in) {
            return Math.log(in);
        }
    };
    private static final Function<Double, Double> LOG = new Function<Double, Double>(){

        public Double apply(Double in) {
            return Math.log10(in);
        }
    };

    private DataUtils() {
    }

    public static double getPercentDiff(double test, double target) {
        if (Double.isNaN(target) || Double.isNaN(test)) {
            return Double.NaN;
        }
        if (target == 0.0) {
            return test == 0.0 ? 0.0 : Double.POSITIVE_INFINITY;
        }
        return Math.abs(test - target) / target * 100.0;
    }

    public static boolean isPositive(double ... data) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"data is empty");
        for (double d : data) {
            if (d >= 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isPositive(List<Double> data) {
        Preconditions.checkNotNull(data);
        Preconditions.checkArgument((data.size() > 0 ? 1 : 0) != 0, (Object)"data is empty");
        for (double d : data) {
            if (d >= 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isMonotonic(boolean ascending, boolean repeats, double ... data) {
        double[] diff = DataUtils.diff(data);
        if (!ascending) {
            DataUtils.flip(diff);
        }
        double min = Doubles.min((double[])diff);
        return repeats ? min >= 0.0 : min > 0.0;
    }

    public static double[] diff(double ... data) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument((data.length > 1 ? 1 : 0) != 0);
        int size = data.length - 1;
        double[] diff = new double[size];
        for (int i = 0; i < size; ++i) {
            diff[i] = data[i + 1] - data[i];
        }
        return diff;
    }

    public static double[] buildLogSequence(double min, double max, double step, boolean ascending) {
        double[] seq = DataUtils.buildSequence(Math.log(min), Math.log(max), Math.log(step), ascending);
        return DataUtils.exp(seq);
    }

    public static double[] buildSequence(double min, double max, double step, boolean ascending) {
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)"min-max reversed");
        int c = (int)Math.floor((max - min) / step);
        Preconditions.checkArgument((c > 0 && c < 10001 ? 1 : 0) != 0, (Object)"sequence size");
        if (ascending) {
            return DataUtils.buildSequence(min, max, step, c + 2);
        }
        double[] descSeq = DataUtils.buildSequence(-max, -min, step, c + 2);
        return DataUtils.flip(descSeq);
    }

    private static double[] buildSequence(double min, double max, double step, int capacity) {
        ArrayList seq = Lists.newArrayListWithCapacity((int)capacity);
        for (double val = min; val < max; val += step) {
            seq.add(val);
        }
        if ((Double)seq.get(seq.size() - 1) != max) {
            seq.add(max);
        }
        return Doubles.toArray((Collection)seq);
    }

    public static double[] scale(double value, double ... data) {
        return DataUtils.transform((Function<Double, Double>)new Scale(value), data);
    }

    public static List<Double> scale(double value, List<Double> list) {
        return DataUtils.transform((Function<Double, Double>)new Scale(value), list);
    }

    public static double[] add(double value, double ... data) {
        return DataUtils.transform((Function<Double, Double>)new Add(value), data);
    }

    public static double[] add(double[] data1, double[] data2) {
        Preconditions.checkArgument((((double[])Preconditions.checkNotNull((Object)data1)).length == ((double[])Preconditions.checkNotNull((Object)data2)).length ? 1 : 0) != 0);
        for (int i = 0; i < data1.length; ++i) {
            int n = i;
            data1[n] = data1[n] + data2[i];
        }
        return data1;
    }

    public static List<Double> add(List<Double> data1, List<Double> data2) {
        Preconditions.checkArgument((((List)Preconditions.checkNotNull(data1)).size() == ((List)Preconditions.checkNotNull(data2)).size() ? 1 : 0) != 0);
        for (int i = 0; i < data1.size(); ++i) {
            data1.set(i, data1.get(i) + data2.get(i));
        }
        return data1;
    }

    public static double[] subtract(double[] data1, double[] data2) {
        Preconditions.checkArgument((((double[])Preconditions.checkNotNull((Object)data1)).length == ((double[])Preconditions.checkNotNull((Object)data2)).length ? 1 : 0) != 0);
        for (int i = 0; i < data1.length; ++i) {
            int n = i;
            data1[n] = data1[n] - data2[i];
        }
        return data1;
    }

    public static List<Double> subtract(List<Double> data1, List<Double> data2) {
        Preconditions.checkArgument((((List)Preconditions.checkNotNull(data1)).size() == ((List)Preconditions.checkNotNull(data2)).size() ? 1 : 0) != 0);
        for (int i = 0; i < data1.size(); ++i) {
            data1.set(i, data1.get(i) - data2.get(i));
        }
        return data1;
    }

    public static double[] multiply(double[] data1, double[] data2) {
        Preconditions.checkArgument((((double[])Preconditions.checkNotNull((Object)data1)).length == ((double[])Preconditions.checkNotNull((Object)data2)).length ? 1 : 0) != 0);
        for (int i = 0; i < data1.length; ++i) {
            int n = i;
            data1[n] = data1[n] * data2[i];
        }
        return data1;
    }

    public static double[] abs(double ... data) {
        return DataUtils.transform(ABS, data);
    }

    public static double[] exp(double ... data) {
        return DataUtils.transform(EXP, data);
    }

    public static double[] ln(double ... data) {
        return DataUtils.transform(LN, data);
    }

    public static double[] log(double ... data) {
        return DataUtils.transform(LOG, data);
    }

    public static double[] flip(double ... data) {
        return DataUtils.transform((Function<Double, Double>)new Scale(-1.0), data);
    }

    public static double min(double ... data) {
        return Doubles.min((double[])data);
    }

    public static double max(double ... data) {
        return Doubles.max((double[])data);
    }

    public static double sum(double ... data) {
        Preconditions.checkNotNull((Object)data);
        double sum = 0.0;
        for (double d : data) {
            sum += d;
        }
        return sum;
    }

    public static double sum(List<Double> data) {
        Preconditions.checkNotNull(data);
        double sum = 0.0;
        for (double d : data) {
            sum += d;
        }
        return sum;
    }

    public static void main(String[] args) {
        double[] vals = new double[]{4.0, 1.0E-6, -3.0, 8.0, 0.0, 1.0E8, Double.POSITIVE_INFINITY};
        List data = Doubles.asList((double[])vals);
        List<Integer> indices = DataUtils.sortedIndices(data, true);
        System.out.println(indices);
    }

    public static double[] asWeights(double ... data) {
        Preconditions.checkArgument((boolean)DataUtils.isPositive(data));
        double sum = DataUtils.sum(data);
        Preconditions.checkArgument((boolean)POS_RANGE.contains((Comparable)Double.valueOf(sum)));
        double scale = 1.0 / sum;
        return DataUtils.scale(scale, data);
    }

    public static List<Double> asWeights(List<Double> data) {
        Preconditions.checkArgument((boolean)DataUtils.isPositive(data));
        double sum = DataUtils.sum(data);
        Preconditions.checkArgument((boolean)POS_RANGE.contains((Comparable)Double.valueOf(sum)));
        double scale = 1.0 / sum;
        return DataUtils.scale(scale, data);
    }

    private static double[] transform(Function<Double, Double> function, double ... data) {
        Preconditions.checkNotNull((Object)data);
        for (int i = 0; i < data.length; ++i) {
            data[i] = (Double)function.apply((Object)data[i]);
        }
        return data;
    }

    private static List<Double> transform(Function<Double, Double> function, List<Double> data) {
        Preconditions.checkNotNull(data);
        for (int i = 0; i < data.size(); ++i) {
            data.set(i, (Double)function.apply((Object)data.get(i)));
        }
        return data;
    }

    public static final void validate(double min, double max, double ... array) {
        Preconditions.checkNotNull((Object)array, (Object)"array");
        for (int i = 0; i < array.length; ++i) {
            DataUtils.validate(min, max, array[i]);
        }
    }

    public static final void validate(double min, double max, double value) {
        boolean neither;
        boolean valNaN = Double.isNaN(value);
        boolean minNaN = Double.isNaN(min);
        boolean maxNaN = Double.isNaN(max);
        boolean both = minNaN && maxNaN;
        boolean bl = neither = !minNaN && !maxNaN;
        if (neither) {
            Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)"min-max reversed");
        }
        boolean expression = valNaN || both ? true : (minNaN ? value <= max : (maxNaN ? value >= min : value >= min && value <= max));
        Preconditions.checkArgument((boolean)expression, (String)"Value [%s] out of range [%s ,%s]", (Object)value, (Object)min, (Object)max);
    }

    public static Object arraySelect(Object array, int[] indices) {
        Preconditions.checkNotNull((Object)array, (Object)"Supplied data array is null");
        Preconditions.checkNotNull((Object)indices, (Object)"Supplied index array is null");
        Preconditions.checkArgument((boolean)array.getClass().isArray(), (Object)"Data object supplied is not an array");
        int arraySize = Array.getLength(array);
        Preconditions.checkArgument((arraySize != 0 ? 1 : 0) != 0, (Object)"Supplied data array is empty");
        for (int i = 0; i < indices.length; ++i) {
            Preconditions.checkPositionIndex((int)indices[i], (int)arraySize, (String)"Supplied index");
        }
        Class<?> srcClass = array.getClass().getComponentType();
        Object out = Array.newInstance(srcClass, indices.length);
        for (int i = 0; i < indices.length; ++i) {
            Array.set(out, i, Array.get(array, indices[i]));
        }
        return out;
    }

    @Deprecated
    public static int[] indexAndSort(final double[] data) {
        Preconditions.checkNotNull((Object)data, (Object)"Source array is null");
        List indices = Ints.asList((int[])new int[data.length]);
        for (int i = 0; i < indices.size(); ++i) {
            indices.set(i, i);
        }
        Collections.sort(indices, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                double d2;
                double d1 = data[i1];
                return d1 < (d2 = data[i2]) ? -1 : (d1 == d2 ? 0 : 1);
            }
        });
        Arrays.sort(data);
        return Ints.toArray((Collection)indices);
    }

    public static List<Integer> sortedIndices(List<Double> data, boolean ascending) {
        Preconditions.checkNotNull(data);
        List indices = Ints.asList((int[])DataUtils.indices(data.size()));
        Collections.sort(indices, new IndexComparator(data, ascending));
        return indices;
    }

    public static int[] indices(int length) {
        int[] indices = new int[length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    public static double[] randomValues(int length) {
        Random random = new Random();
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = random.nextDouble();
        }
        return values;
    }

    public static int minIndex(double ... data) {
        int idx = -1;
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] < d)) continue;
            d = data[i];
            idx = i;
        }
        return idx;
    }

    public static int maxIndex(double ... data) {
        int idx = -1;
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] > d)) continue;
            d = data[i];
            idx = i;
        }
        return idx;
    }

    public static DefaultXY_DataSet nearestNeighborHist(double[] data, double origin, int size) {
        Preconditions.checkNotNull((Object)data, (Object)"Supplied data is null");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"Supplied data is empty");
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Bin size can't be less than 1");
        double[] localData = Arrays.copyOf(data, data.length);
        Arrays.sort(localData);
        int startIdx = Arrays.binarySearch(localData, origin);
        Preconditions.checkArgument((startIdx < localData.length ? 1 : 0) != 0, (Object)"Origin is greater than all data values");
        int n = startIdx = startIdx > 0 ? startIdx : -startIdx - 1;
        while (startIdx > 0 && origin == localData[startIdx - 1]) {
            --startIdx;
        }
        int binCount = (int)Math.floor((localData = Arrays.copyOfRange(localData, startIdx, localData.length)).length / size);
        if (binCount == 0) {
            return null;
        }
        ArrayList<Double> x = new ArrayList<Double>();
        ArrayList<Double> y = new ArrayList<Double>();
        for (int i = 0; i < binCount; ++i) {
            int datIdx = i * size;
            double binHi = localData[datIdx + size - 1];
            double binLo = i == 0 ? origin : localData[datIdx - 1];
            double binDelta = binHi - binLo;
            if (binDelta == 0.0) continue;
            y.add((double)size / (binHi - binLo));
            x.add(StatUtils.percentile((double[])localData, (int)datIdx, (int)size, (double)50.0));
        }
        return x.isEmpty() ? null : new DefaultXY_DataSet(x, y);
    }

    public static double median(double[] unsorted) {
        double[] sorted = Arrays.copyOf(unsorted, unsorted.length);
        Arrays.sort(sorted);
        return DataUtils.median_sorted(sorted);
    }

    public static double median_sorted(double[] sorted) {
        Preconditions.checkState((sorted.length > 0 ? 1 : 0) != 0, (Object)"must have at least one value");
        if (sorted.length % 2 == 1) {
            return sorted[(sorted.length + 1) / 2 - 1];
        }
        double lower = sorted[sorted.length / 2 - 1];
        double upper = sorted[sorted.length / 2];
        return (lower + upper) * 0.5;
    }

    public static List<Double> commaDoubleSplit(String str) {
        ArrayList<Double> vals = new ArrayList<Double>();
        for (String val : DataUtils.commaSplit(str)) {
            vals.add(Double.parseDouble(val));
        }
        return vals;
    }

    public static List<String> commaSplit(String str) {
        str = str.trim();
        ArrayList<String> vals = new ArrayList<String>();
        for (String val : str.split(",")) {
            val = val.trim();
            vals.add(val);
        }
        return vals;
    }

    public static double roundFixed(double value, int scale) {
        return DataUtils.roundFixed(value, scale, RoundingMode.HALF_UP);
    }

    public static double roundFixed(double value, int scale, RoundingMode mode) {
        if (!Double.isFinite(value)) {
            return value;
        }
        return BigDecimal.valueOf(value).setScale(scale, mode).doubleValue();
    }

    public static double roundSigFigs(double value, int sigFigs) {
        return DataUtils.roundSigFigs(value, sigFigs, RoundingMode.HALF_UP);
    }

    public static double roundSigFigs(double value, int sigFigs, RoundingMode mode) {
        if (!Double.isFinite(value)) {
            return value;
        }
        return BigDecimal.valueOf(value).round(new MathContext(sigFigs, mode)).doubleValue();
    }

    public static double[] roundSigFigs(double[] values, int sigFigs) {
        return DataUtils.roundSigFigs(values, sigFigs, RoundingMode.HALF_UP);
    }

    public static double[] roundSigFigs(double[] values, int sigFigs, RoundingMode mode) {
        MathContext context = new MathContext(sigFigs, mode);
        double[] ret = new double[values.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Double.isFinite(values[i]) ? BigDecimal.valueOf(values[i]).round(context).doubleValue() : values[i];
        }
        return ret;
    }

    private static class Scale
    implements Function<Double, Double> {
        private final double scale;

        private Scale(double scale) {
            this.scale = scale;
        }

        public Double apply(Double d) {
            return d * this.scale;
        }
    }

    private static class Add
    implements Function<Double, Double> {
        private final double term;

        private Add(double term) {
            this.term = term;
        }

        public Double apply(Double d) {
            return d + this.term;
        }
    }

    private static class IndexComparator
    implements Comparator<Integer> {
        List<Double> data;
        boolean ascending;

        IndexComparator(List<Double> data, boolean ascending) {
            this.data = data;
            this.ascending = ascending;
        }

        @Override
        public int compare(Integer i1, Integer i2) {
            double d2;
            double d1 = this.data.get(this.ascending ? i1 : i2);
            return d1 < (d2 = this.data.get(this.ascending ? i2 : i1).doubleValue()) ? -1 : (d1 == d2 ? 0 : 1);
        }
    }

    public static class MinMaxAveTracker {
        private double min = Double.POSITIVE_INFINITY;
        private double max = Double.NEGATIVE_INFINITY;
        private double tot = 0.0;
        private int num = 0;

        public void addValue(double val) {
            if (val < this.min) {
                this.min = val;
            }
            if (val > this.max) {
                this.max = val;
            }
            this.tot += val;
            ++this.num;
        }

        public void addFrom(MinMaxAveTracker o) {
            this.min = Math.min(this.min, o.min);
            this.max = Math.max(this.max, o.max);
            this.tot += o.tot;
            this.num += o.num;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getCenter() {
            return 0.5 * (this.min + this.max);
        }

        public double getLength() {
            return this.max - this.min;
        }

        public double getAverage() {
            return this.tot / (double)this.num;
        }

        public int getNum() {
            return this.num;
        }

        public double getSum() {
            return this.tot;
        }

        public String toString() {
            return "min: " + this.min + ", max: " + this.max + ", avg: " + this.getAverage() + ", tot: " + this.tot;
        }
    }
}

