/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorUtils {
    public static ExecutorService newBlockingThreadPool(int threads) {
        return ExecutorUtils.newBlockingThreadPool(threads, threads);
    }

    public static ExecutorService newBlockingThreadPool(int threads, int capacity) {
        return ExecutorUtils.newBlockingThreadPool(threads, capacity, null);
    }

    public static ExecutorService newBlockingThreadPool(int threads, int capacity, String name) {
        Preconditions.checkState((capacity >= threads ? 1 : 0) != 0, (String)"capacity (%s) must be >= threads (%s)", (int)capacity, (int)threads);
        return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(capacity), new NamedThreadFactory(name == null || name.isBlank() ? "blocking" : name), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ExecutorService newNamedThreadPool(int threads, String name) {
        return Executors.newFixedThreadPool(threads, new NamedThreadFactory(name));
    }

    public static ExecutorService newDaemonThreadPool(int threads) {
        return ExecutorUtils.newDaemonThreadPool(threads, null);
    }

    public static ExecutorService newDaemonThreadPool(int threads, String nameAdd) {
        return Executors.newFixedThreadPool(threads, new DaemonThreadFactory(nameAdd));
    }

    public static ExecutorService singleTaskRejectingExecutor() {
        return new SingleTaskRejectingExecutor();
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public NamedThreadFactory(String name) {
            this.group = Thread.currentThread().getThreadGroup();
            Preconditions.checkState((name != null && !name.isBlank() ? 1 : 0) != 0, (Object)"Name must be specified (use Executors.defaultThreadFactory() if you don't want a name)");
            this.namePrefix = name + "-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(false);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    public static class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public DaemonThreadFactory() {
            this(null);
        }

        public DaemonThreadFactory(String nameAdd) {
            this.group = Thread.currentThread().getThreadGroup();
            nameAdd = nameAdd == null || ((String)nameAdd).isBlank() ? "" : (String)nameAdd + "-";
            this.namePrefix = (String)nameAdd + "daemon-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static class SingleTaskRejectingExecutor
    extends AbstractExecutorService {
        private final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.AbortPolicy());

        @Override
        public void execute(Runnable command) {
            try {
                this.executor.execute(command);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        @Override
        public void shutdown() {
            this.executor.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.executor.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.executor.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.awaitTermination(timeout, unit);
        }
    }
}

