/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.faultSurface.FaultTrace;

public final class FaultUtils {
    protected static final String C = "FaultUtils";
    protected static final boolean D = false;
    private static final String S1 = "FaultUtils: assertValidStrike(): ";
    private static final String S2 = "FaultUtils: assertValidDip(): ";
    private static final String S3 = "FaultUtils: assertValidRake(): ";
    private static final double[] VX_UNIT_NORMAL = new double[]{1.0, 0.0, 0.0};
    private static final double[] VY_UNIT_NORMAL = new double[]{0.0, 1.0, 0.0};
    private static final double[] VZ_UNIT_NORMAL = new double[]{0.0, 0.0, 1.0};

    public static void assertValidStrike(double strike) throws InvalidRangeException {
        if (strike < 0.0) {
            throw new InvalidRangeException("FaultUtils: assertValidStrike(): Strike angle cannot be less than zero (value = " + strike + ")");
        }
        if (strike > 360.0) {
            throw new InvalidRangeException("FaultUtils: assertValidStrike(): Strike angle cannot be greater than 360 (value = " + strike + ")");
        }
    }

    public static void assertValidDip(double dip) throws InvalidRangeException {
        if (dip < 0.0) {
            throw new InvalidRangeException("FaultUtils: assertValidDip(): Dip angle cannot be less than zero; the value is " + dip);
        }
        if (dip > 90.0) {
            throw new InvalidRangeException("FaultUtils: assertValidDip(): Dip angle cannot be greater than 90; the value is " + dip);
        }
    }

    public static void assertValidDepth(double depth) throws InvalidRangeException {
        if (!(depth >= 0.0)) {
            throw new InvalidRangeException("FaultUtils: assertValidDip(): Depth on fault must be positive");
        }
    }

    public static void assertValidSeisUpperAndLower(double upperSeis, double lowerSeis) throws InvalidRangeException {
        FaultUtils.assertValidDepth(upperSeis);
        FaultUtils.assertValidDepth(lowerSeis);
        if (upperSeis > lowerSeis) {
            throw new InvalidRangeException("FaultUtils: assertValidDip(): upperSeisDepth must be < lowerSeisDepth");
        }
    }

    public static void assertValidRake(double rake) throws InvalidRangeException {
        if (rake < -180.0) {
            throw new InvalidRangeException("FaultUtils: assertValidRake(): Rake angle cannot be less than -180");
        }
        if (rake > 180.0) {
            throw new InvalidRangeException("FaultUtils: assertValidRake(): Rake angle cannot be greater than 180");
        }
    }

    public static double getInRakeRange(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 180.0;
        }
        return angle;
    }

    public static ArrayList<FaultTrace> getEqualLengthSubsectionTraces(FaultTrace faultTrace, double maxSubSectionLen) {
        return FaultUtils.getEqualLengthSubsectionTraces(faultTrace, maxSubSectionLen, 1);
    }

    public static ArrayList<FaultTrace> getEqualLengthSubsectionTraces(FaultTrace faultTrace, double maxSubSectionLen, int minSubSections) {
        double numSubSec = faultTrace.getTraceLength() / maxSubSectionLen;
        int numSubSections = Math.floor(numSubSec) != numSubSec ? (int)Math.floor(numSubSec) + 1 : (int)numSubSec;
        if (numSubSections < minSubSections) {
            numSubSections = minSubSections;
        }
        return FaultUtils.getEqualLengthSubsectionTraces(faultTrace, numSubSections);
    }

    public static ArrayList<FaultTrace> getEqualLengthSubsectionTraces(FaultTrace faultTrace, int numSubSections) {
        double subSecLength = faultTrace.getTraceLength() / (double)numSubSections;
        double distance = 0.0;
        double distLocs = 0.0;
        int numLocs = faultTrace.getNumLocations();
        int index = 0;
        ArrayList<FaultTrace> subSectionTraceList = new ArrayList<FaultTrace>();
        Location prevLoc = (Location)faultTrace.get(index);
        block0: while (index < numLocs && subSectionTraceList.size() < numSubSections) {
            FaultTrace subSectionTrace = new FaultTrace(faultTrace.getName() + " " + (subSectionTraceList.size() + 1));
            subSectionTraceList.add(subSectionTrace);
            subSectionTrace.add(prevLoc);
            ++index;
            distance = 0.0;
            while (index < faultTrace.getNumLocations()) {
                Location nextLoc = (Location)faultTrace.get(index);
                distLocs = LocationUtils.horzDistance(prevLoc, nextLoc);
                if ((distance += distLocs) < subSecLength) {
                    prevLoc = nextLoc;
                    subSectionTrace.add(prevLoc);
                    ++index;
                    continue;
                }
                LocationVector direction = LocationUtils.vector(prevLoc, nextLoc);
                double origHorzDist = direction.getHorzDistance();
                double modHorzDist = subSecLength - (distance - distLocs);
                direction.setHorzDistance(modHorzDist);
                if (direction.getVertDistance() != 0.0) {
                    direction.setVertDistance(direction.getVertDistance() * modHorzDist / origHorzDist);
                }
                prevLoc = LocationUtils.location(prevLoc, direction);
                subSectionTrace.add(prevLoc);
                --index;
                continue block0;
            }
        }
        return subSectionTraceList;
    }

    public static FaultTrace resampleTrace(FaultTrace trace, int num) {
        double resampInt = trace.getTraceLength() / (double)num;
        FaultTrace resampTrace = new FaultTrace("resampled " + trace.getName());
        resampTrace.add((Location)trace.get(0));
        double remainingLength = resampInt;
        Location lastLoc = (Location)trace.get(0);
        int NextLocIndex = 1;
        while (NextLocIndex < trace.size()) {
            Location nextLoc = (Location)trace.get(NextLocIndex);
            double length = LocationUtils.horzDistance(lastLoc, nextLoc);
            if (length > remainingLength) {
                LocationVector dir = LocationUtils.vector(lastLoc, nextLoc);
                dir.setHorzDistance(dir.getHorzDistance() * remainingLength / length);
                dir.setVertDistance(dir.getVertDistance() * remainingLength / length);
                Location loc = LocationUtils.location(lastLoc, dir);
                resampTrace.add(loc);
                lastLoc = loc;
                remainingLength = resampInt;
                continue;
            }
            lastLoc = nextLoc;
            ++NextLocIndex;
            remainingLength -= length;
        }
        double dist = LocationUtils.linearDistanceFast((Location)trace.get(trace.size() - 1), (Location)resampTrace.get(resampTrace.size() - 1));
        if (dist > resampInt / 2.0) {
            resampTrace.add((Location)trace.get(trace.size() - 1));
        }
        Preconditions.checkState((resampTrace.size() == num + 1 ? 1 : 0) != 0, (String)"Resampled trace should have %s locations, but has %s", (int)(num + 1), (int)resampTrace.size());
        return resampTrace;
    }

    public static void plotTraces(ArrayList<FaultTrace> traces) {
        throw new RuntimeException("This doesn't work because our functions will reorder x-axis valuesto monotonically increase (and remove duplicates - someone should fix this)");
    }

    public static double getLengthBasedAngleAverage(List<Location> locs, List<Double> angles) {
        Preconditions.checkArgument((locs.size() >= 2 ? 1 : 0) != 0, (Object)"must have at least 2 locations!");
        Preconditions.checkArgument((angles.size() == locs.size() - 1 ? 1 : 0) != 0, (Object)"must have exactly one fewer angles than location");
        ArrayList<Double> lengths = new ArrayList<Double>();
        for (int i = 1; i < locs.size(); ++i) {
            lengths.add(LocationUtils.linearDistanceFast(locs.get(i), locs.get(i - 1)));
        }
        return FaultUtils.getScaledAngleAverage(lengths, angles);
    }

    public static double getScaledAngleAverage(List<Double> scalars, List<Double> angles) {
        Preconditions.checkArgument((scalars.size() >= 1 ? 1 : 0) != 0, (Object)"must have at least 1 lengths!");
        Preconditions.checkArgument((angles.size() == scalars.size() ? 1 : 0) != 0, (Object)"must have exactly the same amount of lengths as angles");
        if (angles.size() == 1) {
            return angles.get(0);
        }
        if (Double.isNaN(angles.get(0))) {
            return Double.NaN;
        }
        boolean equal = true;
        for (int i = 1; i < angles.size(); ++i) {
            if (Double.isNaN(angles.get(i))) {
                return Double.NaN;
            }
            if (angles.get(i) == angles.get(0)) continue;
            equal = false;
        }
        if (equal) {
            return angles.get(0);
        }
        AngleAverager avg = new AngleAverager();
        for (int i = 0; i < scalars.size(); ++i) {
            double scalar = scalars.get(i);
            double angle = angles.get(i);
            avg.add(angle, scalar);
        }
        return avg.getAverage();
    }

    public static double getAngleAverage(List<Double> angles) {
        ArrayList<Double> scalars = new ArrayList<Double>();
        for (int i = 0; i < angles.size(); ++i) {
            scalars.add(1.0);
        }
        return FaultUtils.getScaledAngleAverage(scalars, angles);
    }

    public static double getAbsAngleDiff(double angle1, double angle2) {
        double angleDiff;
        for (angleDiff = Math.abs(angle1 - angle2); angleDiff > 270.0; angleDiff -= 360.0) {
        }
        return Math.abs(angleDiff);
    }

    public static double[] getSlipVector(double[] strikeDipRake) {
        double[] startVector = VY_UNIT_NORMAL;
        double[] rakeRotVector = FaultUtils.vectorMatrixMultiply(FaultUtils.zAxisRotMatrix(-strikeDipRake[2]), startVector);
        double[] dipRotVector = FaultUtils.vectorMatrixMultiply(FaultUtils.yAxisRotMatrix(-strikeDipRake[1]), rakeRotVector);
        double[] strikeRotVector = FaultUtils.vectorMatrixMultiply(FaultUtils.zAxisRotMatrix(strikeDipRake[0]), dipRotVector);
        return strikeRotVector;
    }

    private static double[] vectorMatrixMultiply(double[][] matrix, double[] vector) {
        double[] rotatedVector = new double[3];
        for (int i = 0; i < 3; ++i) {
            rotatedVector[i] = vector[0] * matrix[i][0] + vector[1] * matrix[i][1] + vector[2] * matrix[i][2];
        }
        return rotatedVector;
    }

    private static double[][] xAxisRotMatrix(double theta) {
        double thetaRad = Math.toRadians(theta);
        double[][] rotMatrix = new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(thetaRad), Math.sin(thetaRad)}, {0.0, -Math.sin(thetaRad), Math.cos(thetaRad)}};
        return rotMatrix;
    }

    private static double[][] yAxisRotMatrix(double theta) {
        double thetaRad = Math.toRadians(theta);
        double[][] rotMatrix = new double[][]{{Math.cos(thetaRad), 0.0, -Math.sin(thetaRad)}, {0.0, 1.0, 0.0}, {Math.sin(thetaRad), 0.0, Math.cos(thetaRad)}};
        return rotMatrix;
    }

    private static double[][] zAxisRotMatrix(double theta) {
        double thetaRad = Math.toRadians(theta);
        double[][] rotMatrix = new double[][]{{Math.cos(thetaRad), Math.sin(thetaRad), 0.0}, {-Math.sin(thetaRad), Math.cos(thetaRad), 0.0}, {0.0, 0.0, 1.0}};
        return rotMatrix;
    }

    public static class AngleAverager {
        double xdir = 0.0;
        double ydir = 0.0;

        public synchronized void add(double angle, double weight) {
            this.xdir += weight * Math.cos(Math.toRadians(angle));
            this.ydir += weight * Math.sin(Math.toRadians(angle));
        }

        public double getAverage() {
            double avg;
            for (avg = (this.xdir > 0.0 ? true : false) & (this.ydir >= 0.0 ? true : false) ? Math.toDegrees(Math.atan(this.ydir / this.xdir)) : ((this.xdir > 0.0 ? true : false) & (this.ydir < 0.0 ? true : false) ? Math.toDegrees(Math.atan(this.ydir / this.xdir)) + 360.0 : (this.xdir < 0.0 ? Math.toDegrees(Math.atan(this.ydir / this.xdir)) + 180.0 : ((this.xdir == 0.0 ? true : false) & (this.ydir > 0.0 ? true : false) ? 90.0 : ((this.xdir == 0.0 ? true : false) & (this.ydir < 0.0 ? true : false) ? 270.0 : 0.0)))); avg > 360.0; avg -= 360.0) {
            }
            while (avg < 0.0) {
                avg += 360.0;
            }
            return avg;
        }
    }
}

