/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.io.IOException;
import java.text.Normalizer;
import org.opensha.commons.data.Site;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.util.PRVI25_RegionLoader;

public class FileNameUtils {
    public static String simplify(String name) {
        String ret = Normalizer.normalize(name, Normalizer.Form.NFD);
        ret = ret.replaceAll("\\p{M}", "");
        ret = ret.replaceAll("\\W+", "_");
        while (ret.startsWith("_")) {
            ret = ret.substring(1);
        }
        while (ret.endsWith("_")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        while (ret.contains("__")) {
            ret = ret.replace("__", "_");
        }
        return ret;
    }

    public static void main(String[] args) throws IOException {
        for (Site site : PRVI25_RegionLoader.loadHazardSites()) {
            System.out.println(site.getName() + "\t->\t" + FileNameUtils.simplify(site.getName()));
        }
    }
}

