/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.util.Arrays;

public class Interpolate {
    private Interpolate() {
    }

    public static double findX(double x1, double y1, double x2, double y2, double y) {
        return Interpolate.findY(y1, x1, y2, x2, y);
    }

    public static double findY(double x1, double y1, double x2, double y2, double x) {
        return y1 + (x - x1) * (y2 - y1) / (x2 - x1);
    }

    public static double findY(double[] xs, double[] ys, double x) {
        int i = Interpolate.dataIndex(xs, x);
        return Interpolate.findY(xs[i], ys[i], xs[i + 1], ys[i + 1], x);
    }

    public static double findLogY(double[] xs, double[] ys, double x) {
        int i = Interpolate.dataIndex(xs, x);
        return Math.exp(Interpolate.findY(xs[i], Math.log(ys[i]), xs[i + 1], Math.log(ys[i + 1]), x));
    }

    public static double findLogLogY(double[] xs, double[] ys, double x) {
        int i = Interpolate.dataIndex(xs, x);
        return Math.exp(Interpolate.findY(Math.log(xs[i]), Math.log(ys[i]), Math.log(xs[i + 1]), Math.log(ys[i + 1]), Math.log(x)));
    }

    public static double[] findY(double[] xs, double[] ys, double[] x) {
        double[] y = new double[x.length];
        int i = 0;
        for (double xVal : x) {
            y[i++] = Interpolate.findY(xs, ys, xVal);
        }
        return y;
    }

    public static double[] findLogY(double[] xs, double[] ys, double[] x) {
        double[] y = new double[x.length];
        int i = 0;
        for (double xVal : x) {
            y[i++] = Interpolate.findLogY(xs, ys, xVal);
        }
        return y;
    }

    public static double[] findLogLogY(double[] xs, double[] ys, double[] x) {
        double[] y = new double[x.length];
        int i = 0;
        for (double xVal : x) {
            y[i++] = Interpolate.findLogLogY(xs, ys, xVal);
        }
        return y;
    }

    private static int dataIndex(double[] data, double value) {
        int i = Arrays.binarySearch(data, value);
        i = i == -1 ? 0 : (i < 0 ? -i - 2 : i);
        return i >= data.length - 1 ? --i : i;
    }
}

