/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.opensha.commons.util.ServerPrefs;

public class ServerPrefUtils {
    public static final DateFormat df;
    private static final String PROD_VERSION = "26.1";
    static final String OPENSHA_SERVER_PRODUCTION_HOST = "data.opensha.org";
    static final String OPENSHA_SERVER_DEV_HOST = "opensha.scec.org";
    static final String OPENSHA_TOMCAT_WEBAPPS_DIR = "/var/lib/tomcat/webapps/";
    static final File DATA_DIR;
    static final File TEMP_DIR;
    static final File OPENSHA_TOMCAT_PRODUCTION_DIR;
    static final File OPENSHA_TOMCAT_DEV_DIR;
    static final String OPENSHA_SERVLET_PRODUCTION_URL;
    static final String OPENSHA_SERVLET_DEV_URL;
    public static final ServerPrefs SERVER_PREFS;

    public static void debug(String debugName, String message) {
        String date = "[" + df.format(new Date()) + "]";
        System.out.println(debugName + " " + date + ": " + message);
    }

    public static void fail(ObjectOutputStream out, String debugName, String message) throws IOException {
        ServerPrefUtils.debug(debugName, "Failing: " + message);
        out.writeObject(false);
        out.writeObject(message);
        out.flush();
        out.close();
    }

    static {
        String hostName;
        df = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        DATA_DIR = new File("/export/opensha-00/data/");
        TEMP_DIR = new File("/export/opensha-00/tmp/");
        OPENSHA_TOMCAT_PRODUCTION_DIR = new File("/var/lib/tomcat/webapps//OpenSHA_26.1/WEB-INF/");
        OPENSHA_TOMCAT_DEV_DIR = new File("/var/lib/tomcat/webapps//OpenSHA_master/WEB-INF/");
        try {
            hostName = InetAddress.getLocalHost().getHostName().toLowerCase().trim();
        }
        catch (Exception e) {
            hostName = null;
        }
        String PROD_URL = "https://data.opensha.org/tomcat/OpenSHA_26.1/";
        String DEV_URL = "https://opensha.scec.org/tomcat/OpenSHA_master/";
        if (hostName != null && !hostName.isEmpty()) {
            if (hostName.equalsIgnoreCase(OPENSHA_SERVER_PRODUCTION_HOST)) {
                PROD_URL = "http://localhost:8080/OpenSHA_26.1/";
            }
            if (hostName.equalsIgnoreCase(OPENSHA_SERVER_DEV_HOST)) {
                DEV_URL = "http://localhost:8080/OpenSHA_master/";
            }
        }
        OPENSHA_SERVLET_PRODUCTION_URL = PROD_URL;
        OPENSHA_SERVLET_DEV_URL = DEV_URL;
        SERVER_PREFS = ServerPrefs.DEV_PREFS;
    }
}

